/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.types.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.polarsys.reqcycle.types.IInjectedTypeChecker;
import org.polarsys.reqcycle.types.IInjectedTypeProvider;
import org.polarsys.reqcycle.types.IType;
import org.polarsys.reqcycle.types.ITypeChecker;
import org.polarsys.reqcycle.types.ITypesManager;
import org.polarsys.reqcycle.types.impl.ExtensionPointReader;
import org.polarsys.reqcycle.types.impl.Type;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

@Singleton
public class TypesManager
implements ITypesManager {
    static Map<String, IType> allTypes = new ExtensionPointReader().read();
    Set<IInjectedTypeProvider> providers = new HashSet<IInjectedTypeProvider>();

    @Override
    public Iterable<IType> getAllTypes() {
        Iterable transform = Iterables.transform(this.providers, (Function)new ProviderToITypes());
        Iterable result = Iterables.concat((Iterable)transform);
        return Iterables.unmodifiableIterable((Iterable)Iterables.concat(allTypes.values(), (Iterable)result));
    }

    @Override
    public IType getType(final String id) {
        IType result = allTypes.get(id);
        if (result == null) {
            result = (IType)Iterables.find((Iterable)Iterables.concat((Iterable)Iterables.transform(this.providers, (Function)new ProviderToITypes())), (Predicate)new Predicate<IType>(){

                public boolean apply(IType t) {
                    return id.equals(t.getId());
                }
            }, null);
        }
        return result;
    }

    @Override
    public Iterable<IType> getAllApplicableTypes(Reachable reachable) {
        ArrayDeque<IType> result = new ArrayDeque<IType>();
        Iterable<IType> iterable = this.getAllTypes();
        for (IType t : iterable) {
            if (!t.is(reachable)) continue;
            result.add(t);
        }
        return result;
    }

    @Override
    public IType newInjectedType(String id, IType parent, IInjectedTypeChecker.IValueInjecter injecter) {
        InjectedType newType = new InjectedType(id, parent, injecter);
        ZigguratInject.inject((Object[])new Object[]{newType});
        return newType;
    }

    @Override
    public void addTypeProvider(IInjectedTypeProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public void removeTypeProvider(IInjectedTypeProvider provider) {
        this.providers.remove(provider);
    }

    private class InjectedType
    extends Type {
        private IInjectedTypeChecker.IValueInjecter injecter;

        public InjectedType(String id, IType parent, IInjectedTypeChecker.IValueInjecter injecter) {
            super(id, parent);
            this.injecter = injecter;
        }

        @Override
        public String getLabel() {
            String superLabel = super.getLabel();
            return String.valueOf(superLabel) + " (" + this.getId() + ")";
        }

        @Override
        protected ITypeChecker getChecker() {
            if (this.instance == null) {
                if (this.getSuperType().isExtensible()) {
                    try {
                        ITypeChecker iTypeChecker = this.instance = this.getCheckerClass().newInstance();
                        ZigguratInject.inject((Object[])new Object[]{iTypeChecker});
                        List<Field> fields = this.getFieldsToInject();
                        for (Field f : fields) {
                            boolean oldAccess = f.isAccessible();
                            if (!oldAccess) {
                                f.setAccessible(true);
                            }
                            f.set(this.instance, this.injecter.getValue(this.getId(), f.getName(), f.getType()));
                            if (oldAccess) continue;
                            f.setAccessible(false);
                        }
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                } else {
                    this.instance = super.getChecker();
                }
            }
            return this.instance;
        }

        @Override
        public boolean is(Reachable reachable) {
            return super.is(reachable);
        }

        @Override
        public boolean isExtensible() {
            return false;
        }
    }

    private class ProviderToITypes
    implements Function<IInjectedTypeProvider, Iterable<IType>> {
        private ProviderToITypes() {
        }

        public Iterable<IType> apply(IInjectedTypeProvider p) {
            return p.getTypes();
        }
    }
}

