/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.types.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.polarsys.reqcycle.types.ICachedTypedChecker;
import org.polarsys.reqcycle.types.ITypeChecker;
import org.polarsys.reqcycle.types.impl.cache.ReachableStruct;
import org.polarsys.reqcycle.types.impl.cache.TypeCouple;
import org.polarsys.reqcycle.uri.IReachableListener;
import org.polarsys.reqcycle.uri.IReachableListenerManager;
import org.polarsys.reqcycle.uri.model.Reachable;

@Singleton
public class CachedTypeChecker
implements ICachedTypedChecker,
IReachableListener {
    @Inject
    IReachableListenerManager listener;
    Map<Reachable, ReachableStruct> allResources = new HashMap<Reachable, ReachableStruct>();
    Cache<Reachable, ReachableStruct> cache = CacheBuilder.newBuilder().expireAfterAccess(30000L, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<Reachable, ReachableStruct>(){

        public void onRemoval(RemovalNotification<Reachable, ReachableStruct> arg0) {
            ((ReachableStruct)arg0.getValue()).clear();
            CachedTypeChecker.this.listener.removeReachableListener((IReachableListener)CachedTypeChecker.this, (Reachable)arg0.getKey());
        }
    }).build();

    @Override
    public boolean is(Reachable reachable, ITypeChecker typeChecker) {
        final Reachable trimFragment = reachable.trimFragment();
        try {
            TypeCouple couple;
            ReachableStruct res = (ReachableStruct)this.cache.get((Object)trimFragment, (Callable)new Callable<ReachableStruct>(){

                @Override
                public ReachableStruct call() throws Exception {
                    ReachableStruct res = new ReachableStruct(trimFragment);
                    CachedTypeChecker.this.listener.addReachableListener(trimFragment, (IReachableListener)CachedTypeChecker.this);
                    return res;
                }
            });
            if (res == null) {
                this.allResources.put(trimFragment, res);
            }
            if (res.contains(couple = new TypeCouple(reachable, typeChecker))) {
                couple = res.get(couple);
                return couple.getResult();
            }
            boolean result = typeChecker.apply(reachable);
            couple.setResult(result);
            res.add(couple);
            return result;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return typeChecker.apply(reachable);
        }
    }

    public void hasChanged(Reachable[] reachables) {
        Reachable[] reachableArray = reachables;
        int n = reachables.length;
        int n2 = 0;
        while (n2 < n) {
            Reachable reachable = reachableArray[n2];
            ReachableStruct get = (ReachableStruct)this.cache.getIfPresent((Object)reachable);
            if (get != null) {
                get.clear();
            }
            this.cache.invalidate((Object)reachable);
            this.listener.removeReachableListener((IReachableListener)this, reachable);
            ++n2;
        }
    }
}

