/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.cache.storagebased.engine.pickers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.storage.ITraceabilityStorage;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.iterators.exceptions.PickerExecutionException;
import org.polarsys.reqcycle.utils.iterators.pickers.IPicker;

public class GetTraceabilityPicker
implements IPicker {
    private ITraceabilityEngine.DIRECTION direction;
    private ITraceabilityStorage storage;
    private Predicate<Pair<Link, Reachable>> predicate;

    public GetTraceabilityPicker(ITraceabilityEngine.DIRECTION d, ITraceabilityStorage storage, Predicate<Pair<Link, Reachable>> predicate) {
        this.direction = d;
        this.storage = storage;
        this.predicate = predicate;
    }

    public Iterable<?> getNexts(Object element) throws PickerExecutionException {
        if (element instanceof Reachable) {
            Reachable r = (Reachable)element;
            return this.getTraceability(r, this.direction);
        }
        if (element instanceof Pair) {
            return this.getNexts(((Pair)element).getSecond());
        }
        return null;
    }

    private Iterable<Pair<Link, Reachable>> getTraceability(Reachable source, ITraceabilityEngine.DIRECTION direction) {
        Iterable result = this.storage.getTraceability(source, direction);
        return Iterables.filter((Iterable)result, this.predicate);
    }
}

