/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.update.preferences;

import java.util.regex.Pattern;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.polarsys.reqcycle.repository.connector.update.preferences.PreferenceController;

public class UpdateJobPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private DataBindingContext m_bindingContext;
    private Button btnBrowse;
    protected int currentRefresh;
    private Text refreshTime;
    private Text pathForImpactAnalysis;
    private Button btnCheckButton;
    private static Pattern TIME_PATTERN = Pattern.compile("\\d*");
    private Label lblRefreshTimeseconds;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite top = new Composite(parent, 0);
        top.setLayoutData((Object)new GridData(4, 4, true, true));
        top.setLayout((Layout)new GridLayout(1, false));
        Group grpReferenceUpdate = new Group(top, 0);
        grpReferenceUpdate.setLayout((Layout)new GridLayout(3, false));
        grpReferenceUpdate.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        grpReferenceUpdate.setText("Reference Update");
        this.lblRefreshTimeseconds = new Label((Composite)grpReferenceUpdate, 0);
        this.lblRefreshTimeseconds.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblRefreshTimeseconds.setText("refresh time (seconds) : ");
        this.refreshTime = new Text((Composite)grpReferenceUpdate, 2048);
        this.refreshTime.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (UpdateJobPreferencePage.this.refreshTime.getText() == null || UpdateJobPreferencePage.this.refreshTime.getText().isEmpty() || !TIME_PATTERN.matcher(UpdateJobPreferencePage.this.refreshTime.getText()).matches()) {
                    UpdateJobPreferencePage.this.setErrorMessage("please fill a numeric value");
                } else {
                    UpdateJobPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.refreshTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Group grpImpactAnalysis = new Group(top, 0);
        grpImpactAnalysis.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpImpactAnalysis.setText("Impact Analysis");
        grpImpactAnalysis.setLayout((Layout)new GridLayout(3, false));
        this.btnCheckButton = new Button((Composite)grpImpactAnalysis, 32);
        this.btnCheckButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnCheckButton.setText("save impact analysis model");
        new Label((Composite)grpImpactAnalysis, 0);
        new Label((Composite)grpImpactAnalysis, 0);
        this.btnCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean newValue = UpdateJobPreferencePage.this.btnCheckButton.getSelection();
                UpdateJobPreferencePage.this.pathForImpactAnalysis.setEnabled(false);
                UpdateJobPreferencePage.this.btnBrowse.setEnabled(newValue);
                if (newValue && (UpdateJobPreferencePage.this.pathForImpactAnalysis.getText() == null || UpdateJobPreferencePage.this.pathForImpactAnalysis.getText().isEmpty())) {
                    UpdateJobPreferencePage.this.setErrorMessage("please fill a path");
                } else if (!newValue) {
                    UpdateJobPreferencePage.this.setErrorMessage(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.pathForImpactAnalysis = new Text((Composite)grpImpactAnalysis, 2048);
        this.pathForImpactAnalysis.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.pathForImpactAnalysis.setEnabled(this.btnCheckButton.getSelection());
        this.pathForImpactAnalysis.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (UpdateJobPreferencePage.this.pathForImpactAnalysis.getText() == null || UpdateJobPreferencePage.this.pathForImpactAnalysis.getText().isEmpty()) {
                    UpdateJobPreferencePage.this.setErrorMessage("please fill a path");
                } else {
                    UpdateJobPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.btnBrowse = new Button((Composite)grpImpactAnalysis, 0);
        this.btnBrowse.setText("...");
        this.btnBrowse.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.btnBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContainerSelectionDialog container = new ContainerSelectionDialog(UpdateJobPreferencePage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, "Please choose a folder for impact analysis models save");
                if (container.open() == 0) {
                    UpdateJobPreferencePage.this.pathForImpactAnalysis.setText(container.getResult()[0].toString());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnBrowse.setEnabled(this.btnCheckButton.getSelection());
        this.setDefaultValues();
        return parent;
    }

    private void setDefaultValues() {
        if (this.refreshTime.getText() == null || this.refreshTime.getText().isEmpty()) {
            this.refreshTime.setText(String.valueOf(PreferenceController.getRefreshTime()));
        }
        this.btnCheckButton.setSelection(PreferenceController.isImpactAnalysis());
        this.btnBrowse.setEnabled(false);
        if (this.btnCheckButton.getSelection()) {
            this.pathForImpactAnalysis.setText(PreferenceController.getPathForImpactAnalysis());
            this.pathForImpactAnalysis.setEnabled(false);
            this.btnBrowse.setEnabled(true);
        }
    }

    public boolean performOk() {
        PreferenceController.savePref(PreferenceController.PREF_IS_IMPACT_ANALYSIS, this.btnCheckButton.getSelection());
        PreferenceController.savePref(PreferenceController.PREF_REFRESH_TIME, Integer.parseInt(this.refreshTime.getText()));
        PreferenceController.savePref(PreferenceController.PREF_IMPACT_ANALYSIS, this.pathForImpactAnalysis.getText());
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setDefaultValues();
    }
}

