/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.impact.Impact.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.polarsys.reqcycle.impact.IVersionManager;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementsContainer;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.util.RequirementSourceDataResourceImpl;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

@Singleton
public class VersionManager
implements IVersionManager {
    @Inject
    IDataManager dataManager;

    public VersionManager() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    @Override
    public Map<RepositoryProvider, Collection<IFileRevision>> getHistory(RequirementSource requirementSource) {
        HashMap versions = Maps.newHashMap();
        IFile file = WorkspaceSynchronizer.getFile((Resource)requirementSource.getContents().eResource());
        IProject proj = file.getProject();
        String[] repoTypes = RepositoryProvider.getAllProviderTypeIds();
        ArrayList repos = Lists.newArrayList();
        String[] stringArray = repoTypes;
        int n = repoTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String repoType = stringArray[n2];
            RepositoryProvider repo = RepositoryProvider.getProvider((IProject)proj, (String)repoType);
            if (repo != null) {
                repos.add(repo);
            }
            ++n2;
        }
        for (RepositoryProvider repo : repos) {
            IFileHistory history = repo.getFileHistoryProvider().getFileHistoryFor((IResource)file, 0, null);
            if (history == null) continue;
            IFileRevision[] revs = history.getFileRevisions();
            versions.put(repo, Arrays.asList(revs));
        }
        return versions;
    }

    @Override
    public List<IFileState> getLocalHistory(RequirementSource requirementSource) {
        IFile file = WorkspaceSynchronizer.getFile((Resource)requirementSource.getContents().eResource());
        try {
            Object[] localHistory = file.getHistory(null);
            return Lists.newArrayList((Object[])localHistory);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public RequirementSource loadResource(IFileRevision rev, String dataModelURI, Scope scope, String resourceName) {
        IStorage storage = null;
        InputStream c = null;
        try {
            storage = rev.getStorage(null);
            c = storage.getContents();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        return this.loadResource(c, dataModelURI, scope, resourceName, URI.createURI((String)rev.getURI().toString()));
    }

    @Override
    public RequirementSource loadLocalHistoryResource(IFileState fileState, String dataModelURI, Scope scope, String resourceName) {
        InputStream input;
        try {
            input = fileState.getContents();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        return this.loadResource(input, dataModelURI, scope, resourceName, URI.createPlatformResourceURI((String)fileState.getFullPath().toString(), (boolean)true));
    }

    private RequirementSource loadResource(InputStream inputStream, String dataModelURI, Scope scope, String resourceName, URI fileURI) {
        RequirementSource source = null;
        try {
            RequirementSourceDataResourceImpl resource = new RequirementSourceDataResourceImpl(fileURI);
            resource.load(inputStream, Collections.emptyMap());
            EList contents = resource.getContents();
            for (EObject eObject : contents) {
                if (!(eObject instanceof RequirementsContainer)) continue;
                source = this.dataManager.createRequirementSource();
                source.setName(resourceName);
                source.setDataModelURI(dataModelURI);
                source.setDefaultScope(scope);
                source.setContents((RequirementsContainer)eObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return source;
    }
}

