/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ui.collectionspropseditor.internal.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.polarsys.reqcycle.ui.collectionspropseditor.internal.components.CharSequenceValue;
import org.polarsys.reqcycle.ui.collectionspropseditor.internal.components.ItemValue;
import org.polarsys.reqcycle.ui.collectionspropseditor.internal.components.ItemValueEditingSupport;
import org.polarsys.reqcycle.ui.eattrpropseditor.api.AbstractPropsEditorComponent;

public class CollectionsPropsEditorComponent
extends AbstractPropsEditorComponent<Collection<Object>> {
    private TableViewer tableViewer;
    private final List<Object> enteredValues = new ArrayList<Object>();
    private final CustomViewerComparator comparator;

    public CollectionsPropsEditorComponent(String attributeName, Composite parent, int style) {
        super(null, parent, style);
        Label lblName = new Label((Composite)this, 0);
        lblName.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        lblName.setText(attributeName);
        this.setLayout((Layout)new GridLayout(4, false));
        this.initSimpleTableViewer(parent);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DefaultTableLabelProvider());
        this.comparator = new CustomViewerComparator();
        this.tableViewer.setComparator((ViewerComparator)this.comparator);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setSize(200, 0);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object obj = cell.getElement();
                if (obj instanceof ItemValue) {
                    cell.setText(obj.toString());
                } else if (obj instanceof Enumerator) {
                    cell.setText(((Enumerator)obj).getLiteral());
                } else {
                    throw new IllegalArgumentException("Cannot update the cell label, unknown content type ...");
                }
            }
        });
        tableViewerColumn.setEditingSupport((EditingSupport)new ItemValueEditingSupport(this.tableViewer));
        TableColumn valuesColumn = tableViewerColumn.getColumn();
        valuesColumn.setText("values");
        valuesColumn.setResizable(true);
        valuesColumn.setMoveable(true);
        valuesColumn.setWidth(table.getSize().x);
        valuesColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(valuesColumn));
    }

    private void initSimpleTableViewer(Composite parent) {
        this.tableViewer = new TableViewer((Composite)this, 67586);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setInput(this.enteredValues);
        this.initTableMenu(this.tableViewer.getTable());
        Composite buttonsComposite = new Composite((Composite)this, 0);
        buttonsComposite.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        buttonsComposite.setLayout((Layout)new FillLayout(512));
        Button btnAdd = new Button(buttonsComposite, 0);
        btnAdd.setText("Add");
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CollectionsPropsEditorComponent.this.addNewItem();
            }
        });
        Button btnDelete = new Button(buttonsComposite, 0);
        btnDelete.setText("Delete");
        btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CollectionsPropsEditorComponent.this.removeSelectedItems();
            }
        });
    }

    private void initTableViewerForEEnum(Composite parent, EEnum eType) {
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2050);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        });
        ((CheckboxTableViewer)this.tableViewer).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object obj = event.getElement();
                if (obj instanceof EEnumLiteral) {
                    if (event.getChecked()) {
                        CollectionsPropsEditorComponent.this.enteredValues.add(((EEnumLiteral)obj).getInstance());
                    } else {
                        CollectionsPropsEditorComponent.this.enteredValues.remove(((EEnumLiteral)obj).getInstance());
                    }
                }
            }
        });
        this.tableViewer.setInput((Object)eType.getELiterals().toArray());
    }

    private void initTableMenu(Table table) {
        Menu menu = new Menu((Control)table);
        table.setMenu(menu);
        MenuItem menuItemAdd = new MenuItem(menu, 0);
        menuItemAdd.setText("Add");
        menuItemAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CollectionsPropsEditorComponent.this.addNewItem();
            }
        });
        MenuItem menuItemRemove = new MenuItem(menu, 0);
        menuItemRemove.setText("Remove");
        menuItemRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CollectionsPropsEditorComponent.this.removeSelectedItems();
            }
        });
    }

    private void addNewItem() {
        CharSequenceValue newValue = new CharSequenceValue("<enter a value>");
        this.enteredValues.add(newValue);
        this.tableViewer.refresh();
    }

    private void removeSelectedItems() {
        Table t = this.tableViewer.getTable();
        int[] nArray = t.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            Object obj = this.tableViewer.getElementAt(i);
            this.enteredValues.remove(obj);
            ++n2;
        }
        this.tableViewer.refresh();
    }

    public Collection<Object> getValue() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : this.enteredValues) {
            if (item instanceof ItemValue) {
                result.add(((ItemValue)item).getValue());
                continue;
            }
            if (item instanceof EEnumLiteral) {
                result.add(((EEnumLiteral)item).getLiteral());
                continue;
            }
            result.add(item);
        }
        return result;
    }

    public boolean isValid() {
        return true;
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CollectionsPropsEditorComponent.this.comparator.changeOrder();
                int dir = CollectionsPropsEditorComponent.this.comparator.getDirection();
                CollectionsPropsEditorComponent.this.tableViewer.getTable().setSortDirection(dir);
                CollectionsPropsEditorComponent.this.tableViewer.getTable().setSortColumn(column);
                CollectionsPropsEditorComponent.this.tableViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private class CustomViewerComparator
    extends ViewerComparator {
        private static final int DESCENDING = 1;
        private int direction = 1;

        public int getDirection() {
            return this.direction == 1 ? 1024 : 128;
        }

        public void changeOrder() {
            this.direction = 1 - this.direction;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int rc = 0;
            rc = e1 instanceof EEnumLiteral && e2 instanceof EEnumLiteral ? ((EEnumLiteral)e1).getLiteral().compareTo(((EEnumLiteral)e2).getLiteral()) : super.compare(viewer, e1, e2);
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }

    private class DefaultTableLabelProvider
    implements ITableLabelProvider {
        private DefaultTableLabelProvider() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof EEnumLiteral) {
                return ((EEnumLiteral)element).getLiteral();
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

