/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.ocl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.completeoclcs.ClassifierContextDeclCS;
import org.eclipse.ocl.xtext.completeoclcs.CompleteOCLDocumentCS;
import org.eclipse.ocl.xtext.completeoclcs.ContextDeclCS;
import org.eclipse.ocl.xtext.completeoclcs.DefOperationCS;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.polarsys.reqcycle.utils.ocl.OCLEvaluator;
import org.polarsys.reqcycle.utils.ocl.impl.OCLEvaluatorImpl;

public class ZigguratOCLPlugin
implements BundleActivator {
    private static BundleContext context;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    public static OCLEvaluator createOCLEvaluator() {
        return new OCLEvaluatorImpl();
    }

    public static OCLEvaluator compileOCL(ResourceSet resourceSet, URI oclURI) throws Exception {
        BaseCSResource resource = (BaseCSResource)resourceSet.getResource(oclURI, true);
        return ZigguratOCLPlugin.compileOCL(resource);
    }

    public static OCLEvaluator compileOCL(BaseCSResource resource) throws Exception {
        OCLEvaluator evaluator = ZigguratOCLPlugin.createOCLEvaluator();
        Collection<DefOperationCS> operations = ZigguratOCLPlugin.getOperations(resource);
        for (DefOperationCS operation : operations) {
            ZigguratOCLPlugin.compileOperation(evaluator, operation);
        }
        return evaluator;
    }

    private static void compileOperation(OCLEvaluator evaluator, DefOperationCS operationCS) throws Exception {
        ClassifierContextDeclCS classifierContextDecl = operationCS.getOwningClassifierContextDecl();
        Element pivot = classifierContextDecl.getPivot();
        String classifierString = pivot.toString();
        String[] split = classifierString.split("::");
        split[0] = split[0].toLowerCase();
        EClassifier classifier = evaluator.lookupEClassifier(Arrays.asList(split));
        String[] defNameExpression = operationCS.toString().split("def\\s*?:", 0);
        String defExpression = defNameExpression[1];
        try {
            evaluator.compileOperation(defExpression, classifier);
        }
        catch (SemanticException e) {
            String message = "Semantic error : " + operationCS.getName() + " - " + e.getMessage();
            throw new Exception(message);
        }
    }

    private static Collection<DefOperationCS> getOperations(BaseCSResource resource) {
        EObject root;
        ArrayList result = Lists.newArrayList();
        EList contents = resource.getContents();
        if (contents.size() == 1 && (root = (EObject)contents.get(0)) instanceof CompleteOCLDocumentCS) {
            EList contexts = ((CompleteOCLDocumentCS)root).getOwnedContexts();
            for (ContextDeclCS context : contexts) {
                if (!(context instanceof ContextDeclCS)) continue;
                EList definitions = ((ClassifierContextDeclCS)context).getOwnedDefinitions();
                Iterables.addAll((Collection)result, (Iterable)Iterables.filter((Iterable)definitions, DefOperationCS.class));
            }
        }
        return result;
    }
}

