/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs;

import com.google.common.collect.Lists;
import javax.inject.Inject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.types.ITraceTypesManager;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs.IconRegistry;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs.PictureChooserDialog;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.providers.PreferenceDialogTypeLabelProvider;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.providers.PreferenceDialogTypesContentProvider;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.CustomType;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Type;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeConfigContainer;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeconfigurationFactory;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.TypeconfigurationPackage;
import org.polarsys.reqcycle.types.ITypesManager;
import org.polarsys.reqcycle.types.ui.providers.TypeLabelProvider;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class NewRelationDialog
extends TitleAreaDialog {
    private Text textSource;
    private Text textTarget;
    private Relation rel = TypeconfigurationFactory.eINSTANCE.createRelation();
    private TreeViewer treeViewer;
    @Inject
    ITypesManager manager;
    @Inject
    ITraceTypesManager ttManager;
    private TypeConfigContainer container;
    private AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private Text textKind;
    private CheckboxTableViewer listOfTTViewer;
    private Label iconLabel;

    public NewRelationDialog(Shell parentShell, TypeConfigContainer container) {
        super(parentShell);
        this.setShellStyle(48);
        this.container = container;
    }

    protected void okPressed() {
        if (this.rel.getDownstreamType() == null || this.rel.getUpstreamType() == null || this.rel.getKind() == null) {
            this.setErrorMessage("Please fill all the parameters");
        } else {
            super.okPressed();
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Create a new Relation Type");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer(composite, 2048);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        composite_1.setLayout((Layout)new GridLayout(1, false));
        Button btnSource = new Button(composite_1, 0);
        btnSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object firstElement = ((IStructuredSelection)NewRelationDialog.this.treeViewer.getSelection()).getFirstElement();
                if (firstElement instanceof Type) {
                    Type type = (Type)firstElement;
                    NewRelationDialog.this.set(type, NewRelationDialog.this.textSource, TypeconfigurationPackage.Literals.RELATION__UPSTREAM_TYPE);
                }
            }
        });
        btnSource.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        btnSource.setText("Upstream");
        Button btnTarget = new Button(composite_1, 0);
        btnTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewRelationDialog.this.set((Type)((IStructuredSelection)NewRelationDialog.this.treeViewer.getSelection()).getFirstElement(), NewRelationDialog.this.textTarget, TypeconfigurationPackage.Literals.RELATION__DOWNSTREAM_TYPE);
            }
        });
        btnTarget.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnTarget.setText("Downstream");
        Group grpProperties = new Group(container, 0);
        grpProperties.setLayout((Layout)new GridLayout(3, false));
        grpProperties.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        grpProperties.setText("Properties");
        Label lblNewLabel_1 = new Label((Composite)grpProperties, 0);
        lblNewLabel_1.setText("Name : ");
        this.textKind = new Text((Composite)grpProperties, 2048);
        this.textKind.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.textKind.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewRelationDialog.this.rel.setKind(NewRelationDialog.this.textKind.getText());
            }
        });
        Label lblIcon = new Label((Composite)grpProperties, 0);
        lblIcon.setText("Icon : ");
        this.iconLabel = new Label((Composite)grpProperties, 0);
        this.iconLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.iconLabel.setText("No Icon selected");
        Button btnNewButton = new Button((Composite)grpProperties, 0);
        btnNewButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PictureChooserDialog d = new PictureChooserDialog(NewRelationDialog.this.getShell());
                if (d.open() == 0) {
                    NewRelationDialog.this.rel.setIcon(d.imageSelected);
                    NewRelationDialog.this.iconLabel.setImage(IconRegistry.getImage(NewRelationDialog.this.rel.getIcon()));
                }
            }
        });
        btnNewButton.setText("...");
        Label lblSource = new Label((Composite)grpProperties, 0);
        lblSource.setText("Upstream :");
        this.textSource = new Text((Composite)grpProperties, 2048);
        this.textSource.setEditable(false);
        this.textSource.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblNewLabel = new Label((Composite)grpProperties, 0);
        lblNewLabel.setText("Downstream :");
        this.textTarget = new Text((Composite)grpProperties, 2048);
        this.textTarget.setEditable(false);
        this.textTarget.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Group grpIncludedTraceability = new Group(container, 0);
        grpIncludedTraceability.setText("Included Traceability");
        grpIncludedTraceability.setLayout((Layout)new FillLayout(256));
        grpIncludedTraceability.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.listOfTTViewer = CheckboxTableViewer.newCheckList((Composite)grpIncludedTraceability, (int)2592);
        this.listOfTTViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                String id = ((TType)event.getElement()).getId();
                if (event.getChecked()) {
                    NewRelationDialog.this.rel.getAgregatedTypes().add((Object)id);
                } else {
                    NewRelationDialog.this.rel.getAgregatedTypes().remove((Object)id);
                }
            }
        });
        this.listOfTTViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listOfTTViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TType) {
                    TType ttype = (TType)element;
                    return ttype.getLabel();
                }
                return super.getText(element);
            }
        });
        this.listOfTTViewer.setInput((Object)Lists.newArrayList((Iterable)this.ttManager.getAllTTypes()));
        PreferenceDialogTypesContentProvider provider = new PreferenceDialogTypesContentProvider(this.adapterFactory, this.container);
        PreferenceDialogTypeLabelProvider labelProvider = new PreferenceDialogTypeLabelProvider(this.adapterFactory, (ILabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        ZigguratInject.inject((Object[])new Object[]{labelProvider, provider});
        this.treeViewer.setContentProvider((IContentProvider)provider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof TypeConfigContainer || element instanceof Type;
            }
        });
        this.treeViewer.setInput((Object)this.container.eResource());
        return area;
    }

    protected void set(Type type, Text aText, EReference relationDownstreamType) {
        if (type instanceof CustomType) {
            CustomType cust = (CustomType)type;
            aText.setText(cust.getTypeId());
        } else {
            aText.setText(new TypeLabelProvider().getText((Object)type.getIType()));
        }
        this.rel.eSet((EStructuralFeature)relationDownstreamType, (Object)type);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        int width = bounds.width * 3 / 5;
        int height = bounds.width * 4 / 5;
        return new Point(width, height);
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        int x = bounds.x + bounds.width * 1 / 5;
        int y = bounds.y + bounds.height * 1 / 5;
        return new Point(x, y);
    }

    public Relation getRelation() {
        return this.rel;
    }
}

