/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.operations.dialogs;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import javax.inject.Inject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.reqcycle.core.ui.dialogs.ValidatingTitleAreaDialog;
import org.polarsys.reqcycle.operations.IReqCycleOperationManager;
import org.polarsys.reqcycle.operations.ReqCycleOperation;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class SelectOperationDialog
extends ValidatingTitleAreaDialog {
    @Inject
    IReqCycleOperationManager reqCycleOperationlManager;
    private ListViewer listViewer;
    private Text text;
    protected ReqCycleOperation currentOperation;

    public SelectOperationDialog(Shell parent) {
        super(parent);
        this.setShellStyle(1168);
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.validateInput();
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Select Operation");
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        area.setLayout((Layout)new GridLayout(1, false));
        this.listViewer = new ListViewer(area, 2560);
        List list = this.listViewer.getList();
        GridData gd_list = new GridData(4, 4, true, true, 1, 1);
        gd_list.heightHint = 137;
        gd_list.widthHint = 433;
        list.setLayoutData((Object)gd_list);
        this.initProviders(this.listViewer);
        this.text = new Text(area, 2634);
        this.text.setEditable(false);
        GridData gd_text = new GridData(4, 4, true, false, 1, 1);
        gd_text.minimumHeight = 25;
        gd_text.widthHint = 352;
        gd_text.heightHint = 37;
        this.text.setLayoutData((Object)gd_text);
        return area;
    }

    private void initProviders(ListViewer list) {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object object) {
                if (object instanceof ReqCycleOperation) {
                    ReqCycleOperation reqCycleOp = (ReqCycleOperation)object;
                    String operation = reqCycleOp.getMethod().getName();
                    Class<?>[] paramList = reqCycleOp.getMethod().getParameterTypes();
                    operation = String.valueOf(operation) + "(";
                    if (paramList.length > 1) {
                        int i = 1;
                        while (i < paramList.length) {
                            Class<?> c = paramList[i];
                            if (i != 1) {
                                operation = String.valueOf(operation) + " ,";
                            }
                            operation = String.valueOf(operation) + c.getSimpleName();
                            ++i;
                        }
                    }
                    operation = String.valueOf(operation) + ")";
                    return operation;
                }
                return super.getText(object);
            }
        };
        ArrayContentProvider contentProvider = ArrayContentProvider.getInstance();
        list.setLabelProvider((IBaseLabelProvider)labelProvider);
        list.setContentProvider((IContentProvider)contentProvider);
        list.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectOperationDialog.this.validateInput();
                if (!SelectOperationDialog.this.listViewer.getSelection().isEmpty()) {
                    IStructuredSelection selection = (IStructuredSelection)SelectOperationDialog.this.listViewer.getSelection();
                    ReqCycleOperation op = (ReqCycleOperation)selection.getFirstElement();
                    SelectOperationDialog.this.text.setText("Description : " + op.getDescription());
                    SelectOperationDialog.this.currentOperation = op;
                }
            }
        });
        list.setInput((Object)Lists.newArrayList((Iterable)Ordering.natural().sortedCopy((Iterable)this.reqCycleOperationlManager.getAllOperations())));
    }

    public ValidatingTitleAreaDialog.IValidator getInputValidator() {
        return new ValidatingTitleAreaDialog.IValidator(){

            public String isValid() {
                if (SelectOperationDialog.this.listViewer.getSelection().isEmpty()) {
                    return "An operation must be selected";
                }
                return null;
            }
        };
    }

    public ReqCycleOperation getResult() {
        return this.currentOperation;
    }
}

