/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.ui.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.predicates.core.util.PredicatesUtil;
import org.polarsys.reqcycle.predicates.persistance.util.IPredicatesConfManager;
import org.polarsys.reqcycle.predicates.ui.dialogs.NewPredicateDialog;
import org.polarsys.reqcycle.predicates.ui.listeners.CustomPredicatesTreeViewerDragAdapter;
import org.polarsys.reqcycle.predicates.ui.presentation.PredicatesEditor;
import org.polarsys.reqcycle.predicates.ui.providers.PredicatesTableLabelProvider;
import org.polarsys.reqcycle.styling.manager.IStylingManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class RightPanelComposite
extends Composite {
    private ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final PredicatesEditor predicatesEditor;
    private TableViewer tableViewerOfDefautPredicates;
    private TableViewer tableViewerOfCustomPredicates;
    IPredicatesConfManager predicatesConfManager = (IPredicatesConfManager)ZigguratInject.make(IPredicatesConfManager.class);
    IStylingManager stylingManager = (IStylingManager)ZigguratInject.make(IStylingManager.class);
    private Button buttonRemove;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonSave;
    private Button buttonFinish;
    protected TableItem editedItem;
    protected boolean editionMode = false;

    public RightPanelComposite(Composite parent, PredicatesEditor editor) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(1, false));
        this.predicatesEditor = editor;
        SashForm form = new SashForm((Composite)this, 512);
        form.setLayout((Layout)new GridLayout());
        form.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createGroupOfDefaultPredicates((Composite)form);
        this.createGroupOfCustomPredicates((Composite)form);
    }

    protected Collection<EPackage> getAllPackages(Resource resource) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        EcoreUtil.ContentTreeIterator<Object> j = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                return eObject instanceof EPackage ? ((EPackage)eObject).getESubpackages().iterator() : Collections.emptyList().iterator();
            }
        };
        while (j.hasNext()) {
            Object content = j.next();
            if (!(content instanceof EPackage)) continue;
            result.add((EPackage)content);
        }
        return result;
    }

    private void createGroupOfDefaultPredicates(Composite parent) {
        Group grpDefaultPredicates = new Group(parent, 0);
        grpDefaultPredicates.setText("Default Predicates");
        grpDefaultPredicates.setLayout((Layout)new GridLayout(1, false));
        grpDefaultPredicates.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewerOfDefautPredicates = new TableViewer((Composite)grpDefaultPredicates);
        Table tableOfDefaultPredicates = this.tableViewerOfDefautPredicates.getTable();
        TableLayout tableLayout = new TableLayout();
        tableOfDefaultPredicates.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        tableOfDefaultPredicates.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tableOfDefaultPredicates.setHeaderVisible(false);
        tableOfDefaultPredicates.setLinesVisible(false);
        TableViewerColumn column = new TableViewerColumn(this.tableViewerOfDefautPredicates, 0);
        column.getColumn().setResizable(true);
        this.tableViewerOfDefautPredicates.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return PredicatesUtil.getDefaultPredicates().toArray();
            }
        });
        this.tableViewerOfDefautPredicates.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.tableViewerOfDefautPredicates.setInput(new Object());
        Transfer[] transferTypes = new Transfer[]{LocalTransfer.getInstance()};
        this.tableViewerOfDefautPredicates.addDragSupport(3, transferTypes, (DragSourceListener)new ViewerDragAdapter((Viewer)this.tableViewerOfDefautPredicates){});
    }

    private void createGroupOfCustomPredicates(Composite parent) {
        Group grpCustomPredicates = new Group(parent, 0);
        grpCustomPredicates.setLayout((Layout)new GridLayout(1, false));
        grpCustomPredicates.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpCustomPredicates.setText("Custom Predicates");
        this.tableViewerOfCustomPredicates = new TableViewer((Composite)grpCustomPredicates, 67586);
        Table tableOfCustomPredicates = this.tableViewerOfCustomPredicates.getTable();
        tableOfCustomPredicates.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        tableOfCustomPredicates.setLayout((Layout)tableLayout);
        TableViewerColumn column = new TableViewerColumn(this.tableViewerOfCustomPredicates, 0);
        column.getColumn().setResizable(true);
        this.tableViewerOfCustomPredicates.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return RightPanelComposite.this.predicatesConfManager.getPredicates(false).toArray();
            }
        });
        this.tableViewerOfCustomPredicates.setLabelProvider((IBaseLabelProvider)new PredicatesTableLabelProvider());
        this.tableViewerOfCustomPredicates.setInput((Object)this.predicatesConfManager.getPredicates(false));
        this.tableViewerOfCustomPredicates.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!RightPanelComposite.this.editionMode) {
                    ISelection selection = event.getSelection();
                    boolean isEmptySelection = selection == null || event.getSelection().isEmpty();
                    boolean isMultySelection = false;
                    if (!isEmptySelection && selection instanceof IStructuredSelection) {
                        boolean bl = isMultySelection = ((IStructuredSelection)selection).size() > 1;
                    }
                    if (RightPanelComposite.this.buttonRemove != null) {
                        RightPanelComposite.this.buttonRemove.setEnabled(!isEmptySelection);
                    }
                    if (RightPanelComposite.this.buttonEdit != null) {
                        RightPanelComposite.this.buttonEdit.setEnabled(!isEmptySelection && !isMultySelection);
                    }
                }
            }
        });
        Transfer[] transferTypes = new Transfer[]{LocalTransfer.getInstance()};
        this.tableViewerOfCustomPredicates.addDragSupport(3, transferTypes, (DragSourceListener)new CustomPredicatesTreeViewerDragAdapter((Viewer)this.tableViewerOfCustomPredicates){});
        Composite compositeButtons = new Composite((Composite)grpCustomPredicates, 0);
        compositeButtons.setLayout((Layout)new GridLayout(5, false));
        compositeButtons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.buttonAdd = new Button(compositeButtons, 0);
        this.buttonAdd.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        this.buttonAdd.setToolTipText("Add new predicate");
        this.buttonAdd.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.reqcycle.predicates.ui", (String)"/icons/full/obj16/add_obj.gif").createImage());
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!RightPanelComposite.this.createNewPredicate(RightPanelComposite.this.getShell())) {
                    return;
                }
                RightPanelComposite.this.editionMode = true;
                RightPanelComposite.this.buttonAdd.setEnabled(false);
                if (RightPanelComposite.this.buttonRemove != null) {
                    RightPanelComposite.this.buttonRemove.setEnabled(false);
                }
                if (RightPanelComposite.this.buttonEdit != null) {
                    RightPanelComposite.this.buttonEdit.setEnabled(false);
                }
                if (RightPanelComposite.this.buttonSave != null) {
                    RightPanelComposite.this.buttonSave.setEnabled(true);
                }
                if (RightPanelComposite.this.buttonFinish != null) {
                    RightPanelComposite.this.buttonFinish.setEnabled(true);
                }
            }
        });
        this.buttonRemove = new Button(compositeButtons, 0);
        this.buttonRemove.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        this.buttonRemove.setToolTipText("Remove the selected predicates");
        this.buttonRemove.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.reqcycle.predicates.ui", (String)"/icons/full/obj16/delete_obj.gif").createImage());
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                if (RightPanelComposite.this.tableViewerOfCustomPredicates.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)RightPanelComposite.this.tableViewerOfCustomPredicates.getSelection()) != null && !selection.isEmpty()) {
                    ArrayList<IPredicate> predicatesToRemove = new ArrayList<IPredicate>();
                    for (Object currentObj : selection) {
                        if (!(currentObj instanceof IPredicate)) continue;
                        IPredicate predicate = (IPredicate)currentObj;
                        predicatesToRemove.add(predicate);
                    }
                    StringBuilder confirmMessage = new StringBuilder("Do you really want to remove the following predicates (Styling Models associated to these predicates will also be removed) :");
                    String lineSeparator = System.getProperty("line.separator");
                    confirmMessage.append(lineSeparator).append(lineSeparator);
                    for (IPredicate p : predicatesToRemove) {
                        confirmMessage.append(" - ").append(p.getDisplayName()).append(lineSeparator);
                    }
                    boolean confirmRemoval = MessageDialog.openConfirm((Shell)RightPanelComposite.this.getShell(), (String)"Remove predicates", (String)confirmMessage.toString());
                    if (confirmRemoval) {
                        for (IPredicate p : predicatesToRemove) {
                            boolean removed = RightPanelComposite.this.predicatesConfManager.removePredicate(p);
                            if (removed) {
                                RightPanelComposite.this.predicatesConfManager.save();
                                RightPanelComposite.this.tableViewerOfCustomPredicates.refresh();
                            } else {
                                MessageDialog.openError((Shell)RightPanelComposite.this.getShell(), (String)"Removal Error", (String)("Unable to remove the predicate : " + p.getDisplayName()));
                            }
                            RightPanelComposite.this.stylingManager.suppressUselessPredicates();
                        }
                    }
                }
            }
        });
        this.buttonEdit = new Button(compositeButtons, 0);
        this.buttonEdit.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        this.buttonEdit.setToolTipText("Edit the selected predicate");
        this.buttonEdit.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.reqcycle.predicates.ui", (String)"/icons/full/obj16/edit_obj.png").createImage());
        this.buttonEdit.setEnabled(false);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = RightPanelComposite.this.tableViewerOfCustomPredicates.getTable().getItem(RightPanelComposite.this.tableViewerOfCustomPredicates.getTable().getSelectionIndex());
                item.setBackground(new Color((Device)RightPanelComposite.this.getDisplay(), 255, 255, 255));
                RightPanelComposite.this.tableViewerOfCustomPredicates.refresh();
                RightPanelComposite.this.editedItem = item;
                Object data = item.getData();
                if (RightPanelComposite.this.predicatesEditor != null && data instanceof IPredicate && RightPanelComposite.this.predicatesEditor.setRootPredicate((IPredicate)EcoreUtil.copy((EObject)((IPredicate)data)))) {
                    RightPanelComposite.this.predicatesEditor.setEditorTitle(((IPredicate)data).getDisplayName());
                    RightPanelComposite.this.editionMode = true;
                    RightPanelComposite.this.buttonEdit.setEnabled(false);
                    if (RightPanelComposite.this.buttonAdd != null) {
                        RightPanelComposite.this.buttonAdd.setEnabled(false);
                    }
                    if (RightPanelComposite.this.buttonRemove != null) {
                        RightPanelComposite.this.buttonRemove.setEnabled(false);
                    }
                    if (RightPanelComposite.this.buttonSave != null) {
                        RightPanelComposite.this.buttonSave.setEnabled(true);
                    }
                    if (RightPanelComposite.this.buttonFinish != null) {
                        RightPanelComposite.this.buttonFinish.setEnabled(true);
                    }
                }
            }
        });
        this.buttonSave = new Button(compositeButtons, 0);
        this.buttonSave.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        this.buttonSave.setToolTipText("Save the edited predicate");
        this.buttonSave.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.reqcycle.predicates.ui", (String)"/icons/full/obj16/Save_obj.gif").createImage());
        this.buttonSave.setEnabled(false);
        this.buttonSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RightPanelComposite.this.editedItem != null) {
                    RightPanelComposite.this.editedItem.setBackground(new Color((Device)RightPanelComposite.this.getDisplay(), 255, 255, 255));
                    RightPanelComposite.this.editedItem = null;
                    RightPanelComposite.this.tableViewerOfCustomPredicates.refresh();
                }
                RightPanelComposite.this.predicatesEditor.doSave((IProgressMonitor)new NullProgressMonitor());
                RightPanelComposite.this.buttonSave.setEnabled(true);
                if (RightPanelComposite.this.buttonAdd != null) {
                    RightPanelComposite.this.buttonAdd.setEnabled(false);
                }
                if (RightPanelComposite.this.buttonRemove != null) {
                    RightPanelComposite.this.buttonRemove.setEnabled(false);
                }
                if (RightPanelComposite.this.buttonEdit != null) {
                    RightPanelComposite.this.buttonEdit.setEnabled(false);
                }
                if (RightPanelComposite.this.buttonFinish != null) {
                    RightPanelComposite.this.buttonFinish.setEnabled(true);
                }
            }
        });
        this.buttonFinish = new Button(compositeButtons, 0);
        this.buttonFinish.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
        this.buttonFinish.setToolTipText("Finish the current edition and clear the editor");
        this.buttonFinish.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.reqcycle.predicates.ui", (String)"/icons/full/obj16/broom.png").createImage());
        this.buttonFinish.setEnabled(false);
        this.buttonFinish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RightPanelComposite.this.predicatesEditor != null && RightPanelComposite.this.predicatesEditor.setRootPredicate(null)) {
                    RightPanelComposite.this.predicatesEditor.setEditorTitle("");
                    RightPanelComposite.this.editionMode = false;
                    RightPanelComposite.this.buttonFinish.setEnabled(false);
                    if (RightPanelComposite.this.buttonAdd != null) {
                        RightPanelComposite.this.buttonAdd.setEnabled(true);
                    }
                    if (RightPanelComposite.this.buttonRemove != null) {
                        RightPanelComposite.this.buttonRemove.setEnabled(true);
                    }
                    if (RightPanelComposite.this.buttonEdit != null) {
                        RightPanelComposite.this.buttonEdit.setEnabled(true);
                    }
                    if (RightPanelComposite.this.buttonSave != null) {
                        RightPanelComposite.this.buttonSave.setEnabled(false);
                    }
                }
                RightPanelComposite.this.tableViewerOfCustomPredicates.refresh();
            }
        });
    }

    public void addPredicate(IPredicate newPredicate) {
        if (this.tableViewerOfCustomPredicates != null) {
            this.tableViewerOfCustomPredicates.add((Object)newPredicate);
            this.tableViewerOfCustomPredicates.setSelection((ISelection)new StructuredSelection((Object)newPredicate));
        }
    }

    public boolean createNewPredicate(Shell shell) {
        NewPredicateDialog dialog = new NewPredicateDialog(shell);
        boolean added = false;
        if (dialog.open() == 0) {
            String name = dialog.getName();
            IPredicate rootPredicate = dialog.getRootPredicate();
            IPredicate newPredicate = (IPredicate)EcoreUtil.copy((EObject)rootPredicate);
            newPredicate.setDisplayName(name);
            this.predicatesEditor.setRootPredicate((IPredicate)EcoreUtil.copy((EObject)newPredicate));
            this.predicatesEditor.setEditorTitle(newPredicate.getDisplayName());
            this.predicatesEditor.setDirty(false);
            added = this.predicatesConfManager.storePredicate(newPredicate);
            if (added) {
                this.addPredicate(newPredicate);
            } else if (!added) {
                MessageDialog.openError((Shell)shell, (String)"Error adding predicate", (String)("Unable to add the predicate : " + newPredicate.getDisplayName()));
            }
        }
        return added;
    }
}

