/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.styling.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.polarsys.reqcycle.core.ui.dialogs.ValidatingTitleAreaDialog;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class SelectModelDialog
extends ValidatingTitleAreaDialog {
    @Inject
    IDataModelManager dataModelManager;
    private FilteredTree filteredTree;
    private TreeViewer treeViewer;
    protected String currentAttribute;

    public SelectModelDialog(Shell parent) {
        super(parent);
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.validateInput();
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Select Model");
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        area.setLayout((Layout)new GridLayout(1, false));
        PatternFilter filter = new PatternFilter();
        this.filteredTree = new FilteredTree(area, 772, filter, true);
        this.treeViewer = this.filteredTree.getViewer();
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer.setContentProvider((IContentProvider)new EClassContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new EClassLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectModelDialog.this.validateInput();
                if (((IStructuredSelection)event.getSelection()).getFirstElement() instanceof IAttribute) {
                    IAttribute att = (IAttribute)((IStructuredSelection)event.getSelection()).getFirstElement();
                    SelectModelDialog.this.currentAttribute = att.getName();
                } else if (((IStructuredSelection)event.getSelection()).getFirstElement() instanceof EAttribute) {
                    EAttribute att = (EAttribute)((IStructuredSelection)event.getSelection()).getFirstElement();
                    SelectModelDialog.this.currentAttribute = att.getName();
                }
            }
        });
        ArrayList<Object> input = new ArrayList<Object>();
        for (IDataModel dataModel : this.dataModelManager.getCurrentDataModels()) {
            Collection list = dataModel.getTypes();
            for (IType type : list) {
                if (!(type instanceof IRequirementType)) continue;
                input.add(type);
            }
            String sourceConf = "http://www.polarsys.org/ReqCycle/RequirementSourceConf";
            Object objConf = EPackage.Registry.INSTANCE.get((Object)sourceConf);
            Collection<EClass> classesConf = this.getAllEClasses((EPackage)objConf);
            input.addAll(classesConf);
            String sourceData = "http://www.polarsys.org/ReqCycle/RequirementSourceData";
            Object objData = EPackage.Registry.INSTANCE.get((Object)sourceData);
            Collection<EClass> classesData = this.getAllEClasses((EPackage)objData);
            input.addAll(classesData);
        }
        this.treeViewer.setInput(input);
        return area;
    }

    protected Collection<EClass> getAllEClasses(EPackage obj) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EClassifier eClassifier : obj.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            result.add((EClass)eClassifier);
        }
        for (EPackage ePackage : obj.getESubpackages()) {
            result.addAll(this.getAllEClasses(ePackage));
        }
        return result;
    }

    public ValidatingTitleAreaDialog.IValidator getInputValidator() {
        return new ValidatingTitleAreaDialog.IValidator(){

            public String isValid() {
                if (SelectModelDialog.this.treeViewer.getSelection().isEmpty()) {
                    return "An attribute must be selected";
                }
                IStructuredSelection selection = (IStructuredSelection)SelectModelDialog.this.treeViewer.getSelection();
                if (!(selection.getFirstElement() instanceof IAttribute) && !(selection.getFirstElement() instanceof EAttribute)) {
                    return "An attribute must be selected";
                }
                return null;
            }
        };
    }

    public String getResult() {
        return this.currentAttribute;
    }

    private class EClassContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ArrayContentProvider.getInstance().getElements(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IRequirementType) {
                return ((IRequirementType)parentElement).getAttributes().toArray();
            }
            if (parentElement instanceof EClass) {
                return ((EClass)parentElement).getEAllAttributes().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IRequirementType) {
                Collection attr = ((IRequirementType)element).getAttributes();
                return attr.size() > 0;
            }
            if (element instanceof EClass) {
                EList attr = ((EClass)element).getEAllAttributes();
                return attr.size() > 0;
            }
            return false;
        }
    }

    private class EClassLabelProvider
    extends LabelProvider {
        private EClassLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IRequirementType) {
                return ((IRequirementType)element).getName();
            }
            if (element instanceof IAttribute) {
                return ((IAttribute)element).getName();
            }
            if (element instanceof EClass) {
                return ((EClass)element).getName();
            }
            if (element instanceof EAttribute) {
                return ((EAttribute)element).getName();
            }
            return super.getText(element);
        }
    }
}

