/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.styling.ui.dialogs;

import java.lang.reflect.Method;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import org.polarsys.reqcycle.core.ui.dialogs.ValidatingTitleAreaDialog;
import org.polarsys.reqcycle.operations.IReqCycleOperationManager;
import org.polarsys.reqcycle.operations.ReqCycleOperation;
import org.polarsys.reqcycle.operations.dialogs.OperationAttributesEditor;
import org.polarsys.reqcycle.operations.dialogs.SelectOperationDialog;
import org.polarsys.reqcycle.styling.model.Styling.BooleanParameter;
import org.polarsys.reqcycle.styling.model.Styling.ConstantPattern;
import org.polarsys.reqcycle.styling.model.Styling.EObjectParameter;
import org.polarsys.reqcycle.styling.model.Styling.FontOption;
import org.polarsys.reqcycle.styling.model.Styling.IntParameter;
import org.polarsys.reqcycle.styling.model.Styling.ModelPattern;
import org.polarsys.reqcycle.styling.model.Styling.OperationPattern;
import org.polarsys.reqcycle.styling.model.Styling.Parameter;
import org.polarsys.reqcycle.styling.model.Styling.Pattern;
import org.polarsys.reqcycle.styling.model.Styling.Segment;
import org.polarsys.reqcycle.styling.model.Styling.StringParameter;
import org.polarsys.reqcycle.styling.model.Styling.StylingFactory;
import org.polarsys.reqcycle.styling.ui.dialogs.SelectModelDialog;
import org.polarsys.reqcycle.ui.eattrpropseditor.GenericEAttrPropsEditor;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class SegmentEditorDialog
extends ValidatingTitleAreaDialog {
    @Inject
    IReqCycleOperationManager reqCycleOperationlManager;
    private Segment segment;
    private Text constantText;
    private Text modelText;
    private Text operationText;
    private StyleRange style;
    private StyledText styledText;
    private Button btnItallic;
    private Button btnBold;
    private Button btnUnderline;
    private Button btnStrike;
    private Button btnLoadResources;
    private Button btnOperation;
    private Button btnEditOperation;
    private Button constantButton;
    private Button modelButton;
    private Button operationButton;
    private Method method;
    private ColorSelector colorSelector;

    public SegmentEditorDialog(Shell parentShell, Segment segmentToEdit) {
        super(parentShell);
        this.segment = segmentToEdit;
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Segment editor");
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        area.setLayout((Layout)new GridLayout(8, false));
        Label lblColor = new Label(area, 0);
        lblColor.setText("Color :");
        this.colorSelector = new ColorSelector(area);
        this.colorSelector.setColorValue(new RGB(this.segment.getColor().getRed(), this.segment.getColor().getGreen(), this.segment.getColor().getBlue()));
        this.colorSelector.getButton().setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 7, 1));
        this.colorSelector.getButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SegmentEditorDialog.this.segment.setColor(new Color((Device)Display.getDefault(), SegmentEditorDialog.this.colorSelector.getColorValue()));
                SegmentEditorDialog.this.handleStyle();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblFont = new Label(area, 0);
        lblFont.setText("Font :");
        this.btnItallic = new Button(area, 32);
        this.btnItallic.setText("I");
        if (this.segment.getStyle().getAppliedFonts().contains((Object)FontOption.ITALIC)) {
            this.btnItallic.setSelection(true);
        }
        this.btnItallic.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SegmentEditorDialog.this.handleStyle();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnBold = new Button(area, 32);
        this.btnBold.setText("B");
        if (this.segment.getStyle().getAppliedFonts().contains((Object)FontOption.BOLD)) {
            this.btnBold.setSelection(true);
        }
        this.btnBold.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SegmentEditorDialog.this.handleStyle();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnUnderline = new Button(area, 32);
        this.btnUnderline.setText("U");
        if (this.segment.getStyle().getAppliedFonts().contains((Object)FontOption.UNDERLINE)) {
            this.btnUnderline.setSelection(true);
        }
        this.btnUnderline.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SegmentEditorDialog.this.handleStyle();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnStrike = new Button(area, 32);
        this.btnStrike.setText("S");
        if (this.segment.getStyle().getAppliedFonts().contains((Object)FontOption.STRIKE)) {
            this.btnStrike.setSelection(true);
        }
        this.btnStrike.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SegmentEditorDialog.this.handleStyle();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(area, 0);
        new Label(area, 0);
        new Label(area, 0);
        this.constantButton = new Button(area, 16);
        this.constantButton.setText("Constant :");
        this.constantButton.addSelectionListener((SelectionListener)new SegmentSelectionListener());
        this.constantText = new Text(area, 2048);
        this.constantText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 7, 1));
        this.constantText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Pattern pattern = SegmentEditorDialog.this.segment.getPattern();
                if (pattern instanceof ConstantPattern) {
                    ((ConstantPattern)pattern).setValue(SegmentEditorDialog.this.constantText.getText());
                } else {
                    ConstantPattern newPattern = StylingFactory.eINSTANCE.createConstantPattern();
                    newPattern.setValue(SegmentEditorDialog.this.constantText.getText());
                    SegmentEditorDialog.this.segment.setPattern((Pattern)newPattern);
                }
                SegmentEditorDialog.this.validateInput();
            }
        });
        this.modelButton = new Button(area, 16);
        this.modelButton.setText("Model :");
        this.modelButton.addSelectionListener((SelectionListener)new SegmentSelectionListener());
        this.modelText = new Text(area, 2048);
        this.modelText.setEditable(false);
        this.modelText.setEnabled(false);
        this.modelText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 6, 1));
        this.btnLoadResources = new Button(area, 0);
        this.btnLoadResources.setText("...");
        this.btnLoadResources.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.btnLoadResources.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectModelDialog dialog = new SelectModelDialog(Display.getDefault().getActiveShell());
                int result = dialog.open();
                if (result == 0) {
                    String attributeName = dialog.getResult();
                    ModelPattern pattern = StylingFactory.eINSTANCE.createModelPattern();
                    pattern.setAttributeName(attributeName);
                    SegmentEditorDialog.this.segment.setPattern((Pattern)pattern);
                    SegmentEditorDialog.this.modelText.setText(attributeName);
                    SegmentEditorDialog.this.validateInput();
                }
            }
        });
        this.operationButton = new Button(area, 16);
        this.operationButton.setText("Operation :");
        this.operationButton.addSelectionListener((SelectionListener)new SegmentSelectionListener());
        this.operationText = new Text(area, 2048);
        this.operationText.setEditable(false);
        this.operationText.setEnabled(false);
        this.operationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
        this.btnOperation = new Button(area, 0);
        this.btnOperation.setText("...");
        this.btnOperation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectOperationDialog dialog = new SelectOperationDialog(Display.getDefault().getActiveShell());
                int result = dialog.open();
                if (result == 0) {
                    ReqCycleOperation op = dialog.getResult();
                    String opText = op.getMethod().getName();
                    SegmentEditorDialog.this.method = op.getMethod();
                    Class<?>[] paramList = SegmentEditorDialog.this.method.getParameterTypes();
                    if (paramList.length > 1) {
                        opText = String.valueOf(opText) + "(";
                        int i = 1;
                        while (i < paramList.length) {
                            Class<?> c = paramList[i];
                            if (i != 1) {
                                opText = String.valueOf(opText) + " ,";
                            }
                            opText = String.valueOf(opText) + c.getSimpleName();
                            ++i;
                        }
                        opText = String.valueOf(opText) + ")";
                    }
                    SegmentEditorDialog.this.operationText.setText(opText);
                    if (SegmentEditorDialog.this.method.getParameterTypes().length > 1) {
                        SegmentEditorDialog.this.btnEditOperation.setEnabled(true);
                    } else {
                        SegmentEditorDialog.this.btnEditOperation.setEnabled(false);
                        OperationPattern pattern = StylingFactory.eINSTANCE.createOperationPattern();
                        pattern.setOperation(SegmentEditorDialog.this.method.getName());
                        SegmentEditorDialog.this.segment.setPattern((Pattern)pattern);
                    }
                    SegmentEditorDialog.this.validateInput();
                }
            }
        });
        this.btnEditOperation = new Button(area, 0);
        this.btnEditOperation.setText("Edit");
        this.btnEditOperation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OperationAttributesEditor dialog = new OperationAttributesEditor(Display.getDefault().getActiveShell(), SegmentEditorDialog.this.method);
                int result = dialog.open();
                if (result == 0) {
                    OperationPattern pattern = StylingFactory.eINSTANCE.createOperationPattern();
                    pattern.setOperation(SegmentEditorDialog.this.method.getName());
                    for (Map.Entry entry : dialog.getEditors().entrySet()) {
                        StringParameter param;
                        GenericEAttrPropsEditor editor = (GenericEAttrPropsEditor)entry.getValue();
                        Object obj = editor.getEnteredValue();
                        if (obj instanceof String) {
                            param = StylingFactory.eINSTANCE.createStringParameter();
                            param.setName((String)entry.getKey());
                            param.setValue((String)obj);
                            pattern.getParameters().add((Object)param);
                            continue;
                        }
                        if (obj instanceof Integer) {
                            param = StylingFactory.eINSTANCE.createIntParameter();
                            param.setName((String)entry.getKey());
                            param.setValue(((Integer)obj).intValue());
                            pattern.getParameters().add((Object)param);
                            continue;
                        }
                        if (obj instanceof Boolean) {
                            param = StylingFactory.eINSTANCE.createBooleanParameter();
                            param.setName((String)entry.getKey());
                            param.setValue(((Boolean)obj).booleanValue());
                            pattern.getParameters().add((Object)param);
                            continue;
                        }
                        if (!(obj instanceof EObject)) continue;
                        param = StylingFactory.eINSTANCE.createEObjectParameter();
                        param.setName((String)entry.getKey());
                        param.setValue((EObject)obj);
                        pattern.getParameters().add((Object)param);
                    }
                    SegmentEditorDialog.this.segment.setPattern((Pattern)pattern);
                }
            }
        });
        this.initRadioButtons();
        this.styledText = new StyledText(area, 2048);
        this.styledText.setBackground(SWTResourceManager.getColor(22));
        this.styledText.setAlignment(0x1000000);
        this.styledText.setText("The quick brown fox jumps over the lazy dog");
        this.styledText.setEditable(false);
        this.styledText.setEnabled(false);
        this.styledText.setLayoutData((Object)new GridData(4, 4, true, false, 8, 1));
        this.handleStyle();
        return area;
    }

    private void handleStyle() {
        this.style = new StyleRange();
        this.style.foreground = this.segment.getColor();
        this.style.start = 0;
        this.style.length = this.styledText.getText().length();
        this.style.underline = this.btnUnderline.getSelection();
        this.style.strikeout = this.btnStrike.getSelection();
        int font = 0;
        this.segment.getStyle().getAppliedFonts().clear();
        if (this.btnBold.getSelection()) {
            font |= 1;
            this.segment.getStyle().getAppliedFonts().add((Object)FontOption.BOLD);
        }
        if (this.btnItallic.getSelection()) {
            font |= 2;
            this.segment.getStyle().getAppliedFonts().add((Object)FontOption.ITALIC);
        }
        if (this.btnUnderline.getSelection()) {
            this.segment.getStyle().getAppliedFonts().add((Object)FontOption.UNDERLINE);
        }
        if (this.btnStrike.getSelection()) {
            this.segment.getStyle().getAppliedFonts().add((Object)FontOption.STRIKE);
        }
        this.style.font = SWTResourceManager.getFont("Segoe UI", 9, font);
        this.styledText.setStyleRange(this.style);
    }

    private void initRadioButtons() {
        Pattern pattern = this.segment.getPattern();
        if (pattern instanceof ConstantPattern) {
            this.constantText.setEnabled(true);
            this.btnLoadResources.setEnabled(false);
            this.btnOperation.setEnabled(false);
            this.btnEditOperation.setEnabled(false);
            this.constantText.setText(((ConstantPattern)pattern).getPattern());
            this.constantButton.setSelection(true);
        } else if (pattern instanceof ModelPattern) {
            this.constantText.setEnabled(false);
            this.btnLoadResources.setEnabled(true);
            this.btnOperation.setEnabled(false);
            this.btnEditOperation.setEnabled(false);
            this.modelText.setText(((ModelPattern)pattern).getAttributeName());
            this.modelButton.setSelection(true);
        } else if (pattern instanceof OperationPattern) {
            this.constantText.setEnabled(false);
            this.btnLoadResources.setEnabled(false);
            this.btnOperation.setEnabled(true);
            String operationName = ((OperationPattern)pattern).getOperation();
            this.operationText.setText(operationName);
            this.operationButton.setSelection(true);
            EList paramList = ((OperationPattern)pattern).getParameters();
            Class[] listTypes = new Class[paramList.size()];
            int i = 0;
            while (i < paramList.size()) {
                Parameter p = (Parameter)paramList.get(i);
                if (p instanceof StringParameter) {
                    listTypes[i] = String.class;
                } else if (p instanceof IntParameter) {
                    listTypes[i] = Integer.class;
                } else if (p instanceof BooleanParameter) {
                    listTypes[i] = Boolean.class;
                } else if (p instanceof EObjectParameter) {
                    listTypes[i] = EObject.class;
                } else {
                    return;
                }
                ++i;
            }
            ReqCycleOperation op = this.reqCycleOperationlManager.getOperationForEditingAttributes(operationName, listTypes);
            if (op != null) {
                this.method = op.getMethod();
                if (paramList.size() > 0) {
                    this.btnEditOperation.setEnabled(true);
                } else {
                    this.btnEditOperation.setEnabled(false);
                }
            } else {
                this.btnEditOperation.setEnabled(false);
            }
        }
    }

    private void handleRadioButtons(String buttonSelected) {
        if (buttonSelected.equals("Constant :")) {
            this.constantText.setEnabled(true);
            this.btnLoadResources.setEnabled(false);
            this.btnOperation.setEnabled(false);
            this.btnEditOperation.setEnabled(false);
            this.modelText.setText("");
            this.operationText.setText("");
        } else if (buttonSelected.equals("Model :")) {
            this.constantText.setEnabled(false);
            this.btnLoadResources.setEnabled(true);
            this.btnOperation.setEnabled(false);
            this.btnEditOperation.setEnabled(false);
            this.constantText.setText("");
            this.operationText.setText("");
        } else if (buttonSelected.equals("Operation :")) {
            this.constantText.setEnabled(false);
            this.btnLoadResources.setEnabled(false);
            this.btnOperation.setEnabled(true);
            this.btnEditOperation.setEnabled(false);
            this.constantText.setText("");
            this.modelText.setText("");
        }
        this.validateInput();
    }

    public ValidatingTitleAreaDialog.IValidator getInputValidator() {
        return new ValidatingTitleAreaDialog.IValidator(){

            public String isValid() {
                if (SegmentEditorDialog.this.constantButton.getSelection()) {
                    if (SegmentEditorDialog.this.constantText.getText().equals("")) {
                        return "A constant text must be entered";
                    }
                } else if (SegmentEditorDialog.this.modelButton.getSelection()) {
                    if (SegmentEditorDialog.this.modelText.getText().equals("")) {
                        return "A model must be selected";
                    }
                } else if (SegmentEditorDialog.this.operationButton.getSelection() && SegmentEditorDialog.this.operationText.getText().equals("")) {
                    return "An operation must be selected";
                }
                return null;
            }
        };
    }

    private class SegmentSelectionListener
    extends SelectionAdapter {
        private SegmentSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source instanceof Button) {
                Button btn = (Button)source;
                SegmentEditorDialog.this.handleRadioButtons(btn.getText());
            }
        }
    }
}

