/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.styling.ui.dialogs;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.ResourceManager;
import org.polarsys.reqcycle.core.ui.dialogs.ValidatingTitleAreaDialog;
import org.polarsys.reqcycle.predicates.core.api.IPredicate;
import org.polarsys.reqcycle.predicates.persistance.util.IPredicatesConfManager;
import org.polarsys.reqcycle.predicates.ui.util.PredicatesUIHelper;
import org.polarsys.reqcycle.styling.manager.IStylingManager;
import org.polarsys.reqcycle.styling.model.Styling.Basic;
import org.polarsys.reqcycle.styling.model.Styling.CaseStyle;
import org.polarsys.reqcycle.styling.model.Styling.Default;
import org.polarsys.reqcycle.styling.model.Styling.StylingFactory;
import org.polarsys.reqcycle.styling.model.Styling.StylingModel;
import org.polarsys.reqcycle.styling.model.Styling.StylingPredicate;
import org.polarsys.reqcycle.styling.ui.dialogs.StyleModelEditorDialog;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class CaseStyleEditorDialog
extends ValidatingTitleAreaDialog
implements IDoubleClickListener {
    IStylingManager styleManager = (IStylingManager)ZigguratInject.make(IStylingManager.class);
    IPredicatesConfManager predicatesConfManager = (IPredicatesConfManager)ZigguratInject.make(IPredicatesConfManager.class);
    private ListViewer listViewer;
    private StylingModel stylingModel;
    private Text text;

    public CaseStyleEditorDialog(Shell parentShell, StylingModel style) {
        super(parentShell);
        this.setShellStyle(35952);
        this.stylingModel = style;
        if (this.stylingModel.getDefault() == null) {
            Default defaultStyle = StylingFactory.eINSTANCE.createDefault();
            this.stylingModel.setDefault(defaultStyle);
        }
        if (this.stylingModel.getBasic() == null) {
            Basic basicStyle = StylingFactory.eINSTANCE.createBasic();
            this.stylingModel.setBasic(basicStyle);
        }
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.validateInput();
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Styling configuration");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblName = new Label(container, 0);
        lblName.setText("Name :");
        this.text = new Text(container, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CaseStyleEditorDialog.this.validateInput();
            }
        });
        Group composite = new Group(container, 0);
        composite.setText("Style predicates");
        composite.setToolTipText("");
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.listViewer = new ListViewer((Composite)composite, 2560);
        this.listViewer.setUseHashlookup(true);
        List list = this.listViewer.getList();
        list.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.listViewer.addDoubleClickListener((IDoubleClickListener)this);
        Composite composite_1 = new Composite((Composite)composite, 0);
        composite_1.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        composite_1.setLayout((Layout)new GridLayout(1, false));
        Button btnAdd = new Button(composite_1, 0);
        btnAdd.setToolTipText("Add new styling predicate");
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterable alreadyUsed;
                Collection predicates = CaseStyleEditorDialog.this.predicatesConfManager.getPredicates(true);
                ArrayList selectionPredicates = Lists.newArrayList((Iterable)Iterables.filter((Iterable)predicates, (Predicate)new Predicate<IPredicate>(alreadyUsed = Iterables.filter((Iterable)Iterables.transform((Iterable)CaseStyleEditorDialog.this.stylingModel.getStyles(), (Function)new Function<CaseStyle, IPredicate>(){

                    public IPredicate apply(CaseStyle arg0) {
                        if (arg0 instanceof StylingPredicate) {
                            StylingPredicate sp = (StylingPredicate)arg0;
                            return sp.getPredicate();
                        }
                        return null;
                    }
                }), (Predicate)Predicates.notNull())){
                    private final /* synthetic */ Iterable val$alreadyUsed;
                    {
                        this.val$alreadyUsed = iterable;
                    }

                    public boolean apply(IPredicate arg0) {
                        for (IPredicate p : this.val$alreadyUsed) {
                            if (!p.getDisplayName().equals(arg0.getDisplayName())) continue;
                            return false;
                        }
                        return true;
                    }
                }));
                Collection selection = PredicatesUIHelper.openPredicatesChooser((Collection)selectionPredicates, (Collection)selectionPredicates, (String)"Creating Styling Model", (String)"Select a predicate to apply.", (Boolean)false);
                if (selection != null) {
                    EList casesStyle = CaseStyleEditorDialog.this.stylingModel.getStyles();
                    StylingPredicate newStyle = StylingFactory.eINSTANCE.createStylingPredicate();
                    casesStyle.add((Object)newStyle);
                    IPredicate p = (IPredicate)selection.iterator().next();
                    newStyle.setPredicate(p);
                    CaseStyleEditorDialog.this.listViewer.setInput((Object)CaseStyleEditorDialog.this.stylingModel.getStyles());
                    CaseStyleEditorDialog.this.listViewer.setSelection((ISelection)new StructuredSelection((Object)newStyle));
                }
            }
        });
        btnAdd.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/add_obj.gif"));
        Button btnRemove = new Button(composite_1, 0);
        btnRemove.setToolTipText("Remove the selected styling predicate");
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                CaseStyle caseStyle;
                if (!CaseStyleEditorDialog.this.listViewer.getSelection().isEmpty() && (caseStyle = (CaseStyle)(selection = (IStructuredSelection)CaseStyleEditorDialog.this.listViewer.getSelection()).getFirstElement()) != null) {
                    EList casesStyle = CaseStyleEditorDialog.this.stylingModel.getStyles();
                    casesStyle.remove((Object)caseStyle);
                    CaseStyleEditorDialog.this.listViewer.setInput((Object)CaseStyleEditorDialog.this.stylingModel.getStyles());
                }
            }
        });
        btnRemove.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/delete_obj.gif"));
        Button btnEdit = new Button(composite_1, 0);
        btnEdit.setToolTipText("Edit the selected styling predicate");
        btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                CaseStyle caseStyle;
                if (!CaseStyleEditorDialog.this.listViewer.getSelection().isEmpty() && (caseStyle = (CaseStyle)(selection = (IStructuredSelection)CaseStyleEditorDialog.this.listViewer.getSelection()).getFirstElement()) != null) {
                    CaseStyleEditorDialog.this.editStylePredicate(caseStyle);
                }
            }
        });
        btnEdit.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/edit_obj.png"));
        new Label(composite_1, 0);
        Button btnUp = new Button(composite_1, 0);
        btnUp.setToolTipText("Move up the selected styling predicate");
        btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EList list;
                int pos;
                IStructuredSelection selection;
                CaseStyle caseStyle;
                if (!CaseStyleEditorDialog.this.listViewer.getSelection().isEmpty() && (caseStyle = (CaseStyle)(selection = (IStructuredSelection)CaseStyleEditorDialog.this.listViewer.getSelection()).getFirstElement()) != null && (pos = (list = CaseStyleEditorDialog.this.stylingModel.getStyles()).indexOf((Object)caseStyle)) > 0) {
                    list.move(pos, pos - 1);
                    CaseStyleEditorDialog.this.listViewer.setInput((Object)CaseStyleEditorDialog.this.stylingModel.getStyles());
                    CaseStyleEditorDialog.this.listViewer.setSelection((ISelection)selection);
                }
            }
        });
        btnUp.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/prev_nav-1.gif"));
        Button btnDown = new Button(composite_1, 0);
        btnDown.setToolTipText("Move down the selected styling predicate");
        btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EList list;
                int pos;
                IStructuredSelection selection;
                CaseStyle caseStyle;
                if (!CaseStyleEditorDialog.this.listViewer.getSelection().isEmpty() && (caseStyle = (CaseStyle)(selection = (IStructuredSelection)CaseStyleEditorDialog.this.listViewer.getSelection()).getFirstElement()) != null && (pos = (list = CaseStyleEditorDialog.this.stylingModel.getStyles()).indexOf((Object)caseStyle)) != -1 && pos != list.size() - 1) {
                    list.move(pos, pos + 1);
                    CaseStyleEditorDialog.this.listViewer.setInput((Object)CaseStyleEditorDialog.this.stylingModel.getStyles());
                    CaseStyleEditorDialog.this.listViewer.setSelection((ISelection)selection);
                }
            }
        });
        btnDown.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.styling.ui", "icons/next_nav-1.gif"));
        this.initDataBindings();
        this.initProviders(this.listViewer);
        Label lblDefaultPredicate = new Label(container, 0);
        lblDefaultPredicate.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDefaultPredicate.setText("Default :");
        Button btnEdit_1 = new Button(container, 0);
        btnEdit_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyleModelEditorDialog editor = new StyleModelEditorDialog(Display.getDefault().getActiveShell(), (CaseStyle)CaseStyleEditorDialog.this.stylingModel.getDefault(), CaseStyleEditorDialog.this.stylingModel);
                if (editor.open() == 0) {
                    CaseStyleEditorDialog.this.listViewer.setInput((Object)CaseStyleEditorDialog.this.stylingModel.getStyles());
                }
            }
        });
        btnEdit_1.setText("Edit");
        Label label = new Label(container, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblNewLabel.setText("Basic styling is the style used to display requirements in ReqCycle views (except Requirements view).");
        Label lblBasic = new Label(container, 0);
        lblBasic.setText("Basic :");
        Button btnEdit_2 = new Button(container, 0);
        btnEdit_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyleModelEditorDialog editor = new StyleModelEditorDialog(Display.getDefault().getActiveShell(), (CaseStyle)CaseStyleEditorDialog.this.stylingModel.getBasic(), CaseStyleEditorDialog.this.stylingModel);
                if (editor.open() == 0) {
                    CaseStyleEditorDialog.this.listViewer.setInput((Object)CaseStyleEditorDialog.this.stylingModel.getStyles());
                }
            }
        });
        btnEdit_2.setText("Edit");
        return area;
    }

    private void initProviders(ListViewer listViewer) {
        ComposedAdapterFactory adapterfactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterfactory){

            public String getText(Object object) {
                if (object instanceof StylingPredicate) {
                    StylingPredicate stylingPredicate = (StylingPredicate)object;
                    if (stylingPredicate.getPredicate() == null) {
                        return "";
                    }
                    return stylingPredicate.getPredicate().getDisplayName();
                }
                return super.getText(object);
            }
        };
        ArrayContentProvider contentProvider = ArrayContentProvider.getInstance();
        listViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        listViewer.setContentProvider((IContentProvider)contentProvider);
        listViewer.setInput((Object)this.stylingModel.getStyles());
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.text);
        IObservableValue modeNameStylingModelObserveValue = PojoProperties.value((String)"modeName").observe((Object)this.stylingModel);
        bindingContext.bindValue((IObservableValue)observeTextTextObserveWidget, modeNameStylingModelObserveValue, null, null);
        return bindingContext;
    }

    private boolean isNameAlreadyUsed(String name) {
        EList list = this.styleManager.getStyling().getModels();
        boolean alreadyUsed = false;
        if (name != null && list != null) {
            for (StylingModel s : list) {
                if (s.equals(this.stylingModel) || !name.equals(s.getModeName())) continue;
                alreadyUsed = true;
                break;
            }
        }
        return alreadyUsed;
    }

    public ValidatingTitleAreaDialog.IValidator getInputValidator() {
        return new ValidatingTitleAreaDialog.IValidator(){

            public String isValid() {
                String newText = CaseStyleEditorDialog.this.text.getText();
                if (newText == null || newText.isEmpty()) {
                    return "Enter the name of the styling model";
                }
                if (CaseStyleEditorDialog.this.isNameAlreadyUsed(newText)) {
                    return "This styling model's name is already used.";
                }
                return null;
            }
        };
    }

    private void editStylePredicate(CaseStyle caseStyle) {
        StyleModelEditorDialog editor = new StyleModelEditorDialog(Display.getDefault().getActiveShell(), (CaseStyle)((StylingPredicate)caseStyle), this.stylingModel);
        if (editor.open() == 0) {
            this.listViewer.setInput((Object)this.stylingModel.getStyles());
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        CaseStyle caseStyle;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.getFirstElement() instanceof CaseStyle && (caseStyle = (CaseStyle)selection.getFirstElement()) != null) {
            this.editStylePredicate(caseStyle);
        }
    }
}

