/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.uri.model;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class Reachable
implements Serializable {
    private static final long serialVersionUID = -2197337862552450878L;
    private String scheme;
    private String path;
    private String fragment;
    private String schemeSpecificPart;
    private String authority;
    private String userInfo;
    private String host;
    private String query;
    private int port;
    private Map<String, String> properties = new HashMap<String, String>();

    public void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        return this.getURI().toString();
    }

    public int getPort() {
        return this.port;
    }

    public URI getURI() {
        try {
            if (this.schemeSpecificPart != null) {
                return new URI(this.scheme, this.schemeSpecificPart, this.fragment);
            }
            return new URI(this.scheme, this.userInfo, this.host, this.port, this.path, this.query, this.fragment);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public Reachable trimFragment() {
        if (this.fragment == null) {
            return this;
        }
        Reachable result = new Reachable();
        result.setAuthority(this.authority);
        result.setFragment(null);
        result.setHost(this.host);
        result.setPath(this.path);
        result.setPort(this.port);
        result.setQuery(this.query);
        result.setScheme(this.scheme);
        result.setSchemeSpecificPart(this.schemeSpecificPart);
        result.setUserInfo(this.userInfo);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Reachable) {
            Reachable t = (Reachable)obj;
            return t.getURI().equals(this.getURI());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }

    public void setSchemeSpecificPart(String schemeSpecificPart) {
        this.schemeSpecificPart = schemeSpecificPart;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getPath() {
        return this.path;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getSchemeSpecificPart() {
        return this.schemeSpecificPart;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public String getQuery() {
        return this.query;
    }

    public String get(String key) {
        return this.getProperties().get(key);
    }

    public void put(String key, String value) {
        this.getProperties().put(key, value);
    }

    public void putAll(Map<String, String> map) {
        this.getProperties().putAll(map);
    }

    public Set<String> extraKeys() {
        return this.getProperties().keySet();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

