/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.jdt.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.polarsys.reqcycle.jdt.model.JDTLabelProvider;
import org.polarsys.reqcycle.jdt.model.JDTVisitable;
import org.polarsys.reqcycle.uri.exceptions.VisitableException;
import org.polarsys.reqcycle.uri.model.IBusinessObject;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.uri.visitors.EmptyVisitable;
import org.polarsys.reqcycle.uri.visitors.IVisitable;

public class JDTReachableObject
implements ReachableObject {
    private Reachable reachable;
    IFile file = null;
    private IJavaElement javaElement = null;

    public JDTReachableObject(Reachable t) {
        IJavaElement element;
        this.reachable = t;
        String path = t.trimFragment().toString().replaceFirst("platform:", "");
        this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        if (this.file != null && (element = JavaCore.create((IFile)this.file)) instanceof ITypeRoot) {
            String[] splitted;
            ITypeRoot aClass = (ITypeRoot)element;
            String fragment = t.getFragment();
            this.javaElement = fragment != null && fragment.length() > 0 ? ((splitted = fragment.split("::")).length > 0 ? this.findMethodRecursively((IParent)aClass, splitted) : aClass) : aClass;
        }
    }

    private IJavaElement findMethodRecursively(IParent aClass, String[] javaElement) {
        try {
            IJavaElement result = null;
            boolean found = false;
            IParent currentContainer = aClass;
            int i = 0;
            String[] stringArray = javaElement;
            int n = javaElement.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                found = false;
                if (currentContainer != null) {
                    IJavaElement[] iJavaElementArray = currentContainer.getChildren();
                    int n3 = iJavaElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaElement j = iJavaElementArray[n4];
                        if (s.equals(j.getElementName())) {
                            if (i == javaElement.length - 1) {
                                result = j;
                                found = true;
                                break;
                            }
                            if (!(j instanceof IParent)) break;
                            currentContainer = (IParent)j;
                            break;
                        }
                        ++n4;
                    }
                }
                ++i;
                ++n2;
            }
            if (found && result != null) {
                return result;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (IBusinessObject.class.equals((Object)adapter)) {
            return new IBusinessObject.DefaultBusinessObject(this.javaElement != null && this.javaElement.exists());
        }
        if (ILabelProvider.class.equals((Object)adapter)) {
            return new JDTLabelProvider();
        }
        if (IJavaElement.class.equals((Object)adapter)) {
            return this.javaElement;
        }
        if (IFile.class.equals((Object)adapter)) {
            return this.file;
        }
        return null;
    }

    public IVisitable getVisitable() throws VisitableException {
        if (this.javaElement != null) {
            return new JDTVisitable(this.javaElement);
        }
        return new EmptyVisitable();
    }

    public String getRevisionIdentification() {
        return String.valueOf(this.file.getLocalTimeStamp());
    }

    public Reachable getReachable() {
        return this.reachable;
    }
}

