/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.util;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.reqcycle.repository.data.Activator;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class EntryUtil {
    static IDataModelManager dataModelManager = (IDataModelManager)ZigguratInject.make(IDataModelManager.class);
    public static final String AN_ENTRY = "entry";
    private static final String CLEAR_IMG_PATH = "/icons/delete.gif";

    public static ComboViewer createComboViewer(Composite composite, String attributeName, Object input) {
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText(attributeName);
        final ComboViewer comboViewer = new ComboViewer(composite);
        Combo combo = comboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 4, true, false));
        final LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                Object adapter;
                if (Platform.getAdapterManager().hasAdapter(element, String.class.getName()) && (adapter = Platform.getAdapterManager().getAdapter(element, String.class)) instanceof String) {
                    return (String)adapter;
                }
                return super.getText(element);
            }
        };
        comboViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setInput(input);
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                    if (firstElement instanceof IDataModel || firstElement instanceof IRequirementType || firstElement instanceof Scope) {
                        comboViewer.setData(EntryUtil.AN_ENTRY, (Object)labelProvider.getText(firstElement));
                    } else {
                        comboViewer.setData(EntryUtil.AN_ENTRY, null);
                    }
                }
            }
        });
        Button clearCombo = new Button(composite, 8);
        clearCombo.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        clearCombo.setImage(Activator.getImageDescriptor(CLEAR_IMG_PATH).createImage());
        clearCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (comboViewer != null) {
                    comboViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
        return comboViewer;
    }
}

