/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.types.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.repository.data.types.internal.EnumerationTypeImpl;
import org.polarsys.reqcycle.repository.data.types.internal.RequirementTypeImpl;

public class DataModelImpl
implements IDataModel,
IAdaptable {
    protected boolean needsNewVersionOnSave = false;
    protected static final Pattern VERSION_REGEX = Pattern.compile(".*/([0-9]*)");
    protected EPackage ePackage;
    protected Collection<IDataModel> subPackages = new ArrayList<IDataModel>();
    protected Collection<IType> types = new ArrayList<IType>();
    protected int version = 0;

    public DataModelImpl() {
        this.ePackage = EcoreFactory.eINSTANCE.createEPackage();
        this.ePackage.setName("");
        this.ePackage.setNsPrefix("");
        this.ePackage.setNsURI("http://www.polarsys.org/ReqCycle/CustomDataModels");
    }

    public DataModelImpl(String name, int version) {
        this.version = version;
        this.ePackage = EcoreFactory.eINSTANCE.createEPackage();
        this.ePackage.setName(name);
        this.ePackage.setNsPrefix(name);
        this.ePackage.setNsURI("http://www.polarsys.org/ReqCycle/CustomDataModels/" + name + "/" + this.version);
    }

    public DataModelImpl(EPackage ePackage) {
        this.ePackage = ePackage;
        Matcher matcher = VERSION_REGEX.matcher(ePackage.getNsURI());
        if (matcher.matches()) {
            this.version = Integer.parseInt(matcher.group(1));
        }
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (classifier instanceof EEnum) {
                this.types.add(new EnumerationTypeImpl((EEnum)classifier));
                continue;
            }
            if (!(classifier instanceof EClass)) continue;
            this.types.add(new RequirementTypeImpl((EClass)classifier, (IDataModel)this));
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            this.subPackages.add(new DataModelImpl(subPackage));
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.ePackage != null ? this.ePackage.getName() : null;
    }

    protected EFactory getFactoryInstance() {
        return this.ePackage.getEFactoryInstance();
    }

    public void addSubDataModel(IDataModel dataModel) {
        this.subPackages.add(dataModel);
        EPackage ePackage = null;
        if (dataModel instanceof IAdaptable) {
            ePackage = (EPackage)((IAdaptable)dataModel).getAdapter(EPackage.class);
        }
        if (ePackage != null) {
            this.ePackage.getESubpackages().add((Object)ePackage);
        }
    }

    public void removeSubDataModel(IDataModel p) {
        this.subPackages.remove(p);
        EPackage ePackage = null;
        if (p instanceof IAdaptable) {
            ePackage = (EPackage)((IAdaptable)p).getAdapter(EPackage.class);
        }
        if (ePackage != null) {
            EcoreUtil.remove(ePackage);
        }
    }

    @Override
    public void addType(IType type) {
        EClassifier eType = null;
        if (type instanceof IAdaptable) {
            eType = (EClassifier)((IAdaptable)type).getAdapter(EClassifier.class);
        }
        if (eType != null) {
            this.ePackage.getEClassifiers().add((Object)eType);
            this.types.add(type);
        }
    }

    public Collection<IDataModel> getSubDataModels() {
        return this.subPackages;
    }

    @Override
    public IType getType(String name) {
        for (IType type : this.types) {
            if (!name.equals(type.getName())) continue;
            return type;
        }
        return null;
    }

    @Override
    public Collection<IType> getTypes() {
        return this.types;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EPackage.class) {
            return this.ePackage;
        }
        return null;
    }

    @Override
    public String getDataModelURI() {
        return this.ePackage.getNsURI();
    }

    @Override
    public void removeType(IType type) {
        EClassifier classifier;
        if (type instanceof IAdaptable && (classifier = (EClassifier)((IAdaptable)type).getAdapter(EClassifier.class)) != null && this.ePackage.getEClassifiers().remove((Object)classifier)) {
            this.needsNewVersionOnSave = true;
        }
        this.types.remove(type);
    }

    public DataModelImpl prepareSave() {
        if (this.needsNewVersionOnSave) {
            this.needsNewVersionOnSave = false;
            String oldNsURI = this.ePackage.getNsURI();
            ++this.version;
            this.ePackage.setNsURI("http://www.polarsys.org/ReqCycle/CustomDataModels/" + this.ePackage.getName() + "/" + this.version);
            ResourceSetImpl rs = new ResourceSetImpl();
            Resource oldResource = rs.getResource(this.ePackage.eResource().getURI(), true);
            TreeIterator it = oldResource.getAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!(obj instanceof EPackage) || !oldNsURI.equals(((EPackage)obj).getNsURI())) continue;
                return new DataModelImpl((EPackage)obj);
            }
        }
        return null;
    }
}

