/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.rmf.ui;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.polarsys.reqcycle.repository.connector.rmf.RMFUtils;
import org.polarsys.reqcycle.repository.connector.rmf.ui.RMFBean;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.AbstractSettingPage;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.AbstractStorageBean;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;

public class RMFSettingPage
extends AbstractSettingPage {
    private Text fileURIText;
    private Button browseFileBtn;
    private final String EXTENSIONS = "reqif";
    private ComboViewer comboViewer;
    Collection<Specification> docsTypes = new LinkedList<Specification>();
    @Inject
    IDataModelManager dataManager;

    public RMFSettingPage(RMFBean bean) {
        super("RMF Connector settings", (AbstractStorageBean)bean);
        this.setTitle("Connector RMF: settings page");
    }

    public boolean preFinish(RequirementSource repository) {
        return true;
    }

    protected void doSpecificInitDataBindings(DataBindingContext bindingContext) {
        ISWTObservableValue observeTextFileURITextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.fileURIText);
        IObservableValue uriBeanObserveValue = PojoProperties.value((String)"uri").observe((Object)this.getBean());
        bindingContext.bindValue((IObservableValue)observeTextFileURITextObserveWidget, uriBeanObserveValue, null, null);
        IViewerObservableValue observeDocument = ViewerProperties.singleSelection().observe((Viewer)this.comboViewer);
        IObservableValue documentObserveValue = PojoProperties.value((String)"specification").observe((Object)this.getBean());
        bindingContext.bindValue((IObservableValue)observeDocument, documentObserveValue, null, null);
    }

    protected Composite doCreateSpecific(Composite parent) {
        Composite compositeContainer = parent;
        compositeContainer.setLayout((Layout)new GridLayout(4, false));
        this.setControl((Control)compositeContainer);
        Label lblReqIfFile = new Label(compositeContainer, 0);
        lblReqIfFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblReqIfFile.setText("ReqIF file :");
        this.fileURIText = new Text(compositeContainer, 2048);
        this.fileURIText.setEditable(false);
        this.fileURIText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.browseFileBtn = new Button(compositeContainer, 0);
        this.browseFileBtn.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 2, 1));
        this.browseFileBtn.setText("Browse");
        Label lblDocSpec = new Label(compositeContainer, 0);
        lblDocSpec.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblDocSpec.setText("Specification :");
        this.comboViewer = new ComboViewer(compositeContainer, 8);
        Combo combo = this.comboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Specification) {
                    String longName = ((Specification)element).getLongName();
                    return longName != null && !longName.isEmpty() ? longName : ((Specification)element).getIdentifier();
                }
                return super.getText(element);
            }
        });
        combo.setEnabled(false);
        this.comboViewer.setInput(this.docsTypes);
        return compositeContainer;
    }

    protected void hookListeners() {
        super.hookListeners();
        this.getDestinationFileSelectionListener();
        this.browseFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List uris;
                ResourceDialog dialog = new ResourceDialog(RMFSettingPage.this.getShell(), "Select ReqIF file", 0);
                int res = dialog.open();
                if (res == 0 && !(uris = dialog.getURIs()).isEmpty()) {
                    URI uri = (URI)uris.get(0);
                    String extension = uri.path().substring(uri.path().lastIndexOf(".") + 1, uri.path().length());
                    if ("reqif".contains(extension.toLowerCase())) {
                        RMFSettingPage.this.fileURIText.setText(uri.toString());
                        RMFSettingPage.this.docsTypes.clear();
                        RMFSettingPage.this.docsTypes.addAll(RMFUtils.getReqIFDocuments((ResourceSet)new ResourceSetImpl(), uri.toString()));
                        Combo combo = RMFSettingPage.this.comboViewer.getCombo();
                        if (combo != null) {
                            combo.setEnabled(true);
                            RMFSettingPage.this.comboViewer.refresh();
                        }
                    } else {
                        RMFSettingPage.this.fileURIText.setText("");
                        RMFSettingPage.this.docsTypes.clear();
                        Combo combo = RMFSettingPage.this.comboViewer.getCombo();
                        if (combo != null) {
                            combo.setEnabled(false);
                            RMFSettingPage.this.comboViewer.refresh();
                        }
                        RMFSettingPage.this.setErrorMessage("Your document is not supported. Retry and choose reqIF file");
                    }
                }
            }
        });
    }

    public boolean isPageComplete() {
        boolean result = super.isPageComplete();
        if (this.fileURIText.getText() == null || this.fileURIText.getText().isEmpty()) {
            this.setErrorMsg("Choose a ReqIF File.\n");
            result = false;
        } else if (((RMFBean)this.getBean()).getSpecification() == null) {
            this.setErrorMsg("Choose a specification.\n");
            result = false;
        }
        return result;
    }

    private void setErrorMsg(String message) {
        String msg = this.getErrorMessage();
        if (msg == null) {
            msg = "";
        }
        msg = String.valueOf(msg) + message;
        this.setErrorMessage(msg);
    }
}

