/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.document.traceability.visitor;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.polarsys.reqcycle.document.traceability.DocumentTrace;
import org.polarsys.reqcycle.document.traceability.types.DocumentTTypeProvider;
import org.polarsys.reqcycle.traceability.builder.ITraceabilityBuilder;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.uri.ILogicalIDManager;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.visitors.IVisitor;

public class DocumentTraceabilityVisitor
implements IVisitor {
    private IAdaptable adaptable;
    @Inject
    ILogicalIDManager manager;
    @Inject
    IReachableCreator creator;

    public void start(IAdaptable adaptable) {
    }

    public boolean visit(Object o, IAdaptable adaptable) {
        this.adaptable = adaptable;
        ITraceabilityBuilder.IBuilderCallBack callBack = (ITraceabilityBuilder.IBuilderCallBack)adaptable.getAdapter(ITraceabilityBuilder.IBuilderCallBack.class);
        if (o instanceof IFile) {
            IFile file = (IFile)o;
            return "docx".equalsIgnoreCase(file.getFileExtension());
        }
        if (o instanceof DocumentTrace) {
            DocumentTrace trace = (DocumentTrace)o;
            System.out.println("trace = " + trace.toString());
            this.computeTraceability(trace, callBack);
        }
        return true;
    }

    public void end(IAdaptable adaptable) {
    }

    private void computeTraceability(DocumentTrace link, ITraceabilityBuilder.IBuilderCallBack callBack) {
        URI uri;
        TType tType = DocumentTTypeProvider.get(link.getSemantics());
        Reachable target = null;
        try {
            uri = new URI(link.getTargetURI());
            target = this.creator.getReachable(uri);
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        Reachable source = null;
        try {
            String sourceReqID = link.getSourceURI();
            uri = new URI(sourceReqID);
            source = this.creator.getReachable(uri);
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        System.out.println("compute traceability for link source = " + source);
        System.out.println("compute traceability for link target = " + target);
        if (target != null) {
            callBack.newUpwardRelation((Object)link, (Object)link.getResource(), (Object)source, Collections.singletonList(target), tType);
        }
    }
}

