/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.ui.naming.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.repository.data.ui.naming.Activator;
import org.polarsys.reqcycle.repository.data.ui.naming.IRequirementNamingPreferenceManager;
import org.polarsys.reqcycle.repository.data.ui.naming.typeconfiguration.TypeConfiguration;
import org.polarsys.reqcycle.repository.data.ui.naming.typeconfiguration.TypeConfigurationDialog;
import org.polarsys.reqcycle.repository.data.ui.naming.typeconfiguration.TypeConfigurationTypeCouple;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class RequirementNamingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    IRequirementNamingPreferenceManager namingPreferenceManager = (IRequirementNamingPreferenceManager)ZigguratInject.make(IRequirementNamingPreferenceManager.class);
    private List<IDataModel> inputModels;
    private ComboViewer comboViewer;
    private Combo combo;
    private TableViewer tableViewer;
    private Table table;
    private TableViewerColumn tableViewerTypeColumn;
    private TableColumn typeColumn;
    private TableViewerColumn tableViewerPatternColumn;
    private TableColumn configurationColumn;
    private Button btnModify;
    private Button btnAdd;
    private Button btnRemove;

    public static List<TypeConfigurationTypeCouple> createCouples(Map<IType, TypeConfiguration> map) {
        ArrayList<TypeConfigurationTypeCouple> list = new ArrayList<TypeConfigurationTypeCouple>();
        for (Map.Entry<IType, TypeConfiguration> entry : map.entrySet()) {
            IType type = entry.getKey();
            TypeConfiguration conf = entry.getValue();
            list.add(new TypeConfigurationTypeCouple(type, conf));
        }
        return list;
    }

    public static Map<IType, TypeConfiguration> getMap(List<TypeConfigurationTypeCouple> couples) {
        HashMap<IType, TypeConfiguration> map = new HashMap<IType, TypeConfiguration>();
        for (TypeConfigurationTypeCouple couple : couples) {
            map.put(couple.getType(), couple.getConfiguration());
        }
        return map;
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.comboViewer = new ComboViewer(container, 8);
        this.initCombo();
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.tableViewer = new TableViewer(composite, 67584);
        this.initTable();
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayoutData((Object)new GridData(0x1000000, 128, false, true, 1, 1));
        composite_1.setLayout((Layout)new GridLayout(1, false));
        this.btnAdd = new Button(composite_1, 0);
        this.btnAdd.setToolTipText("Add configuration");
        this.btnAdd.setImage(Activator.getImageDescriptor("/icons/add.gif").createImage());
        this.btnModify = new Button(composite_1, 0);
        this.btnModify.setToolTipText("Modify configuration");
        this.btnModify.setImage(Activator.getImageDescriptor("/icons/edit.png").createImage());
        this.btnRemove = new Button(composite_1, 0);
        this.btnRemove.setToolTipText("Remove configuration");
        this.btnRemove.setImage(Activator.getImageDescriptor("/icons/delete.gif").createImage());
        this.hookListeners();
        return container;
    }

    void initCombo() {
        this.combo = this.comboViewer.getCombo();
        this.combo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDataModel) {
                    IDataModel model = (IDataModel)element;
                    return model.getName();
                }
                return super.getText(element);
            }
        });
        this.comboViewer.setInput(this.inputModels);
        if (!this.inputModels.isEmpty()) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.inputModels.get(0)));
        }
    }

    void initTable() {
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewerTypeColumn = new TableViewerColumn(this.tableViewer, 0);
        this.typeColumn = this.tableViewerTypeColumn.getColumn();
        this.typeColumn.setWidth(100);
        this.typeColumn.setText("Type");
        this.typeColumn.setResizable(true);
        this.tableViewerPatternColumn = new TableViewerColumn(this.tableViewer, 0);
        this.configurationColumn = this.tableViewerPatternColumn.getColumn();
        this.configurationColumn.setWidth(100);
        this.configurationColumn.setText("Configuration");
        this.configurationColumn.setResizable(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewerTypeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TypeConfigurationTypeCouple) {
                    TypeConfigurationTypeCouple couple = (TypeConfigurationTypeCouple)element;
                    return couple.getType().getName();
                }
                return element == null ? "" : element.toString();
            }
        });
        this.tableViewerPatternColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TypeConfigurationTypeCouple) {
                    TypeConfigurationTypeCouple couple = (TypeConfigurationTypeCouple)element;
                    return couple.getConfiguration().getPattern();
                }
                return element == null ? "" : element.toString();
            }
        });
        this.loadTable();
    }

    void hookListeners() {
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDataModel datamodel = RequirementNamingPreferencePage.this.getSelectedDataModel();
                if (datamodel == null) {
                    return;
                }
                TypeConfigurationDialog dialog = new TypeConfigurationDialog(RequirementNamingPreferencePage.this.getShell(), datamodel);
                dialog.create();
                if (dialog.open() == 0) {
                    TypeConfigurationTypeCouple couple = dialog.getCouple();
                    ((List)RequirementNamingPreferencePage.this.tableViewer.getInput()).add(couple);
                    RequirementNamingPreferencePage.this.tableViewer.refresh(true);
                    RequirementNamingPreferencePage.this.namingPreferenceManager.setConfiguration(datamodel, couple.getType(), couple.getConfiguration());
                }
            }
        });
        this.btnModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeConfigurationTypeCouple old = RequirementNamingPreferencePage.this.getSelectedCouple();
                IDataModel datamodel = RequirementNamingPreferencePage.this.getSelectedDataModel();
                if (old == null) {
                    return;
                }
                TypeConfigurationDialog dialog = new TypeConfigurationDialog(RequirementNamingPreferencePage.this.getShell(), datamodel, old);
                dialog.create();
                if (dialog.open() == 0) {
                    TypeConfigurationTypeCouple couple = dialog.getCouple();
                    Collections.replaceAll((List)RequirementNamingPreferencePage.this.tableViewer.getInput(), old, couple);
                    RequirementNamingPreferencePage.this.tableViewer.refresh(true);
                    RequirementNamingPreferencePage.this.namingPreferenceManager.setConfiguration(datamodel, couple.getType(), couple.getConfiguration());
                }
            }
        });
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeConfigurationTypeCouple couple = RequirementNamingPreferencePage.this.getSelectedCouple();
                IDataModel datamodel = RequirementNamingPreferencePage.this.getSelectedDataModel();
                if (couple == null) {
                    return;
                }
                ((List)RequirementNamingPreferencePage.this.tableViewer.getInput()).remove(couple);
                RequirementNamingPreferencePage.this.tableViewer.refresh(true);
                RequirementNamingPreferencePage.this.namingPreferenceManager.removeConfiguration(datamodel, couple.getType());
            }
        });
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RequirementNamingPreferencePage.this.loadTable();
            }
        });
    }

    public void loadTable() {
        IDataModel sel = this.getSelectedDataModel();
        if (sel == null) {
            return;
        }
        Map<IType, TypeConfiguration> map = this.namingPreferenceManager.getConfigurations(sel);
        this.tableViewer.setInput(RequirementNamingPreferencePage.createCouples(map));
    }

    private IDataModel getSelectedDataModel() {
        return (IDataModel)((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement();
    }

    public TypeConfigurationTypeCouple getSelectedCouple() {
        return (TypeConfigurationTypeCouple)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
    }

    private void initInput() {
        this.inputModels = new ArrayList<IDataModel>();
        this.namingPreferenceManager.getDataModels();
        this.inputModels.addAll(this.namingPreferenceManager.getDataModels());
    }

    public boolean performOk() {
        this.namingPreferenceManager.saveConfigurations();
        return super.performOk();
    }

    public boolean performCancel() {
        this.namingPreferenceManager.clearConfigurations();
        return super.performCancel();
    }

    public void init(IWorkbench workbench) {
        ZigguratInject.inject((Object[])new Object[]{this});
        this.initInput();
    }
}

