/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.ui.naming.impl;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.IRequirementNamingManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.repository.data.ui.naming.IRequirementNamingPreferenceManager;
import org.polarsys.reqcycle.repository.data.ui.naming.typeconfiguration.TypeConfiguration;
import org.polarsys.reqcycle.repository.data.ui.naming.variable.IVariableWithID;

@Singleton
public class RequirementNamingManager
implements IRequirementNamingManager {
    @Inject
    IRequirementNamingPreferenceManager prefManager;
    @Inject
    IDataModelManager dataModelManager;

    public String getID(EObject section, AbstractElement element) {
        IRequirementType type = this.dataModelManager.getType(element);
        if (type == null) {
            return null;
        }
        IDataModel datamodel = type.getDataModel();
        TypeConfiguration conf = this.prefManager.getConfiguration(datamodel, (IType)type);
        if (conf == null) {
            return null;
        }
        String id = conf.getPattern();
        for (IVariableWithID var : this.prefManager.getAllRegisteredVariables().values()) {
            if (!id.contains("{" + var.getName() + "}")) continue;
            String value = var.getValue(section, element);
            if (value == null) {
                return null;
            }
            id = id.replace("{" + var.getName() + "}", value);
        }
        return id;
    }
}

