/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.emf.utils;

import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class EMFUtils {
    private static final List<URIHandler> DEFAULT_HANDLERS = URIHandler.DEFAULT_HANDLERS;
    private static ILogger logger = (ILogger)ZigguratInject.make(ILogger.class);

    public static Reachable getReachable(URI uri) {
        try {
            IReachableCreator creator = (IReachableCreator)ZigguratInject.make(IReachableCreator.class);
            return creator.getReachable(new java.net.URI(uri.toString()));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static EObject getEObject(Reachable t, ResourceSet set) {
        EObject result = null;
        URI uri = EMFUtils.getEMFURI(t);
        Resource r = set.getResource(uri.trimFragment(), true);
        if (r != null) {
            result = r.getEObject(uri.fragment());
        }
        return result;
    }

    public static URI getEMFURI(Reachable t) {
        return URI.createURI((String)t.toString());
    }

    public static Reachable getReachable(EObject eobject) {
        if (eobject == null) {
            return null;
        }
        try {
            IReachableCreator creator = (IReachableCreator)ZigguratInject.make(IReachableCreator.class);
            return creator.getReachable(new java.net.URI(EcoreUtil.getURI((EObject)eobject).toString()), (Object)eobject);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static ResourceSet getFastAndUnresolvingResourceSet() {
        ResourceSetImpl set = new ResourceSetImpl(){
            URI firstURI = null;

            public Resource getResource(URI uri, boolean loadOnDemand) {
                if (this.firstURI == null) {
                    this.firstURI = uri;
                }
                if (uri.equals(this.firstURI)) {
                    return super.getResource(uri, loadOnDemand);
                }
                return null;
            }
        };
        set.eSetDeliver(false);
        set.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
        set.getLoadOptions().put("DEFER_ATTACHMENT", true);
        set.getLoadOptions().put("DISABLE_NOTIFY", true);
        return set;
    }

    public static ResourceSet getFAURSWithPathMaps() {
        ResourceSetImpl set = new ResourceSetImpl(){
            URI firstURI = null;

            public Resource getResource(URI uri, boolean loadOnDemand) {
                try {
                    if (this.firstURI == null) {
                        this.firstURI = uri;
                    }
                    if (uri.equals(this.firstURI)) {
                        return super.getResource(uri, loadOnDemand);
                    }
                    if (uri.isPlatformPlugin() || "pathmap".equals(uri.scheme()) || "http".equals(uri.scheme())) {
                        return super.getResource(uri, loadOnDemand);
                    }
                }
                catch (Exception e) {
                    logger.log((IStatus)new Status(4, "org.polarsys.reqcycle.emf", e.getMessage()));
                }
                return null;
            }
        };
        set.eSetDeliver(false);
        set.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
        set.getLoadOptions().put("DEFER_ATTACHMENT", true);
        return set;
    }

    public static java.net.URI getURI(EObject e) {
        return EMFUtils.getURI(e.eResource());
    }

    public static java.net.URI getURI(Resource r) {
        try {
            return new java.net.URI(r.getURI().toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getExtension(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        int lastIndexOf = path.lastIndexOf(".");
        if (lastIndexOf < 0) {
            return "";
        }
        return path.substring(lastIndexOf + 1, path.length());
    }

    public static boolean isEMF(java.net.URI uri) {
        return EMFUtils.isEMF(URI.createURI((String)uri.toString()));
    }

    public static boolean isEMF(URI uri) {
        boolean handles = false;
        for (URIHandler u : DEFAULT_HANDLERS) {
            if (!u.canHandle(uri)) continue;
            handles = true;
            break;
        }
        return handles && Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey(EMFUtils.getExtension(uri.path()));
    }

    public static boolean isEMF(URI uri, boolean checkRegisteredExtension) {
        if (checkRegisteredExtension) {
            return EMFUtils.isEMF(uri);
        }
        boolean handles = false;
        for (URIHandler u : DEFAULT_HANDLERS) {
            if (!u.canHandle(uri)) continue;
            handles = true;
            break;
        }
        return handles;
    }
}

