/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.table.providers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class TraceabilityLazyContentProvider<T>
implements ILazyContentProvider {
    private TableViewer viewer;
    private Class<? extends T> clazz;
    private LoadingCache<Integer, T> cache;

    public <E extends T> TraceabilityLazyContentProvider(Class<E> clazz, TableViewer viewer) {
        this.clazz = clazz;
        this.viewer = viewer;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, final Object newInput) {
        if (newInput instanceof Iterable) {
            CacheLoader loader = new CacheLoader<Integer, T>(){
                private int lastArg = -1;
                private Iterator<?> iterator;

                public T load(Integer arg0) throws Exception {
                    Object value = null;
                    if (this.iterator == null || this.lastArg >= arg0) {
                        this.iterator = ((Iterable)newInput).iterator();
                        this.lastArg = -1;
                    }
                    int i = this.lastArg;
                    while (i < arg0) {
                        if (this.iterator.hasNext()) {
                            value = TraceabilityLazyContentProvider.this.clazz.cast(this.iterator.next());
                        }
                        ++i;
                    }
                    this.lastArg = arg0;
                    return value;
                }
            };
            this.cache = CacheBuilder.newBuilder().maximumSize(200L).build(loader);
        }
    }

    public void updateElement(int index) {
        try {
            this.viewer.replace(this.cache.get((Object)index), index);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static <T> TraceabilityLazyContentProvider<T> create(Class<T> clazz, TableViewer viewer) {
        return new TraceabilityLazyContentProvider<T>(clazz, viewer);
    }

    public void clearCache() {
        this.cache.invalidateAll();
    }
}

