/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.codec.binary.Base64;

public class SerializationUtils {
    public static String serialize(Object object) {
        ObjectOutputStream objOutStrm = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objOutStrm = new ObjectOutputStream(byteArrayOutputStream);
            objOutStrm.writeObject(object);
            objOutStrm.flush();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            String string = SerializationUtils.encode(bytes);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (objOutStrm != null) {
                try {
                    objOutStrm.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static <T> T deserialize(String inputString) {
        ObjectInputStream stream = null;
        try {
            Object result;
            byte[] inputBytes = SerializationUtils.decode(inputString);
            stream = new ObjectInputStream(new ByteArrayInputStream(inputBytes));
            Object object = result = stream.readObject();
            return (T)object;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static String encode(byte[] bytes) {
        Base64 encoder = new Base64(true);
        return encoder.encodeToString(bytes);
    }

    private static byte[] decode(String inputString) {
        Base64 encoder = new Base64(true);
        return encoder.decode(inputString);
    }
}

