/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tika.parser.microsoft.Cell;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.StylizedCell;

public class CellsGroup
implements Iterable<StylizedCell> {
    private List<StylizedCell> _cells = new ArrayList<StylizedCell>();
    private int _rowIndex;
    private int _firstColumn;
    private int _lastColumn;

    public CellsGroup() {
        this._rowIndex = -1;
        this._firstColumn = -1;
    }

    public List<StylizedCell> getCells() {
        return this._cells;
    }

    public CellsGroup(Point startPoint, StylizedCell startCell) {
        this._cells.add(startCell);
        this._rowIndex = startPoint.y;
        this._firstColumn = startPoint.x;
        this._lastColumn = startPoint.x;
    }

    public int getCellsNb() {
        return this._cells.size();
    }

    public int getFirstColumn() {
        return this._firstColumn;
    }

    public int getLastColumn() {
        return this._lastColumn;
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public void addCell(Point cellPoint, StylizedCell cellToAdd) {
        if (this._cells.size() == 0) {
            this._rowIndex = cellPoint.y;
            this._firstColumn = cellPoint.x;
        }
        this._lastColumn = cellPoint.x;
        this._cells.add(cellToAdd);
    }

    public boolean isAligned(CellsGroup cellgroup) {
        return this._firstColumn == cellgroup._firstColumn && this.getCellsNb() == cellgroup.getCellsNb() && Math.abs(this._rowIndex - cellgroup._rowIndex) != 1;
    }

    public boolean isWithin(CellsGroup cellgroup) {
        return this._firstColumn >= cellgroup._firstColumn && this._firstColumn + this.getCellsNb() <= cellgroup._firstColumn + cellgroup.getCellsNb();
    }

    public boolean isRightAligned(CellsGroup cellgroup) {
        return this._firstColumn + this.getCellsNb() == cellgroup._firstColumn + cellgroup.getCellsNb() && Math.abs(this._rowIndex - cellgroup._rowIndex) != 1;
    }

    public String toString() {
        String str = "";
        for (Cell cell : this._cells) {
            if (!(cell instanceof StylizedCell)) continue;
            str = String.valueOf(str) + "<>";
            str = String.valueOf(str) + ((StylizedCell)cell).getText();
        }
        return str;
    }

    public String getText() {
        String str = "";
        for (Cell cell : this._cells) {
            if (!(cell instanceof StylizedCell)) continue;
            str = String.valueOf(str) + " ";
            str = String.valueOf(str) + ((StylizedCell)cell).getText();
        }
        return str;
    }

    @Override
    public Iterator<StylizedCell> iterator() {
        return this._cells.iterator();
    }

    public void setLastColumn(int lastColumn) {
        this._lastColumn = lastColumn;
    }
}

