/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.internal.target;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.PDEExtensionRegistry;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.launching.ext.AUTInformation;
import org.eclipse.rcptt.launching.ext.OriginalOrderProperties;
import org.eclipse.rcptt.launching.ext.Q7LaunchDelegateUtils;
import org.eclipse.rcptt.launching.injection.Directory;
import org.eclipse.rcptt.launching.injection.Entry;
import org.eclipse.rcptt.launching.injection.InjectionConfiguration;
import org.eclipse.rcptt.launching.injection.UpdateSite;
import org.eclipse.rcptt.launching.internal.target.PDEHelper;
import org.eclipse.rcptt.launching.internal.target.Q7Target;
import org.eclipse.rcptt.launching.p2utils.P2Utils;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;
import org.eclipse.rcptt.util.FileUtil;

public class TargetPlatformHelper
implements ITargetPlatformHelper {
    private static final boolean DEBUG = "true".equals(Platform.getDebugOption((String)"org.eclipse.rcptt.launching.ext/debug"));
    private static final boolean DEBUG_BUNDLES = "true".equals(Platform.getDebugOption((String)"org.eclipse.rcptt.launching.ext/debug/bundles"));
    public static final String IDE_APPLICATION = "org.eclipse.ui.ide.workbench";
    public static final String APPLICATION_PROPERTY = "eclipse.application";
    public static final String PRODUCT_PROPERTY = "eclipse.product";
    private static final String ID_PROPERTY = "id";
    private static final String OSGI_BUNDLES = "osgi.bundles";
    public static final String SIMPLECONFIGURATOR = "org.eclipse.equinox.simpleconfigurator";
    private static final String SC_BUNDLES_PATH = "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info";
    private IStatus status = Status.OK_STATUS;
    private final ITargetDefinition target;
    private final ArrayList<ITargetLocation> extra = new ArrayList();
    private IPluginModelBase[] models;
    private PDEExtensionRegistry registry;
    private Q7Target q7target = new Q7Target();
    private IPluginModelBase weavingHook;
    private IFileArtifactRepository repository;
    private static final String GTK_VERSION = "--launcher.GTK_version";
    private static final String VMARGS = "-vmargs";
    private static final String VM = "-vm";
    private static final String VMARG_ADD_MODULES = "--add-modules";
    private static final String VMARG_PERMIT_ILLEGAL_ACCESS = "--permit-illegal-access";
    private static final String VMARG_ADD_OPENS = "--add-opens";
    private static final String VMARG_ALL_UNNAMED = "ALL-UNNAMED";
    private static final String INTERNAL_ARCH_I386 = "i386";
    private static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    private static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    private static final String PROP_CONFIG_CASCADED = "osgi.configuration.cascaded";
    public static final String VARIABLE_DELIM_STRING = "$";
    public static final char VARIABLE_DELIM_CHAR = '$';
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String PROP_OS = "osgi.os";
    private static final String PROP_WS = "osgi.ws";
    private static final String PROP_ARCH = "osgi.arch";
    private static final String CONFIG_DIR = "configuration/";
    private static final String CONFIG_FILE = "config.ini";
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";
    private static final String PROP_USER_HOME = "user.home";
    private static final String PROP_USER_DIR = "user.dir";
    private static final String FILE_SCHEME = "file:";

    public TargetPlatformHelper(ITargetDefinition target) {
        Preconditions.checkNotNull((Object)target);
        this.target = target;
        this.initialize();
    }

    @Override
    public Q7Target getQ7Target() {
        return this.q7target;
    }

    @Override
    public String getUserArea() {
        Q7Target.AutInstall install = this.getAutInstall();
        if (install == null) {
            return null;
        }
        return install.userArea;
    }

    @Deprecated
    public boolean isValid() {
        return this.getStatus().isOK();
    }

    @Override
    public boolean isResolved() {
        if (this.target != null) {
            return this.target.isResolved();
        }
        return false;
    }

    public boolean isInstanceContainerValid() {
        return this.getInstanceContainer() != null && this.getInstanceContainer().getStatus().isOK();
    }

    @Override
    public IStatus getStatus() {
        if (this.status == null) {
            return new Status(4, "org.eclipse.rcptt.launching.ext", "Target platform is unset");
        }
        return this.status;
    }

    @Deprecated
    public String getErrorMessage() {
        return this.getNonMultiStatusMessage(this.getStatus());
    }

    public String getWarningMessage() {
        if (this.target != null) {
            IStatus bundleStatus = this.getBundleWarningStatus();
            return this.getNonMultiStatusMessage(bundleStatus);
        }
        return null;
    }

    public IStatus getBundleStatus() {
        ITargetLocation[] containers = this.getBundleContainers();
        if (containers != null) {
            MultiStatus result = new MultiStatus("org.eclipse.pde.core", 0, Messages.TargetDefinition_5, null);
            int i = 0;
            while (i < containers.length) {
                ITargetLocation container = containers[i];
                IStatus containerStatus = container.getStatus();
                if (containerStatus != null && !containerStatus.isOK()) {
                    result.add(containerStatus);
                }
                ++i;
            }
            if (!result.isOK()) {
                return result;
            }
            TargetBundle[] bundles = this.target.getBundles();
            int i2 = 0;
            while (i2 < bundles.length) {
                TargetBundle bundle = bundles[i2];
                if (!bundle.getStatus().isOK()) {
                    File file;
                    BundleInfo info = bundle.getBundleInfo();
                    URI uri = info.getLocation();
                    if (uri != null && !(file = new File(uri)).exists()) {
                        this.reportUnexistingFile(info);
                    } else {
                        result.add(bundle.getStatus());
                    }
                }
                ++i2;
            }
            if (result.isOK()) {
                return Status.OK_STATUS;
            }
            return result;
        }
        return Status.OK_STATUS;
    }

    private void reportUnexistingFile(BundleInfo info) {
        Q7LaunchingPlugin.log((IStatus)Q7LaunchingPlugin.createStatus((int)2, (String)("Skip nonexistent bundle: " + info.getSymbolicName() + ", then resolve configuration."), null));
    }

    public IStatus getBundleWarningStatus() {
        ITargetLocation[] containers = this.getBundleContainers();
        if (containers != null) {
            MultiStatus result = new MultiStatus("org.eclipse.pde.core", 0, Messages.TargetDefinition_5, null);
            TargetBundle[] bundles = this.target.getBundles();
            int i = 0;
            while (i < bundles.length) {
                File file;
                BundleInfo info;
                URI uri;
                TargetBundle bundle = bundles[i];
                IStatus status = bundle.getStatus();
                if (!status.isOK() && (uri = (info = bundle.getBundleInfo()).getLocation()) != null && !(file = new File(uri)).exists()) {
                    Status st = new Status(2, status.getPlugin(), status.getMessage(), status.getException());
                    result.add((IStatus)st);
                }
                ++i;
            }
            if (result.isOK()) {
                return Status.OK_STATUS;
            }
            return result;
        }
        return Status.OK_STATUS;
    }

    private String getNonMultiStatusMessage(IStatus st) {
        if (st != null && st.isMultiStatus()) {
            IStatus[] children;
            StringBuilder buf = new StringBuilder();
            IStatus[] iStatusArray = children = st.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String msg;
                IStatus iStatus = iStatusArray[n2];
                if (iStatus.isMultiStatus() && (msg = this.getNonMultiStatusMessage(iStatus)) != null) {
                    buf.append(msg).append('\n');
                }
                if (!iStatus.isOK()) {
                    buf.append(iStatus.getMessage()).append('\n');
                }
                ++n2;
            }
            return buf.toString();
        }
        return st == null ? "" : st.getMessage();
    }

    private void initialize() {
        this.extra.clear();
        this.q7target = new Q7Target();
        if (this.target != null && this.target.getTargetLocations() != null) {
            ITargetLocation[] containers;
            ITargetLocation[] iTargetLocationArray = containers = this.target.getTargetLocations();
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation iUBundleContainer = iTargetLocationArray[n2];
                if (iUBundleContainer instanceof ProfileBundleContainer) {
                    this.getQ7Target().setInstall(iUBundleContainer);
                }
                this.extra.add(iUBundleContainer);
                ++n2;
            }
        }
    }

    @Override
    public void setTargetName(String name) {
        if (this.target != null) {
            this.target.setName(name);
        }
    }

    @Override
    public String getName() {
        if (this.target != null) {
            return this.target.getName();
        }
        return "";
    }

    @Override
    public void save() throws CoreException {
        if (!this.getStatus().isOK()) {
            throw new CoreException(this.getStatus());
        }
        TargetPlatformManager.deleteTargetPlatform(this.target.getName());
        try {
            ITargetPlatformService service = PDEHelper.getTargetService();
            service.saveTargetDefinition(this.target);
        }
        catch (CoreException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
    }

    @Override
    public String getTargetPlatformProfilePath() {
        ProfileBundleContainer container = this.getInstanceContainer();
        if (container == null) {
            return "";
        }
        try {
            return container.getLocation(true).toString();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete() {
        try {
            if (this.target != null && this.target.getHandle() != null) {
                PDEHelper.getTargetService().deleteTarget(this.target.getHandle());
            }
        }
        catch (CoreException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
    }

    @Override
    public ITargetDefinition getTarget() {
        return this.target;
    }

    public void update() {
        ArrayList<ITargetLocation> newContainers = new ArrayList<ITargetLocation>();
        newContainers.addAll(Arrays.asList(this.target.getTargetLocations()));
        if (this.extra != null) {
            newContainers.addAll(this.extra);
        }
        this.target.setTargetLocations(newContainers.toArray(new ITargetLocation[newContainers.size()]));
        this.models = null;
        this.registry = null;
    }

    private IPluginModelBase[] getTargetModels() {
        this.calcModels();
        return this.models;
    }

    @Override
    public IPluginModelBase getWeavingHook() {
        this.calcModels();
        return this.weavingHook;
    }

    private void calcModels() {
        if (this.models == null) {
            List<IPluginModelBase> bundles = this.sumBundles();
            this.weavingHook = this.filterHooks(bundles);
            this.models = bundles.toArray(new IPluginModelBase[0]);
        }
    }

    private List<IPluginModelBase> sumBundles() {
        TargetBundle[] bundles = this.getTarget().getAllBundles();
        if (bundles == null) {
            return new ArrayList<IPluginModelBase>();
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        TargetBundle[] targetBundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            TargetBundle bundle = targetBundleArray[n2];
            uris.add(bundle.getBundleInfo().getLocation());
            ++n2;
        }
        PDEState state = new PDEState(uris.toArray(new URI[uris.size()]), true, true, (IProgressMonitor)new NullProgressMonitor());
        ArrayList<IPluginModelBase> targetModels = new ArrayList<IPluginModelBase>(Arrays.asList(state.getTargetModels()));
        if (DEBUG_BUNDLES) {
            ArrayList<String> targetModelsLocations = new ArrayList<String>();
            for (IPluginModelBase model : targetModels) {
                targetModelsLocations.add(model.getInstallLocation());
            }
            TargetPlatformHelper.debug("Bundles: " + targetModelsLocations);
        }
        return targetModels;
    }

    private IPluginModelBase filterHooks(List<IPluginModelBase> models) {
        ArrayList<IPluginModelBase> hooks = new ArrayList<IPluginModelBase>();
        for (IPluginModelBase model : models) {
            String name = model.getBundleDescription().getSymbolicName();
            if (!Objects.equal((Object)name, (Object)"org.eclipse.equinox.weaving.hook")) continue;
            hooks.add(model);
        }
        switch (hooks.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (IPluginModelBase)hooks.get(0);
            }
        }
        IPluginModelBase maxHook = (IPluginModelBase)hooks.get(0);
        int i = 1;
        while (i < hooks.size()) {
            IPluginModelBase hook = (IPluginModelBase)hooks.get(i);
            if (hook.getBundleDescription().getVersion().compareTo(maxHook.getBundleDescription().getVersion()) > 0) {
                maxHook = hook;
            }
            ++i;
        }
        hooks.remove(maxHook);
        models.removeAll(hooks);
        return maxHook;
    }

    private IStatus validateBundles(IProgressMonitor monitor) {
        LaunchValidationOperation validation = new LaunchValidationOperation(null){

            protected Set<IPluginModelBase> getModels() throws CoreException {
                return new HashSet<IPluginModelBase>(Arrays.asList(TargetPlatformHelper.this.getTargetModels()));
            }

            protected IExecutionEnvironment[] getMatchingEnvironments() throws CoreException {
                IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
                IExecutionEnvironment[] envs = manager.getExecutionEnvironments();
                return envs;
            }
        };
        try {
            StringBuilder b = new StringBuilder();
            validation.run(monitor);
            Map input = validation.getInput();
            Set entrySet = input.entrySet();
            for (Map.Entry e : entrySet) {
                Object value = e.getKey();
                if (!(value instanceof ResolverError)) continue;
                b.append(value.toString()).append("\n");
            }
            if (b.length() > 0) {
                return new Status(4, "org.eclipse.rcptt.launching.ext", "Bundle validation failed: " + b.toString());
            }
        }
        catch (CoreException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
            this.status = e.getStatus();
            return this.status;
        }
        catch (OperationCanceledException e) {
            this.status = Status.CANCEL_STATUS;
            return this.status;
        }
        this.status = Status.OK_STATUS;
        return this.status;
    }

    @Override
    public String[] getProducts() {
        if (!this.isValid()) {
            return new String[0];
        }
        PDEExtensionRegistry reg = this.getRegistry();
        TreeSet<String> result = new TreeSet<String>();
        IExtension[] extensions = reg.findExtensions("org.eclipse.core.runtime.products", false);
        int i = 0;
        while (i < extensions.length) {
            String id;
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            if (elements.length == 1 && "product".equals(elements[0].getName()) && (id = extensions[i].getUniqueIdentifier()) != null && id.trim().length() > 0) {
                result.add(id);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getApplications() {
        if (!this.isValid()) {
            return new String[0];
        }
        PDEExtensionRegistry reg = this.getRegistry();
        TreeSet<String> result = new TreeSet<String>();
        IExtension[] extensions = reg.findExtensions("org.eclipse.core.runtime.applications", false);
        int i = 0;
        while (i < extensions.length) {
            String id = extensions[i].getUniqueIdentifier();
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            if (elements.length == 1) {
                boolean visible;
                String visiblity = elements[0].getAttribute("visible");
                boolean bl = visible = visiblity == null ? true : Boolean.valueOf(visiblity);
                if (id != null && visible) {
                    result.add(id);
                }
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private PDEExtensionRegistry getRegistry() {
        if (this.registry == null) {
            this.registry = new PDEExtensionRegistry(this.getTargetModels());
        }
        return this.registry;
    }

    @Override
    public IStatus resolve(IProgressMonitor monitor) {
        ITargetDefinition target = this.getTarget();
        if (target != null) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)("Resolving " + this.getName()), (int)2);
            try {
                this.status = target.resolve((IProgressMonitor)m.newChild(1, 0));
                if (!this.status.isOK()) {
                    IStatus iStatus = this.status;
                    return iStatus;
                }
                this.status = this.validateBundles((IProgressMonitor)m.newChild(1, 0));
                if (!this.status.isOK()) {
                    IStatus iStatus = this.status;
                    return iStatus;
                }
                IStatus iStatus = this.status = this.getBundleStatus();
                return iStatus;
            }
            finally {
                m.done();
            }
        }
        this.status = Status.CANCEL_STATUS;
        return this.status;
    }

    Q7Target.AutInstall getAutInstall() {
        Q7Target target = this.getQ7Target();
        if (target == null) {
            return null;
        }
        return target.getInstall();
    }

    @Override
    public OriginalOrderProperties getConfigIniProperties() {
        return this.getAutInstall().getConfig();
    }

    protected String getEclipseProductFileProperty(String name) {
        Properties props = this.getEclipseProductFileProperties();
        return props == null ? null : props.getProperty(name);
    }

    public Properties getEclipseProductFileProperties() {
        File iniFile = new File(this.getTargetPlatformProfilePath(), PRODUCT_SITE_MARKER);
        if (!iniFile.exists()) {
            return null;
        }
        Properties pini = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(iniFile);
            pini.load(fis);
            fis.close();
            Properties properties = pini;
            return properties;
        }
        catch (IOException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                Q7ExtLaunchingPlugin.getDefault().log(e);
            }
        }
        return null;
    }

    @Override
    public String getDefaultApplication() {
        String app = this.getConfigIniProperty(APPLICATION_PROPERTY);
        TargetPlatformHelper.debug("Application from config.ini: " + app);
        HashSet<String> apps = new HashSet<String>(Arrays.asList(this.getApplications()));
        TargetPlatformHelper.debug("Valid applications: " + apps);
        return this.isValidId(app, apps) ? app : (this.isValidId(IDE_APPLICATION, apps) ? IDE_APPLICATION : null);
    }

    @Override
    public String getBundlesList() {
        String bundles = this.getConfigIniProperty(OSGI_BUNDLES);
        return bundles == null ? org.eclipse.pde.internal.core.TargetPlatformHelper.getDefaultBundleList() : org.eclipse.pde.internal.core.TargetPlatformHelper.stripPathInformation((String)bundles);
    }

    protected String getConfigIniProperty(String name) {
        OriginalOrderProperties config = this.getConfigIniProperties();
        if (config == null) {
            return null;
        }
        return config.getProperty(name);
    }

    protected boolean isValidId(String id, Set<String> available) {
        return id == null ? false : available.contains(id);
    }

    @Override
    public String getDefaultProduct() {
        HashSet<String> values = new HashSet<String>(Arrays.asList(this.getProducts()));
        TargetPlatformHelper.debug("Valid products: " + values);
        String product = null;
        String productProperty = this.getConfigIniProperty(PRODUCT_PROPERTY);
        if (this.isValidId(productProperty, values)) {
            product = productProperty;
        }
        TargetPlatformHelper.debug("eclipse.product from config.ini: " + productProperty);
        productProperty = this.getEclipseProductFileProperty("id");
        if (this.isValidId(productProperty, values)) {
            product = productProperty;
        }
        TargetPlatformHelper.debug("id from config.ini: " + productProperty);
        List<File> iniFiles = this.getAppIniFiles();
        for (File file : iniFiles) {
            productProperty = this.readProductFromIniFile(file);
            if (this.isValidId(productProperty, values)) {
                product = productProperty;
            }
            TargetPlatformHelper.debug("Product from " + file + ": " + productProperty);
        }
        return product;
    }

    public ITargetLocation[] getBundleContainers() {
        if (this.target == null) {
            return new ITargetLocation[0];
        }
        ITargetLocation[] bundleContainers = this.target.getTargetLocations();
        if (bundleContainers == null) {
            return new ITargetLocation[0];
        }
        return bundleContainers;
    }

    @Override
    public IStatus applyInjection(InjectionConfiguration configuration, IProgressMonitor monitor) {
        Iterables.removeAll(this.extra, Arrays.asList(this.getInstanceContainer()));
        EList entries = configuration.getEntries();
        monitor.beginTask("Apply injection plugins", 20 + entries.size() * 20);
        for (Entry entry : entries) {
            SubProgressMonitor mon = new SubProgressMonitor(monitor, 20);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Status result = new Status(4, "org.eclipse.rcptt.launching.ext", "Unknown injection type: " + entry.getClass().getName());
            if (entry instanceof UpdateSite) {
                result = this.processUpdateSite((IProgressMonitor)mon, (UpdateSite)entry);
            } else if (entry instanceof Directory) {
                result = this.processDirectory((Directory)entry);
            }
            if (!result.matches(12)) continue;
            return result;
        }
        this.update();
        IStatus resolveStatus = this.resolve(monitor);
        if (!resolveStatus.isOK()) {
            return resolveStatus;
        }
        if (this.getWeavingHook() == null) {
            this.status = TargetPlatformHelper.createError("No org.eclipse.weaving hook plugin");
            return this.status;
        }
        try {
            this.save();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private IStatus processDirectory(Directory entry) {
        String path = entry.getPath();
        MultiStatus rv = new MultiStatus("org.eclipse.rcptt.launching.ext", 0, "Processing " + path, null);
        if (path.startsWith("platform:///")) {
            try {
                URL resolve = FileLocator.resolve((URL)URI.create(path).toURL());
                path = resolve.getPath();
            }
            catch (MalformedURLException e) {
                rv.add((IStatus)new Status(2, "org.eclipse.rcptt.launching.ext", e.getMessage(), (Throwable)e));
            }
            catch (IOException e) {
                rv.add((IStatus)new Status(2, "org.eclipse.rcptt.launching.ext", e.getMessage(), (Throwable)e));
            }
        }
        ITargetLocation container = PDEHelper.getTargetService().newDirectoryLocation(path);
        this.extra.add(container);
        return Status.OK_STATUS;
    }

    private static final IStatus createError(String message) {
        return TargetPlatformHelper.createError(message, null);
    }

    private static final IStatus createError(String message, Throwable error) {
        if (message == null && error != null) {
            message = error.getMessage();
        }
        return new Status(4, "org.eclipse.rcptt.launching.ext", message, error);
    }

    private IStatus processUpdateSite(IProgressMonitor monitor, UpdateSite site) {
        try {
            URI uri = URI.create(Platform.getOS().equals("win32") ? site.getUri().replace('\\', '/') : site.getUri());
            IMetadataRepository repository = PDEHelper.safeLoadRepository(uri, monitor);
            IArtifactRepository artifactRepository = PDEHelper.safeLoadArtifactRepository(uri, monitor);
            if (repository == null || artifactRepository == null) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return TargetPlatformHelper.createError("Failed to load update site:" + uri);
            }
            ArrayList unitsToInstall = new ArrayList();
            IQuery finalQuery = P2Utils.createQuery((UpdateSite)site);
            IQueryResult result = repository.query(finalQuery, monitor);
            Set availableUnits = result.toSet();
            if (site.isAllUnits()) {
                unitsToInstall.addAll(availableUnits);
            } else {
                P2Utils.expandFeatures((IProgressMonitor)monitor, (IMetadataRepository)repository, (Set)availableUnits);
                Set unitIDs = P2Utils.mapUnitsToId((Set)availableUnits);
                HashSet missingUnits = new HashSet(site.getUnits());
                missingUnits.removeAll(unitIDs);
                if (!missingUnits.isEmpty()) {
                    return TargetPlatformHelper.createError("Few units are not available:" + Arrays.toString(missingUnits.toArray()));
                }
                unitsToInstall.addAll(availableUnits);
            }
            if (unitsToInstall.size() > 0) {
                IInstallableUnit[] unitsAsArray = unitsToInstall.toArray(new IInstallableUnit[unitsToInstall.size()]);
                URI[] uriArray = new URI[]{uri};
                ITargetLocation container = PDEHelper.getTargetService().newIULocation(unitsAsArray, uriArray, 2);
                this.extra.add(container);
            }
            IFileArtifactRepository filesRepository = P2TargetUtils.getBundlePool();
            ArrayList toInstall = new ArrayList();
            toInstall.addAll(unitsToInstall);
            P2Utils.installUnits((IProgressMonitor)monitor, (IArtifactRepository)artifactRepository, (IFileArtifactRepository)filesRepository, toInstall, (int)10, null, (boolean)false, (IProvisioningAgent)P2Utils.getProvisioningAgent());
            MultiStatus rv = new MultiStatus("org.eclipse.rcptt.launching.ext", 0, "Failed to install next units from repository: " + repository.getName(), null);
            if (toInstall.size() > 0) {
                for (IInstallableUnit u : toInstall) {
                    rv.add(TargetPlatformHelper.createError(u.getId()));
                }
                return rv;
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    @Override
    public Map<String, String> getIniEnvironment() {
        List<File> iniFiles = this.getAppIniFiles();
        HashMap<String, String> result = new HashMap<String, String>();
        for (File file : iniFiles) {
            Map<String, String> envs = this.readEnvironmentFromIniFile(file);
            if (envs == null) continue;
            result.putAll(envs);
        }
        return result;
    }

    @Override
    public String getIniVMArgs() {
        List<File> iniFiles = this.getAppIniFiles();
        for (File file : iniFiles) {
            String vmArgs = this.readVMArgsFromIniFile(file);
            if (vmArgs == null) continue;
            return vmArgs;
        }
        return null;
    }

    private List<File> getAppIniFiles() {
        File eclipseIniFile;
        int n;
        ArrayList<File> iniFiles = new ArrayList<File>();
        if (this.getInstanceContainer() == null) {
            return iniFiles;
        }
        File installDirectory = new File(this.getTargetPlatformProfilePath());
        if (!installDirectory.exists()) {
            return iniFiles;
        }
        if (Platform.getOS().equals("macosx")) {
            File[] listFiles;
            File[] fileArray = listFiles = installDirectory.listFiles();
            n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().contains(".app")) {
                    installDirectory = new File(file, "/Contents/MacOS");
                    break;
                }
                ++n2;
            }
        }
        if ((eclipseIniFile = new File(installDirectory, "eclipse.ini")).exists()) {
            iniFiles.add(eclipseIniFile);
            return iniFiles;
        }
        File[] list = installDirectory.listFiles();
        if (list != null) {
            File[] fileArray = list;
            int n3 = list.length;
            n = 0;
            while (n < n3) {
                File file = fileArray[n];
                if (file.getName().endsWith(".ini")) {
                    iniFiles.add(file);
                }
                ++n;
            }
        }
        return iniFiles;
    }

    /*
     * Exception decompiling
     */
    private String readProductFromIniFile(File eclipseIniFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String readLauncherLibraryFromIniFile(File eclipseIniFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> parseIniFile(File eclipseIni) {
        if (eclipseIni == null || !eclipseIni.exists()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (String line : Files.readLines((File)eclipseIni, (Charset)Charsets.UTF_8)) {
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                result.add(line);
            }
        }
        catch (IOException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
        return result;
    }

    private String getVmArg(File eclipseIniFile) {
        List<String> lines = this.parseIniFile(eclipseIniFile);
        int vmIndex = lines.indexOf(VM) + 1;
        return vmIndex == 0 || vmIndex == lines.size() ? null : lines.get(vmIndex);
    }

    @Override
    public String getVmFromIniFile() {
        for (File file : this.getAppIniFiles()) {
            String result = this.getVmArg(file);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Map<String, String> readEnvironmentFromIniFile(File eclipseIniFile) {
        if (!eclipseIniFile.exists()) {
            return null;
        }
        List<String> lines = this.parseIniFile(eclipseIniFile);
        HashMap<String, String> envs = new HashMap<String, String>();
        int gtkVersionIdx = lines.indexOf(GTK_VERSION);
        if (gtkVersionIdx != -1 && Platform.getOS().equals("linux")) {
            String gtkVersion = lines.get(gtkVersionIdx + 1);
            if ("2".equals(gtkVersion)) {
                envs.put("SWT_GTK3", "0");
            } else {
                envs.put("SWT_GTK3", "1");
            }
        }
        return envs;
    }

    private String readVMArgsFromIniFile(File eclipseIniFile) {
        if (!eclipseIniFile.exists()) {
            return null;
        }
        List<String> lines = this.parseIniFile(eclipseIniFile);
        int vmargsIndex = lines.indexOf(VMARGS);
        if (vmargsIndex == -1) {
            return null;
        }
        int vmIndex = (lines = lines.subList(vmargsIndex + 1, lines.size())).indexOf(VM);
        if (vmIndex != -1) {
            lines.subList(vmIndex, Math.min(vmIndex + 2, lines.size())).clear();
        }
        if (lines.isEmpty()) {
            return null;
        }
        this.removeUnsupportedVMArgs(lines);
        this.addUnresolvedVMArgs(lines);
        return Q7LaunchDelegateUtils.joinCommandArgs(lines);
    }

    private void removeUnsupportedVMArgs(List<String> lines) {
        String[] javaVersions = TargetPlatformHelper.getJavaVersions();
        if (TargetPlatformHelper.getMajorVersion(javaVersions) == 1 && TargetPlatformHelper.getMinorVersion(javaVersions) < 9 || TargetPlatformHelper.getMajorVersion(javaVersions) < 9) {
            Iterator<String> iterator = lines.iterator();
            while (iterator.hasNext()) {
                String line = iterator.next();
                if (!line.startsWith(VMARG_ADD_MODULES) && !line.startsWith(VMARG_PERMIT_ILLEGAL_ACCESS) && !line.startsWith(VMARG_ADD_OPENS)) continue;
                iterator.remove();
            }
        }
    }

    private void addUnresolvedVMArgs(List<String> lines) {
        int startIndex = lines.indexOf(VMARG_ADD_OPENS);
        if (startIndex != -1) {
            int i = startIndex;
            while (i < lines.size()) {
                if (lines.get(i).contains(VMARG_ALL_UNNAMED) && !lines.get(i - 1).startsWith(VMARG_ADD_OPENS)) {
                    lines.add(i, VMARG_ADD_OPENS);
                }
                ++i;
            }
        }
    }

    private static String[] getJavaVersions() {
        String javaVersion = System.getProperty("java.version");
        return javaVersion.split("\\.|-");
    }

    private static int getMajorVersion(String[] versions) {
        if (versions.length < 1) {
            return 0;
        }
        try {
            return Integer.valueOf(versions[0]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static int getMinorVersion(String[] versions) {
        if (versions.length < 2) {
            return 0;
        }
        try {
            return Integer.valueOf(versions[1]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public String getTemplateConfigLocation() {
        File iniFile = new File(this.getTargetPlatformProfilePath(), "configuration/config.ini");
        if (!iniFile.exists()) {
            return null;
        }
        return iniFile.getAbsolutePath();
    }

    @Override
    public OSArchitecture detectArchitecture(boolean preferCurrentVmArchitecture, StringBuilder detectMsg) {
        boolean isCurrentVm64 = System.getProperty("os.arch", "not null").contains("64");
        boolean has32 = false;
        boolean has64 = false;
        String launcher64 = null;
        String launcher32 = null;
        List<File> iniFiles = this.getAppIniFiles();
        Path targetPlatformProfilePath = new Path(this.getTargetPlatformProfilePath());
        HashSet<String> availableLaunchers = new HashSet<String>();
        String os = Platform.getOS();
        for (File file : iniFiles) {
            String launcherLibrary = this.readLauncherLibraryFromIniFile(file);
            if (launcherLibrary == null || !launcherLibrary.contains(os)) continue;
            String configPath = new Path(file.getAbsolutePath()).removeFirstSegments(targetPlatformProfilePath.segmentCount()).setDevice(null).toOSString();
            if (launcherLibrary.contains("x86_64")) {
                has64 = true;
                launcher64 = "launcher library\n\t\"" + launcherLibrary + "\" specified in config file: " + configPath;
                continue;
            }
            if (!launcherLibrary.contains("x86") && !launcherLibrary.contains("cocoa.macosx")) continue;
            has32 = true;
            launcher32 = "launcher library\n\t\"" + launcherLibrary + "\" specified in config file: " + configPath;
        }
        if (!has32 && !has64) {
            TargetBundle[] bundles;
            TargetBundle[] targetBundleArray = bundles = this.target.getAllBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                URI location;
                TargetBundle b = targetBundleArray[n2];
                BundleInfo info = b.getBundleInfo();
                String name = info.getSymbolicName();
                if (name != null && name.startsWith("org.eclipse.equinox.launcher") && (location = info.getLocation()) != null && location.getPath() != null) {
                    String pathString = new Path(info.getLocation().getPath()).removeFirstSegments(targetPlatformProfilePath.segmentCount()).toOSString();
                    if (name.contains("x86_64")) {
                        if (name.contains(os)) {
                            has64 = true;
                            launcher64 = "Equinox launcher\n\t- " + pathString;
                        } else {
                            availableLaunchers.add("\t- " + pathString);
                        }
                    } else if (name.contains("x86") || name.contains("cocoa.macosx")) {
                        if (name.contains(os)) {
                            has32 = true;
                            launcher32 = "Equinox launcher\n\t- " + pathString;
                        } else {
                            availableLaunchers.add("\t- " + pathString);
                        }
                    }
                }
                ++n2;
            }
        }
        if (has32 && !has64) {
            if (detectMsg != null) {
                detectMsg.append("32bit arch is selected because AUT uses " + launcher32);
            }
            return OSArchitecture.x86;
        }
        if (!has32 && has64) {
            if (detectMsg != null) {
                detectMsg.append("64bit arch is selected because AUT uses " + launcher64);
            }
            return OSArchitecture.x86_64;
        }
        if (preferCurrentVmArchitecture && has32 && has64) {
            OSArchitecture result;
            OSArchitecture oSArchitecture = result = isCurrentVm64 ? OSArchitecture.x86_64 : OSArchitecture.x86;
            if (detectMsg != null && result.equals((Object)OSArchitecture.x86)) {
                detectMsg.append("32bit arch is selected because\n- JVM is 32bit\n- AUT contains both launcher plugins\n\t-" + launcher32 + "\n\t-" + launcher64);
            }
            if (detectMsg != null && result.equals((Object)OSArchitecture.x86_64)) {
                detectMsg.append("64bit arch is selected because\n- JVM is 64bit\n- AUT contains both launcher plugins\n\t-" + launcher32 + "\n\t-" + launcher64);
            }
            return result;
        }
        if (detectMsg != null) {
            detectMsg.append("Cannot find appropriate Equinox launcher library.\n");
            if (availableLaunchers.size() > 0) {
                detectMsg.append("Available launchers:\n");
                for (String s : availableLaunchers) {
                    detectMsg.append(s).append("\n");
                }
            }
        }
        return OSArchitecture.Unknown;
    }

    private Map<String, String> getRunlevelsFromSimpleConfigurator() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.getTargetPlatformProfilePath() == null) {
            return result;
        }
        File infoFile = new File(this.getTargetPlatformProfilePath(), SC_BUNDLES_PATH);
        if (!infoFile.exists()) {
            return result;
        }
        FileInputStream input = null;
        try {
            input = new FileInputStream(infoFile);
            for (org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo bi : SimpleConfiguratorUtils.readConfiguration((InputStream)input, (URI)infoFile.toURI())) {
                String name = bi.getSymbolicName();
                if (name == null) continue;
                result.put(name, String.format("%d:%b", bi.getStartLevel(), bi.isMarkedAsStarted()));
            }
        }
        catch (Throwable e) {
            FileUtil.safeClose(input);
        }
        return result;
    }

    public Map<String, String> getRunlevelsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        String osgiBundles = this.getConfigIniProperty(OSGI_BUNDLES);
        if (osgiBundles == null) {
            return result;
        }
        if (osgiBundles.contains(SIMPLECONFIGURATOR)) {
            return this.getRunlevelsFromSimpleConfigurator();
        }
        StringTokenizer tokenizer = new StringTokenizer(osgiBundles, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int index = token.indexOf(64);
            String id = index != -1 ? token.substring(0, index) : token;
            String tk = token.substring(index + 1);
            if (tk.indexOf(":") == -1) {
                tk = String.valueOf(tk) + ":default";
            }
            result.put(id, tk);
        }
        return result;
    }

    @Override
    public String getRuntimeVersion() {
        if (this.target != null && this.target.isResolved()) {
            String version = "";
            org.osgi.framework.Version runtimeBundle = this.getBundleVersion("org.eclipse.rcptt.tesla.swt");
            if (runtimeBundle != null) {
                version = runtimeBundle.toString();
                if (runtimeBundle.getQualifier().equals("qualifier")) {
                    version = String.valueOf(version) + System.currentTimeMillis();
                }
            }
            return version;
        }
        return "unknown";
    }

    private org.osgi.framework.Version getBundleVersion(String name) {
        if (this.target != null && this.target.isResolved()) {
            ITargetLocation[] containers;
            ITargetLocation[] iTargetLocationArray = containers = this.target.getTargetLocations();
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation iBundleContainer = iTargetLocationArray[n2];
                TargetBundle[] bundles = iBundleContainer.getBundles();
                if (bundles != null) {
                    TargetBundle[] targetBundleArray = bundles;
                    int n3 = bundles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TargetBundle iResolvedBundle = targetBundleArray[n4];
                        BundleInfo info = iResolvedBundle.getBundleInfo();
                        if (Objects.equal((Object)info.getSymbolicName(), (Object)name)) {
                            return new org.osgi.framework.Version(info.getVersion());
                        }
                        ++n4;
                    }
                }
                if (iBundleContainer instanceof IUBundleContainer) {
                    IUBundleContainer ct = (IUBundleContainer)iBundleContainer;
                    try {
                        Field ids = IUBundleContainer.class.getDeclaredField("fIds");
                        Field versions = IUBundleContainer.class.getDeclaredField("fVersions");
                        ids.setAccessible(true);
                        versions.setAccessible(true);
                        String[] idsValue = (String[])ids.get(ct);
                        Version[] versionsValue = (Version[])versions.get(ct);
                        int i = 0;
                        while (i < idsValue.length) {
                            String n5 = idsValue[i];
                            if (n5 != null && n5.equals(name)) {
                                return new org.osgi.framework.Version(versionsValue[i].toString());
                            }
                            ++i;
                        }
                    }
                    catch (Throwable e) {
                        Q7ExtLaunchingPlugin.status("Failed to check runtime version", e);
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public String getEquinoxStartupPath(String packageName) {
        IPluginModelBase[] targetModels;
        IPluginModelBase[] iPluginModelBaseArray = targetModels = this.getTargetModels();
        int n = targetModels.length;
        int n2 = 0;
        while (n2 < n) {
            String location;
            IPluginModelBase plugin = iPluginModelBaseArray[n2];
            if (plugin.getPluginBase().getId().equals(packageName) && new File(location = plugin.getInstallLocation()).isFile()) {
                return location;
            }
            ++n2;
        }
        return null;
    }

    ProfileBundleContainer getInstanceContainer() {
        Q7Target.AutInstall install = this.getAutInstall();
        if (install == null) {
            return null;
        }
        return install.container;
    }

    public void setBundleContainers(ITargetLocation[] containers) {
        this.target.setTargetLocations(containers);
        this.initialize();
    }

    public String toString() {
        return String.valueOf(this.getName() == null ? "No name" : this.getName()) + " " + this.getTargetPlatformProfilePath();
    }

    @Override
    public Map<String, Version> getVersions() throws CoreException {
        if (!this.getStatus().isOK()) {
            throw new CoreException(this.getStatus());
        }
        return AUTInformation.getInformationMap(this.target);
    }

    public static OriginalOrderProperties processConfiguration(Q7Target.AutInstall autInstall) {
        URL baseConfigurationLocation = null;
        OriginalOrderProperties baseConfiguration = null;
        String location = null;
        if (baseConfigurationLocation == null) {
            try {
                baseConfigurationLocation = new URL(autInstall.getInstallLocationURL(), CONFIG_DIR);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((baseConfiguration = TargetPlatformHelper.loadConfiguration(baseConfigurationLocation)) != null) {
            location = baseConfiguration.getProperty(PROP_CONFIG_AREA);
        }
        OriginalOrderProperties configuration = baseConfiguration;
        URL configUrl = TargetPlatformHelper.getConfigurationLocation(location, autInstall.getInstallLocation());
        if (configuration == null || !configUrl.equals(baseConfigurationLocation)) {
            configuration = TargetPlatformHelper.loadConfiguration(configUrl);
        }
        if (configuration == null) {
            Q7ExtLaunchingPlugin.getDefault().info("File config.ini from folder \"" + configUrl + "\" was not read");
            return baseConfiguration;
        }
        String configurationArea = configUrl.getFile();
        int index = configurationArea.lastIndexOf("/");
        if (index == configurationArea.length() - 1) {
            configurationArea = configurationArea.substring(0, index);
            index = configurationArea.lastIndexOf("/");
        }
        autInstall.userArea = configurationArea.substring(0, index + 1);
        if ("false".equalsIgnoreCase(configuration.getProperty(PROP_CONFIG_CASCADED))) {
            configuration.remove(PROP_SHARED_CONFIG_AREA);
            return configuration;
        }
        URL sharedConfigURL = TargetPlatformHelper.buildLocation(configuration.getProperty(PROP_SHARED_CONFIG_AREA), null, "", autInstall.getInstallLocation().getAbsolutePath());
        if (sharedConfigURL == null) {
            try {
                sharedConfigURL = new URL(autInstall.getInstallLocationURL(), CONFIG_DIR);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (sharedConfigURL != null) {
            if (sharedConfigURL.equals(configUrl)) {
                return configuration;
            }
            OriginalOrderProperties sharedConfiguration = baseConfiguration;
            if (!sharedConfigURL.equals(baseConfigurationLocation)) {
                sharedConfiguration = TargetPlatformHelper.loadConfiguration(sharedConfigURL);
            }
            configuration.remove(PROP_SHARED_CONFIG_AREA);
            return TargetPlatformHelper.mergeProperties(sharedConfiguration, configuration);
        }
        return null;
    }

    private static OriginalOrderProperties loadConfiguration(URL url) {
        OriginalOrderProperties result = null;
        try {
            url = new URL(url, CONFIG_FILE);
        }
        catch (MalformedURLException e) {
            return result;
        }
        try {
            if (url != null) {
                result = OriginalOrderProperties.load(url);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return TargetPlatformHelper.substituteVars(result);
    }

    private static OriginalOrderProperties substituteVars(OriginalOrderProperties result) {
        if (result == null) {
            return null;
        }
        Enumeration<Object> eKeys = result.keys();
        while (eKeys.hasMoreElements()) {
            String value;
            Object key = eKeys.nextElement();
            if (!(key instanceof String) || (value = result.getProperty((String)key)) == null) continue;
            result.put(key, TargetPlatformHelper.substituteVars(value));
        }
        return result;
    }

    private static String substituteVars(String path) {
        StringBuffer buf = new StringBuffer(path.length());
        StringTokenizer st = new StringTokenizer(path, VARIABLE_DELIM_STRING, true);
        boolean varStarted = false;
        String var = null;
        while (st.hasMoreElements()) {
            String tok = st.nextToken();
            if (VARIABLE_DELIM_STRING.equals(tok)) {
                if (!varStarted) {
                    varStarted = true;
                    var = "";
                    continue;
                }
                String prop = null;
                if (var != null && var.length() > 0) {
                    prop = System.getProperty(var);
                }
                if (prop == null) {
                    try {
                        Method getenv = System.class.getMethod("getenv", String.class);
                        prop = (String)getenv.invoke(null, var);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (prop != null) {
                    buf.append(prop);
                } else {
                    buf.append('$');
                    buf.append(var == null ? "" : var);
                    buf.append('$');
                }
                varStarted = false;
                var = null;
                continue;
            }
            if (!varStarted) {
                buf.append(tok);
                continue;
            }
            var = tok;
        }
        if (var != null) {
            buf.append('$').append(var);
        }
        return buf.toString();
    }

    private static URL getConfigurationLocation(String configurationArea, File installLocation) {
        URL configurationLocation = TargetPlatformHelper.buildLocation(configurationArea, null, "", installLocation.getAbsolutePath());
        if (configurationLocation == null) {
            configurationLocation = TargetPlatformHelper.buildURL(TargetPlatformHelper.computeDefaultConfigurationLocation(installLocation), true, installLocation.getAbsolutePath());
        }
        return configurationLocation;
    }

    private static URL buildLocation(String location, URL defaultLocation, String userDefaultAppendage, String installArea) {
        URL result = null;
        if (location == null) {
            result = defaultLocation;
        } else {
            if (location.equalsIgnoreCase(NONE)) {
                return null;
            }
            if (location.equalsIgnoreCase(NO_DEFAULT)) {
                result = TargetPlatformHelper.buildURL(location, true, installArea);
            } else {
                if (location.startsWith(USER_HOME)) {
                    String base = TargetPlatformHelper.substituteVar(location, USER_HOME, PROP_USER_HOME);
                    location = new File(base, userDefaultAppendage).getAbsolutePath();
                } else if (location.startsWith(USER_DIR)) {
                    String base = TargetPlatformHelper.substituteVar(location, USER_DIR, PROP_USER_DIR);
                    location = new File(base, userDefaultAppendage).getAbsolutePath();
                }
                result = TargetPlatformHelper.buildURL(location, true, installArea);
            }
        }
        return result;
    }

    private static String substituteVar(String source, String var, String prop) {
        String value = System.getProperty(prop, "");
        return String.valueOf(value) + source.substring(var.length());
    }

    public static URL buildURL(String spec, boolean trailingSlash, String installArea) {
        if (spec == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            spec = spec.trim();
        }
        boolean isFile = spec.startsWith(FILE_SCHEME);
        try {
            if (isFile) {
                File toAdjust = new File(spec.substring(5));
                if ((toAdjust = TargetPlatformHelper.resolveFile(toAdjust, installArea)).isDirectory()) {
                    return TargetPlatformHelper.adjustTrailingSlash(toAdjust.toURI().toURL(), trailingSlash);
                }
                return toAdjust.toURI().toURL();
            }
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            if (isFile) {
                return null;
            }
            try {
                File toAdjust = new File(spec);
                if (toAdjust.isDirectory()) {
                    return TargetPlatformHelper.adjustTrailingSlash(toAdjust.toURI().toURL(), trailingSlash);
                }
                return toAdjust.toURI().toURL();
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    private static File resolveFile(File toAdjust, String installArea) {
        if (!toAdjust.isAbsolute() && installArea != null) {
            if (installArea.startsWith(FILE_SCHEME)) {
                toAdjust = new File(installArea.substring(5), toAdjust.getPath());
            } else if (new File(installArea).exists()) {
                toAdjust = new File(installArea, toAdjust.getPath());
            }
        }
        return toAdjust;
    }

    private static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        String file = url.getFile();
        if (trailingSlash == file.endsWith("/")) {
            return url;
        }
        file = trailingSlash ? String.valueOf(file) + "/" : file.substring(0, file.length() - 1);
        return new URL(url.getProtocol(), url.getHost(), file);
    }

    private static String computeDefaultConfigurationLocation(File installLocation) {
        String configurationLocation = null;
        configurationLocation = TargetPlatformHelper.canWrite(installLocation) ? installLocation.getAbsolutePath() : TargetPlatformHelper.computeDefaultUserAreaLocation(installLocation);
        return String.valueOf(configurationLocation) + File.separator + CONFIG_DIR;
    }

    private static boolean canWrite(File installDir) {
        if (!installDir.canWrite()) {
            return false;
        }
        if (!installDir.isDirectory()) {
            return false;
        }
        File fileTest = null;
        try {
            try {
                fileTest = File.createTempFile("writableArea", ".dll", installDir);
            }
            catch (IOException e) {
                if (fileTest != null) {
                    fileTest.delete();
                }
                return false;
            }
        }
        finally {
            if (fileTest != null) {
                fileTest.delete();
            }
        }
        return true;
    }

    private static String computeDefaultUserAreaLocation(File installDir) {
        String installDirHash = TargetPlatformHelper.getInstallDirHash(installDir);
        String appName = ".eclipse";
        File eclipseProduct = new File(installDir, PRODUCT_SITE_MARKER);
        if (eclipseProduct.exists()) {
            Properties props = new Properties();
            try {
                String appVersion;
                props.load(new FileInputStream(eclipseProduct));
                String appId = props.getProperty("id");
                if (appId == null || appId.trim().length() == 0) {
                    appId = ECLIPSE;
                }
                if ((appVersion = props.getProperty(PRODUCT_SITE_VERSION)) == null || appVersion.trim().length() == 0) {
                    appVersion = "";
                }
                appName = String.valueOf(appName) + File.separator + appId + "_" + appVersion + "_" + installDirHash;
            }
            catch (IOException e) {
                appName = String.valueOf(appName) + File.separator + installDirHash;
            }
        } else {
            appName = String.valueOf(appName) + File.separator + installDirHash;
        }
        appName = String.valueOf(appName) + '_' + TargetPlatformHelper.OS_WS_ARCHToString();
        String userHome = System.getProperty(PROP_USER_HOME);
        return new File(userHome, appName).getAbsolutePath();
    }

    private static String OS_WS_ARCHToString() {
        return String.valueOf(TargetPlatformHelper.getOS()) + '_' + TargetPlatformHelper.getWS() + '_' + TargetPlatformHelper.getArch();
    }

    private static String getWS() {
        String osgiWs = System.getProperty(PROP_WS);
        if (osgiWs != null) {
            return osgiWs;
        }
        String osName = TargetPlatformHelper.getOS();
        if (osName.equals("win32")) {
            return "win32";
        }
        if (osName.equals("linux")) {
            return "gtk";
        }
        if (osName.equals("macosx")) {
            return "cocoa";
        }
        if (osName.equals("hpux")) {
            return "gtk";
        }
        if (osName.equals("aix")) {
            return "gtk";
        }
        if (osName.equals("solaris")) {
            return "gtk";
        }
        if (osName.equals("qnx")) {
            return "photon";
        }
        return "unknown";
    }

    private static String getOS() {
        String osgiOs = System.getProperty(PROP_OS);
        if (osgiOs != null) {
            return osgiOs;
        }
        String osName = System.getProperties().getProperty("os.name");
        if (osName.regionMatches(true, 0, "win32", 0, 3)) {
            return "win32";
        }
        if (osName.equalsIgnoreCase("SunOS")) {
            return "solaris";
        }
        if (osName.equalsIgnoreCase("Linux")) {
            return "linux";
        }
        if (osName.equalsIgnoreCase("QNX")) {
            return "qnx";
        }
        if (osName.equalsIgnoreCase("AIX")) {
            return "aix";
        }
        if (osName.equalsIgnoreCase("HP-UX")) {
            return "hpux";
        }
        if (osName.equalsIgnoreCase("OS/400")) {
            return "os/400";
        }
        if (osName.equalsIgnoreCase("OS/390")) {
            return "os/390";
        }
        if (osName.equalsIgnoreCase("z/OS")) {
            return "z/os";
        }
        if (osName.regionMatches(true, 0, "Mac OS", 0, "Mac OS".length())) {
            return "macosx";
        }
        return "unknown";
    }

    private static String getArch() {
        String osgiArch = System.getProperty(PROP_ARCH);
        if (osgiArch != null) {
            return osgiArch;
        }
        String name = System.getProperties().getProperty("os.arch");
        if (name.equalsIgnoreCase(INTERNAL_ARCH_I386)) {
            return "x86";
        }
        if (name.equalsIgnoreCase("amd64")) {
            return "x86_64";
        }
        return name;
    }

    private static String getInstallDirHash(File installDir) {
        int hashCode;
        try {
            hashCode = installDir.getCanonicalPath().hashCode();
        }
        catch (IOException ioe) {
            hashCode = installDir.getAbsolutePath().hashCode();
        }
        if (hashCode < 0) {
            hashCode = -hashCode;
        }
        String installDirHash = String.valueOf(hashCode);
        return installDirHash;
    }

    private static OriginalOrderProperties mergeProperties(OriginalOrderProperties source, OriginalOrderProperties userConfiguration) {
        if (userConfiguration != null) {
            source.setBeginAdd(true);
            source.putAll((Map<?, ?>)userConfiguration);
        }
        return source;
    }

    private static void debug(String message) {
        if (DEBUG) {
            Q7ExtLaunchingPlugin.getDefault().info(message);
        }
    }
}

