/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.StringBufferToStringBuilderFixCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.text.edits.TextEditGroup;

public class StringConcatToTextBlockFixCore
extends CompilationUnitRewriteOperationsFixCore {
    private static final String JAVA_STRING = "java.lang.String";

    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit) {
        if (!JavaModelUtil.is15OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        StringConcatFinder finder = new StringConcatFinder(operations, true);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new StringBufferToStringBuilderFixCore(FixMessages.StringConcatToTextBlockFix_convert_msg, compilationUnit, ops);
    }

    public static StringConcatToTextBlockFixCore createStringConcatToTextBlockFix(ASTNode exp) {
        CompilationUnit root = (CompilationUnit)exp.getRoot();
        if (!JavaModelUtil.is15OrHigher(root.getJavaElement().getJavaProject())) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        StringConcatFinder finder = new StringConcatFinder(operations, true);
        exp.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        return new StringConcatToTextBlockFixCore(FixMessages.StringConcatToTextBlockFix_convert_msg, root, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{(CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation)operations.get(0)});
    }

    protected StringConcatToTextBlockFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static class ChangeStringConcatToTextBlock
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final InfixExpression fInfix;
        private final String fIndent;

        public ChangeStringConcatToTextBlock(InfixExpression infix) {
            this.fInfix = infix;
            this.fIndent = "\t";
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.StringConcatToTextBlockCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            StringBuilder buf = new StringBuilder();
            buf.append("\"\"\"\n");
            StringLiteral left = (StringLiteral)this.fInfix.getLeftOperand();
            this.formTextBlockString(buf, left, false);
            StringLiteral right = (StringLiteral)this.fInfix.getRightOperand();
            this.formTextBlockString(buf, right, false);
            List extraOperands = this.fInfix.extendedOperands();
            boolean hasNewLine = true;
            for (Expression extraOperand : extraOperands) {
                hasNewLine = this.formTextBlockString(buf, (StringLiteral)extraOperand, extraOperand == extraOperands.get(extraOperands.size() - 1));
            }
            if (hasNewLine) {
                buf.append(this.fIndent);
            }
            buf.append("\"\"\"");
            TextBlock textBlock = (TextBlock)rewrite.createStringPlaceholder(buf.toString(), 102);
            rewrite.replace((ASTNode)this.fInfix, (ASTNode)textBlock, group);
        }

        private boolean formTextBlockString(StringBuilder buf, StringLiteral literal, boolean lastLine) {
            String modifiedTextLine = literal.getLiteralValue();
            boolean hasNewLine = false;
            if (!(modifiedTextLine = modifiedTextLine.replaceAll("\"\"\"", "\\\\\"\"\"")).isEmpty()) {
                if (modifiedTextLine.endsWith("\n")) {
                    hasNewLine = true;
                    modifiedTextLine = modifiedTextLine.substring(0, modifiedTextLine.length() - 1);
                    int count = 0;
                    int i = modifiedTextLine.length() - 1;
                    while (i > 0) {
                        if (modifiedTextLine.charAt(i) != ' ') break;
                        ++count;
                        --i;
                    }
                    if (count > 0) {
                        modifiedTextLine = modifiedTextLine.substring(0, modifiedTextLine.length() - count);
                        i = 0;
                        while (i < count) {
                            modifiedTextLine = String.valueOf(modifiedTextLine) + "\\s";
                            ++i;
                        }
                    }
                }
                modifiedTextLine = modifiedTextLine.replaceAll("\n", "\\\\n");
                buf.append(this.fIndent).append(modifiedTextLine);
                if (hasNewLine) {
                    buf.append("\n");
                } else if (!lastLine) {
                    buf.append("\\\n");
                }
            }
            return hasNewLine;
        }
    }

    public static final class StringConcatFinder
    extends ASTVisitor {
        private final List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fOperations;
        private final boolean fAllConcats;

        public StringConcatFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations, boolean allConcats) {
            super(true);
            this.fOperations = operations;
            this.fAllConcats = allConcats;
        }

        private boolean isStringType(Type type) {
            if (type instanceof ArrayType) {
                return false;
            }
            ITypeBinding typeBinding = type.resolveBinding();
            return typeBinding != null && typeBinding.getQualifiedName().equals(StringConcatToTextBlockFixCore.JAVA_STRING);
        }

        public boolean visit(VariableDeclarationStatement visited) {
            Type type = visited.getType();
            return this.isStringType(type);
        }

        public boolean visit(FieldDeclaration visited) {
            Type type = visited.getType();
            return this.isStringType(type);
        }

        public boolean visit(Assignment visited) {
            ITypeBinding typeBinding = visited.resolveTypeBinding();
            return typeBinding.getQualifiedName().equals(StringConcatToTextBlockFixCore.JAVA_STRING);
        }

        public boolean visit(InfixExpression visited) {
            if (visited.getOperator() != InfixExpression.Operator.PLUS || visited.extendedOperands().isEmpty()) {
                return false;
            }
            ITypeBinding typeBinding = visited.resolveTypeBinding();
            if (typeBinding == null || !typeBinding.getQualifiedName().equals(StringConcatToTextBlockFixCore.JAVA_STRING)) {
                return false;
            }
            Expression leftHand = visited.getLeftOperand();
            if (!(leftHand instanceof StringLiteral)) {
                return false;
            }
            StringLiteral leftLiteral = (StringLiteral)leftHand;
            String literal = leftLiteral.getLiteralValue();
            if (!(literal.isEmpty() || this.fAllConcats || literal.endsWith("\n"))) {
                return false;
            }
            Expression rightHand = visited.getRightOperand();
            if (!(rightHand instanceof StringLiteral)) {
                return false;
            }
            StringLiteral rightLiteral = (StringLiteral)leftHand;
            literal = rightLiteral.getLiteralValue();
            if (!(literal.isEmpty() || this.fAllConcats || literal.endsWith("\n"))) {
                return false;
            }
            List extendedOperands = visited.extendedOperands();
            if (extendedOperands.isEmpty()) {
                return false;
            }
            int i = 0;
            while (i < extendedOperands.size()) {
                StringLiteral stringLiteral;
                String string;
                Expression operand = (Expression)extendedOperands.get(i);
                if (!(operand instanceof StringLiteral) || (string = (stringLiteral = (StringLiteral)operand).getLiteralValue()).isEmpty() || !this.fAllConcats && !string.endsWith("\n") && i != extendedOperands.size() - 1) {
                    return false;
                }
                ++i;
            }
            this.fOperations.add(new ChangeStringConcatToTextBlock(visited));
            return false;
        }
    }
}

