/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.actions.Q7ElementLabelProvider;
import org.eclipse.rcptt.ui.refactoring.delete.DeleteQ7ElementProcessor;
import org.eclipse.rcptt.ui.refactoring.delete.Resources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DeleteQ7ElementInputPage
extends UserInputWizardPage {
    private final DeleteQ7ElementProcessor refactoringProcessor;
    private Button fDeleteContentsButton;
    private Button deleteReferencesButton;

    public DeleteQ7ElementInputPage(DeleteQ7ElementProcessor processor) {
        super("RenameResourceRefactoringInputPage");
        this.refactoringProcessor = processor;
    }

    public void createControl(Composite parent) {
        String message;
        this.initializeDialogUnits((Control)parent);
        Point defaultSpacing = LayoutConstants.getSpacing();
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).spacing(defaultSpacing.x * 2, defaultSpacing.y).applyTo(composite);
        composite.setFont(parent.getFont());
        Display display = parent.getDisplay();
        Image image = new Image((Device)display, display.getSystemImage(4), 0);
        Label imageLabel = new Label(composite, 0);
        imageLabel.setBackground(image.getBackground());
        imageLabel.setImage(image);
        GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)imageLabel);
        IResource[] resources = this.refactoringProcessor.getResources();
        if (resources.length == 1) {
            IResource resource = resources[0];
            message = Messages.bind((String)Messages.DeleteContextInputPage_OneElementMsg, (Object)this.getName(resource));
        } else {
            message = Messages.bind((String)Messages.DeleteContextInputPage_ManyElementsMsg, (Object)resources.length);
        }
        this.createLabel(composite, message);
        this.createSupportArea(composite);
        this.setControl((Control)composite);
    }

    private String getName(IResource resource) {
        try {
            if (resource instanceof IFile) {
                IQ7NamedElement element = (IQ7NamedElement)RcpttCore.create((IResource)resource);
                if (element != null) {
                    return element.getElementName();
                }
                return resource.getName();
            }
        }
        catch (Exception e) {
            Q7UIPlugin.log(e);
        }
        return resource.getName();
    }

    private void createSupportArea(Composite composite) {
        int count;
        Composite supportArea = new Composite(composite, 0);
        supportArea.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Point defaultSpacing = LayoutConstants.getSpacing();
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = defaultSpacing.x * 2;
        gridLayout.verticalSpacing = defaultSpacing.y;
        supportArea.setLayout((Layout)gridLayout);
        if (this.containsOnlyProjects()) {
            this.fDeleteContentsButton = new Button(supportArea, 32);
            this.fDeleteContentsButton.setFont(composite.getFont());
            this.fDeleteContentsButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
            this.fDeleteContentsButton.setText(Messages.DeleteContextInputPage_DeleteContentCheckbox);
            this.fDeleteContentsButton.setFocus();
        }
        if ((count = this.refactoringProcessor.getReferencesCount()) > 0) {
            Composite deleteReferencesComposite = new Composite(supportArea, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)deleteReferencesComposite);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(deleteReferencesComposite);
            this.deleteReferencesButton = new Button(deleteReferencesComposite, 32);
            this.deleteReferencesButton.setFont(composite.getFont());
            this.deleteReferencesButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
            this.deleteReferencesButton.setText(Messages.DeleteContextInputPage_DeleteReferencesLabel);
            this.deleteReferencesButton.setSelection(this.refactoringProcessor.isDeleteReferences());
            this.deleteReferencesButton.setFocus();
            Hyperlink link = new Hyperlink(deleteReferencesComposite, 64);
            String message = Messages.bind((String)Messages.DeleteContextInputPage_SeeReferencesLink, (Object)count);
            link.setText(message);
            link.setUnderlined(true);
            link.setHref((Object)message.substring(0, message.length() - 2));
            link.setForeground(JFaceColors.getHyperlinkText((Display)link.getShell().getDisplay()));
            TreeViewer viewer = new TreeViewer(supportArea);
            Control control = viewer.getControl();
            GridDataFactory.fillDefaults().span(2, 1).hint(420, 150).grab(true, true).exclude(true).applyTo(control);
            viewer.setContentProvider((IContentProvider)new ReferencesContentProvider());
            viewer.setInput(new Object());
            viewer.setLabelProvider((IBaseLabelProvider)new Q7ElementLabelProvider());
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter((StructuredViewer)viewer){
                private final /* synthetic */ StructuredViewer val$viewer;
                {
                    this.val$viewer = structuredViewer;
                }

                public void linkActivated(HyperlinkEvent e) {
                    Control control = this.val$viewer.getControl();
                    ((GridData)control.getLayoutData()).exclude = false;
                    if (this.val$viewer instanceof TreeViewer) {
                        ((TreeViewer)this.val$viewer).expandAll();
                    }
                    control.getShell().pack();
                }
            });
        }
    }

    private void createLabel(Composite parent, String text) {
        Label label = new Label(parent, 64);
        label.setFont(parent.getFont());
        label.setText(text);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)gridData);
    }

    protected boolean performFinish() {
        this.initializeRefactoring();
        this.storeSettings();
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        this.initializeRefactoring();
        this.storeSettings();
        return super.getNextPage();
    }

    private void storeSettings() {
    }

    private void initializeRefactoring() {
        this.refactoringProcessor.setDeleteContents(this.fDeleteContentsButton == null ? false : this.fDeleteContentsButton.getSelection());
        this.refactoringProcessor.setDeleteReferences(this.deleteReferencesButton == null ? false : this.deleteReferencesButton.getSelection());
    }

    public boolean containsOnlyProjects() {
        return Resources.containsOnlyProjects(this.refactoringProcessor.getResourcesToDelete());
    }

    private final class ReferencesContentProvider
    implements ITreeContentProvider {
        private ReferencesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return DeleteQ7ElementInputPage.this.refactoringProcessor.getReferencedElements();
        }

        public Object[] getChildren(Object parentElement) {
            return DeleteQ7ElementInputPage.this.refactoringProcessor.getReferencingElements(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element) != null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

