/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.rcptt.tesla.internal.ui.player.viewers.Viewers;
import org.eclipse.rcptt.util.swt.TableTreeUtil;
import org.eclipse.rcptt.verifications.tree.Row;
import org.eclipse.rcptt.verifications.tree.TreeNode;
import org.eclipse.rcptt.verifications.tree.impl.TreeVerificationModeller;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class WidgetTreeNodeAdapter
implements TreeNode<Row> {
    private final Widget widget;

    public WidgetTreeNodeAdapter(Widget tree) {
        this.widget = tree;
    }

    public Collection<? extends TreeNode<Row>> getChildren() {
        return WidgetTreeNodeAdapter.convert(TableTreeUtil.getItems((Widget)this.widget), this);
    }

    private static List<TreeItemNodeAdapter> convert(Item[] items, TreeNode<Row> parent) {
        ArrayList<TreeItemNodeAdapter> rv = new ArrayList<TreeItemNodeAdapter>(items.length);
        Item[] itemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            rv.add(new TreeItemNodeAdapter(item));
            ++n2;
        }
        return rv;
    }

    public Row payload() {
        return null;
    }

    private static class TreeItemNodeAdapter
    implements TreeNode<Row> {
        private final Item widget;

        public TreeItemNodeAdapter(Item item) {
            if (item == null) {
                throw new NullPointerException();
            }
            this.widget = item;
        }

        public Collection<? extends TreeNode<Row>> getChildren() {
            if (this.widget instanceof TreeItem) {
                Viewers.expandTreeItem((TreeItem)((TreeItem)this.widget));
            }
            return WidgetTreeNodeAdapter.convert(TableTreeUtil.getItems((Widget)this.widget), (TreeNode<Row>)this);
        }

        public Row payload() {
            return TreeVerificationModeller.getRow(this.widget, TableTreeUtil.getColumnCount((Widget)this.widget), false);
        }
    }
}

