/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7Model;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.nature.RcpttNature;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.ModelInfo;
import org.eclipse.rcptt.internal.core.model.Openable;
import org.eclipse.rcptt.internal.core.model.OpenableElementInfo;
import org.eclipse.rcptt.internal.core.model.Q7Project;

public class Q7Model
extends Openable
implements IQ7Model {
    protected Q7Model() throws IllegalArgumentException {
        super(null);
    }

    @Override
    public IQ7Element.HandleType getElementType() {
        return IQ7Element.HandleType.Model;
    }

    @Override
    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public IQ7Project getProject(String name) {
        return new Q7Project(ResourcesPlugin.getWorkspace().getRoot().getProject(name), this);
    }

    public IQ7Project getProject(IResource resource) {
        switch (resource.getType()) {
            case 2: {
                return new Q7Project(((IFolder)resource).getProject(), this);
            }
            case 1: {
                return new Q7Project(((IFile)resource).getProject(), this);
            }
            case 4: {
                return new Q7Project((IProject)resource, this);
            }
        }
        throw new IllegalArgumentException("Invalid argument");
    }

    @Override
    public IQ7Project[] getProjects() throws ModelException {
        List<IQ7Element> list = this.getChildrenOfType(IQ7Element.HandleType.Project);
        return list.toArray(new IQ7Project[list.size()]);
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map<IQ7Element, Object> newElements, IResource underlyingResource) throws ModelException {
        IProject[] projects;
        ArrayList<IQ7Project> result = new ArrayList<IQ7Project>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            if (iProject.isAccessible() && iProject.isOpen()) {
                try {
                    if (RcpttNature.isRcpttProject(iProject)) {
                        result.add(this.getProject(iProject.getName()));
                    }
                }
                catch (CoreException e) {
                    RcpttPlugin.log(e);
                }
            }
            ++n2;
        }
        info.setChildren(result);
        return true;
    }

    @Override
    protected Object createElementInfo() {
        return new ModelInfo();
    }

    public static Object getTarget(IContainer container, IPath path, boolean checkResourceExistence) {
        IResource resource;
        if (path == null) {
            return null;
        }
        if (path.getDevice() == null && (resource = container.findMember(path)) != null) {
            if (!checkResourceExistence || resource.exists()) {
                return resource;
            }
            return null;
        }
        if (!path.isAbsolute()) {
            return null;
        }
        return null;
    }

    @Override
    public IPath getPath() {
        return Path.ROOT;
    }

    @Override
    public String getName() {
        return "";
    }

    public Object[] getForeignResources() throws ModelException {
        return ((ModelInfo)this.getElementInfo()).getForeignResources();
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Q7Model)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("Model");
        if (info == null) {
            buffer.append(" (not open)");
        }
    }
}

