/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.log.ui;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.commons.EObjectTable;
import org.eclipse.rcptt.ui.controls.IEmbeddedComposite;
import org.eclipse.rcptt.ui.controls.SectionWithToolbar;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.jface.providers.BooleanLabelProvider;
import org.eclipse.rcptt.ui.verification.BaseVerificationEditor;
import org.eclipse.rcptt.verifications.log.ErrorLogVerification;
import org.eclipse.rcptt.verifications.log.LogEntryPredicate;
import org.eclipse.rcptt.verifications.log.LogFactory;
import org.eclipse.rcptt.verifications.log.LogPackage;
import org.eclipse.rcptt.verifications.log.tools.ErrorLogUtil;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.IGotoMarker;

public class ErrorLogVerificationEditor
extends BaseVerificationEditor
implements IGotoMarker {
    private static final String TRANSFER_TYPE = "org.eclipse.rcptt.verifications.log.ui.ErrorLogVerificationEditor.LOG_ENTRY_PREDICATE_TRANSFER";
    private static final Transfer LOG_ENTRY_PREDICATE_TRANSFER = new LocalTransfer(){
        private final int ID = 1.registerType((String)"org.eclipse.rcptt.verifications.log.ui.ErrorLogVerificationEditor.LOG_ENTRY_PREDICATE_TRANSFER");

        protected int[] getTypeIds() {
            return new int[]{this.ID};
        }

        public String[] getTypeNames() {
            return new String[]{ErrorLogVerificationEditor.TRANSFER_TYPE};
        }
    };
    private static final ICellEditorValidator INTEGER_VALIDATOR = new ICellEditorValidator(){

        public String isValid(Object value) {
            String strValue = (String)value;
            if (Strings.isNullOrEmpty((String)strValue)) {
                return null;
            }
            strValue = strValue.replaceAll(" ", "");
            try {
                Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                return e.getLocalizedMessage();
            }
            return null;
        }
    };
    PredicateTable requiredTable;
    PredicateTable allowedTable;
    PredicateTable deniedTable;

    public ErrorLogVerification getVerification() {
        try {
            return (ErrorLogVerification)super.getElement().getNamedElement();
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return null;
        }
    }

    public Control create(Composite parent, FormToolkit toolkit, IWorkbenchSite site, EditorHeader header) {
        int style = 322;
        this.requiredTable = new PredicateTable((EStructuralFeature)LogPackage.Literals.ERROR_LOG_VERIFICATION__REQUIRED, "Require");
        new SectionWithToolbar((IEmbeddedComposite)this.requiredTable, style).create(parent, toolkit).setToolTipText("Every pattern should match at least one log entry for verification to succeed");
        this.allowedTable = new PredicateTable((EStructuralFeature)LogPackage.Literals.ERROR_LOG_VERIFICATION__ALLOWED, "Allow");
        new SectionWithToolbar((IEmbeddedComposite)this.allowedTable, style).create(parent, toolkit).setToolTipText("These patterns are not denied by next section");
        this.deniedTable = new PredicateTable((EStructuralFeature)LogPackage.Literals.ERROR_LOG_VERIFICATION__DENIED, "Deny");
        new SectionWithToolbar((IEmbeddedComposite)this.deniedTable, style).create(parent, toolkit).setToolTipText("A log entry matching any of these patterns causes verification to fail if it is not allowed by the previous section");
        return null;
    }

    PredicateTable tableByFeature(EReference feature) {
        assert (this.requiredTable != null);
        assert (this.allowedTable != null);
        assert (this.deniedTable != null);
        if (feature == LogPackage.Literals.ERROR_LOG_VERIFICATION__REQUIRED) {
            return this.requiredTable;
        }
        if (feature == LogPackage.Literals.ERROR_LOG_VERIFICATION__ALLOWED) {
            return this.allowedTable;
        }
        if (feature == LogPackage.Literals.ERROR_LOG_VERIFICATION__DENIED) {
            return this.deniedTable;
        }
        throw new IllegalArgumentException("Not a predicate reference");
    }

    public void setSelectionAtLine(int line) {
        LogEntryPredicate predicate = ErrorLogUtil.getPredicateByIndex((ErrorLogVerification)this.getVerification(), (int)line);
        if (predicate == null) {
            return;
        }
        EReference feature = (EReference)predicate.eContainingFeature();
        PredicateTable table = this.tableByFeature(feature);
        table.setSelection(new Object[]{predicate}, true);
        table.getControl().setFocus();
    }

    public void gotoMarker(IMarker marker) {
        try {
            Integer line = (Integer)marker.getAttribute("lineNumber");
            if (line != null) {
                this.setSelectionAtLine(line);
            }
        }
        catch (CoreException e) {
            RcpttPlugin.log((Throwable)e);
        }
    }

    public void dispose() {
        this.allowedTable.dispose();
        this.deniedTable.dispose();
        this.requiredTable.dispose();
        super.dispose();
    }

    class PredicateTable
    extends EObjectTable {
        private final String title;

        public PredicateTable(EStructuralFeature feature, String title) {
            super((EObject)ErrorLogVerificationEditor.this.getVerification(), feature);
            this.title = title;
        }

        public String getName() {
            return this.title;
        }

        protected int getStyle() {
            return super.getStyle() | 0x10000;
        }

        public Image getImage() {
            return null;
        }

        protected boolean allowDrag(IStructuredSelection selection) {
            return !selection.isEmpty();
        }

        protected void configureViewer(TableViewer viewer) {
            viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            viewer.getTable().setHeaderVisible(true);
            TableViewerColumn column = new TableViewerColumn(viewer, 0);
            column.getColumn().setText("Error");
            column.getColumn().setWidth(30);
            column.setLabelProvider((CellLabelProvider)new SeverityLabelProvider(4));
            column.setEditingSupport((EditingSupport)new SeverityEditingSupport((ColumnViewer)viewer, 4));
            column = new TableViewerColumn(viewer, 0);
            column.getColumn().setWidth(30);
            column.getColumn().setText("Warning");
            column.setLabelProvider((CellLabelProvider)new SeverityLabelProvider(2));
            column.setEditingSupport((EditingSupport)new SeverityEditingSupport((ColumnViewer)viewer, 2));
            column = new TableViewerColumn(viewer, 0);
            column.getColumn().setText("Information");
            column.getColumn().setWidth(30);
            column.setLabelProvider((CellLabelProvider)new SeverityLabelProvider(1));
            column.setEditingSupport((EditingSupport)new SeverityEditingSupport((ColumnViewer)viewer, 1));
            column = new TableViewerColumn(viewer, 0);
            column.getColumn().setText("Plugin Pattern");
            column.getColumn().setWidth(100);
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((LogEntryPredicate)element).getPluginPattern();
                }
            });
            column.setEditingSupport((EditingSupport)new StringEditingSupport(this, (ColumnViewer)viewer, LogPackage.Literals.LOG_ENTRY_PREDICATE__PLUGIN_PATTERN){

                @Override
                protected void setValue(Object element, Object value) {
                    super.setValue(element, Strings.nullToEmpty((String)((String)value)).replaceAll(" ", ""));
                }
            });
            column = new TableViewerColumn(viewer, 0);
            column.getColumn().setText("Message Pattern");
            column.getColumn().setWidth(300);
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((LogEntryPredicate)element).getMessagePattern();
                }
            });
            column.setEditingSupport((EditingSupport)new StringEditingSupport((ColumnViewer)viewer, LogPackage.Literals.LOG_ENTRY_PREDICATE__MESSAGE_PATTERN));
            column = new TableViewerColumn(viewer, 0);
            column.getColumn().setText("Plugin Code");
            column.getColumn().setWidth(50);
            column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    int code = ((LogEntryPredicate)element).getCode();
                    if (LogPackage.Literals.LOG_ENTRY_PREDICATE__CODE.getDefaultValue().equals(code)) {
                        return "";
                    }
                    return "" + code;
                }
            });
            column.setEditingSupport((EditingSupport)new IntegerEditingSupport((ColumnViewer)viewer, LogPackage.Literals.LOG_ENTRY_PREDICATE__CODE));
        }

        protected ILabelProvider createLabelProvider() {
            return null;
        }

        protected Object[] handleAdd() {
            LogEntryPredicate rv = LogFactory.eINSTANCE.createLogEntryPredicate();
            rv.setSeverityMask(7);
            rv.setMessagePattern(".*");
            rv.setPluginPattern(".*");
            return new Object[]{rv};
        }

        protected Class<?> getContentsType() {
            return LogEntryPredicate.class;
        }

        protected Transfer getContentTransfer() {
            return LOG_ENTRY_PREDICATE_TRANSFER;
        }

        protected IQ7Element.HandleType getAppropriateHandleType() {
            return null;
        }

        abstract class AttributeEditingSupport
        extends EditingSupport {
            protected final EAttribute property;

            public AttributeEditingSupport(ColumnViewer viewer, EAttribute property) {
                super(viewer);
                this.property = property;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        }

        class IntegerEditingSupport
        extends AttributeEditingSupport {
            public IntegerEditingSupport(ColumnViewer viewer, EAttribute property) {
                super(viewer, property);
            }

            protected CellEditor getCellEditor(Object element) {
                TextCellEditor rv = new TextCellEditor((Composite)this.getViewer().getControl());
                rv.setValidator(INTEGER_VALIDATOR);
                return rv;
            }

            protected Object getValue(Object element) {
                int rv = (Integer)((EObject)element).eGet((EStructuralFeature)this.property);
                if (this.property.getDefaultValue().equals(rv)) {
                    return "";
                }
                return String.valueOf(rv);
            }

            protected void setValue(Object element, Object value) {
                int code = (Integer)this.property.getDefaultValue();
                String strValue = Strings.nullToEmpty((String)((String)value)).replaceAll(" ", "");
                if (!Strings.isNullOrEmpty((String)strValue)) {
                    code = Integer.valueOf(strValue);
                }
                ((EObject)element).eSet((EStructuralFeature)this.property, (Object)code);
                this.getViewer().refresh(element);
            }
        }

        class SeverityEditingSupport
        extends EditingSupport {
            private final int mask;

            public SeverityEditingSupport(ColumnViewer viewer, int mask) {
                super(viewer);
                this.mask = mask;
            }

            protected CellEditor getCellEditor(Object element) {
                return new CheckboxCellEditor((Composite)PredicateTable.this.viewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                if ((((LogEntryPredicate)element).getSeverityMask() & this.mask) != 0) {
                    return true;
                }
                return false;
            }

            protected void setValue(Object element, Object value) {
                LogEntryPredicate entry = (LogEntryPredicate)element;
                if (((Boolean)value).booleanValue()) {
                    entry.setSeverityMask(entry.getSeverityMask() | this.mask);
                } else {
                    entry.setSeverityMask(entry.getSeverityMask() & ~this.mask);
                }
                PredicateTable.this.viewer.refresh(element);
            }
        }

        class SeverityLabelProvider
        extends BooleanLabelProvider {
            private final int mask;

            public SeverityLabelProvider(int mask) {
                this.mask = mask;
            }

            public boolean isChecked(Object element) {
                return (((LogEntryPredicate)element).getSeverityMask() & this.mask) != 0;
            }
        }

        class StringEditingSupport
        extends AttributeEditingSupport {
            public StringEditingSupport(ColumnViewer viewer, EAttribute property) {
                super(viewer, property);
            }

            protected Object getValue(Object element) {
                return Objects.firstNonNull((Object)((EObject)element).eGet((EStructuralFeature)this.property), (Object)"");
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)this.getViewer().getControl());
            }

            protected void setValue(Object element, Object value) {
                ((EObject)element).eSet((EStructuralFeature)this.property, value);
                this.getViewer().refresh(element);
            }
        }
    }
}

