/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.resources;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.utils.AttributedValue;
import org.eclipse.packagedrone.utils.Headers;
import org.eclipse.packagedrone.web.BundleResourceNotFoundRequestHandler;
import org.eclipse.packagedrone.web.RequestHandler;
import org.eclipse.packagedrone.web.RequestHandlerFactory;
import org.eclipse.packagedrone.web.ResourceRequestHandler;
import org.eclipse.packagedrone.web.resources.ResourceHandlerProvider;
import org.eclipse.packagedrone.web.util.Requests;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTracker
implements RequestHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceTracker.class);
    private final BundleTracker<ResourceHandlerProvider> tracker;
    private final BundleTrackerCustomizer<ResourceHandlerProvider> customizer = new BundleTrackerCustomizer<ResourceHandlerProvider>(){

        public void removedBundle(Bundle bundle, BundleEvent event, ResourceHandlerProvider object) {
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, ResourceHandlerProvider object) {
        }

        public ResourceHandlerProvider addingBundle(Bundle bundle, BundleEvent event) {
            LinkedList<ResourceHandlerProvider> entries = new LinkedList<ResourceHandlerProvider>();
            String resources = (String)bundle.getHeaders().get("Web-Static-Resources");
            List result = Headers.parseList((String)resources);
            if (result != null) {
                for (AttributedValue av : result) {
                    String prefix = av.getValue();
                    String target = (String)av.getAttributes().get("target");
                    if (target == null) {
                        target = prefix;
                    }
                    entries.add(new ResourceEntry(bundle, prefix, target));
                }
            }
            if (entries.isEmpty()) {
                return null;
            }
            if (entries.size() == 1) {
                return (ResourceHandlerProvider)entries.get(0);
            }
            return new CompositeResourceEntry(entries);
        }
    };

    public ResourceTracker(BundleContext context) {
        this.tracker = new BundleTracker(context, 34, this.customizer);
        this.tracker.open();
    }

    @Override
    public void close() {
        this.tracker.close();
    }

    @Override
    public RequestHandler handleRequest(HttpServletRequest request, HttpServletResponse response) {
        String method = request.getMethod().toUpperCase();
        if (!method.equals("GET") && !method.equals("HEAD")) {
            return null;
        }
        String requestPath = Requests.getRequestPath(request);
        for (ResourceHandlerProvider entry : this.tracker.getTracked().values()) {
            RequestHandler handler = entry.findHandler(requestPath);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    private static class CompositeResourceEntry
    implements ResourceHandlerProvider {
        private final List<ResourceHandlerProvider> providers;

        public CompositeResourceEntry(List<ResourceHandlerProvider> providers) {
            this.providers = providers;
        }

        @Override
        public RequestHandler findHandler(String requestPath) {
            for (ResourceHandlerProvider provider : this.providers) {
                RequestHandler resource = provider.findHandler(requestPath);
                if (resource == null) continue;
                return resource;
            }
            return null;
        }
    }

    private static class ResourceEntry
    implements ResourceHandlerProvider {
        private final Bundle bundle;
        private final String prefix;
        private final String target;

        public ResourceEntry(Bundle bundle, String prefix, String target) {
            this.bundle = bundle;
            this.prefix = prefix;
            this.target = target;
        }

        @Override
        public RequestHandler findHandler(String requestPath) {
            if (!requestPath.startsWith(this.target)) {
                return null;
            }
            String entryName = String.valueOf(this.prefix) + requestPath.substring(this.target.length());
            URL entry = this.bundle.getEntry(entryName);
            if (entry == null) {
                logger.info("Resource '{}' could not be found in bundle {} ({})", new Object[]{requestPath, this.bundle.getBundleId(), this.bundle.getSymbolicName()});
                return new BundleResourceNotFoundRequestHandler(this.bundle, entryName);
            }
            return new ResourceRequestHandler(entry, this.bundle.getLastModified());
        }
    }
}

