/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.form;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.eclipse.packagedrone.utils.converter.ConverterManager;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.controller.binding.BindTarget;
import org.eclipse.packagedrone.web.controller.binding.Binder;
import org.eclipse.packagedrone.web.controller.binding.Binding;
import org.eclipse.packagedrone.web.controller.binding.BindingManager;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.MapBinder;
import org.eclipse.packagedrone.web.controller.binding.ModelAndViewAwareBinding;
import org.eclipse.packagedrone.web.controller.form.FormData;
import org.eclipse.packagedrone.web.controller.validator.CompositeValidator;
import org.eclipse.packagedrone.web.controller.validator.ControllerValidatorProcessor;
import org.eclipse.packagedrone.web.controller.validator.FormDataValidator;
import org.eclipse.packagedrone.web.controller.validator.JavaValidator;
import org.eclipse.packagedrone.web.controller.validator.Validator;

public class FormDataBinder
implements Binder {
    private final HttpServletRequest request;
    private final Object controller;

    public FormDataBinder(HttpServletRequest request) {
        this.request = request;
        this.controller = null;
    }

    public FormDataBinder(HttpServletRequest request, Object controller) {
        this.request = request;
        this.controller = controller;
    }

    @Override
    public Binding performBind(BindTarget target, ConverterManager converter, BindingManager bindingManager) {
        ConstructionResult cr;
        FormData fd = target.getAnnotation(FormData.class);
        if (fd == null) {
            return null;
        }
        Class<?> clazz = target.getType();
        final String name = fd.value();
        try {
            cr = this.construct(clazz, bindingManager, target);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to create model object of type %s", clazz.getName()), e);
        }
        if (name != null) {
            bindingManager.getResult().addChild(name, cr.bindingResult);
        }
        return new ModelAndViewAwareBinding(cr.object, cr.bindingResult){

            @Override
            public void postProcessModelAndView(ModelAndView mav) {
                if (name != null && !name.isEmpty()) {
                    mav.put(name, this.getValue());
                }
            }
        };
    }

    private ConstructionResult construct(Class<?> clazz, BindingManager bindingManager, BindTarget target) throws Exception {
        Object o = clazz.newInstance();
        HashMap<String, Object> objects = new HashMap<String, Object>();
        Enumeration en = this.request.getParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String[] value = this.request.getParameterValues(key);
            if (value.length == 1) {
                objects.put(key, value[0]);
                continue;
            }
            objects.put(key, value);
        }
        BindingManager bm = new BindingManager();
        if (target.isAnnotationPresent(Valid.class)) {
            LinkedList<Validator> validators = new LinkedList<Validator>();
            validators.add(new JavaValidator());
            validators.add(new FormDataValidator());
            if (this.controller != null) {
                validators.add(new ControllerValidatorProcessor(this.controller));
            }
            bm.setValidator(new CompositeValidator(validators));
        }
        bm.addBinder(new MapBinder(objects));
        bm.bindProperties(o);
        return new ConstructionResult(o, bm.getResult());
    }

    static class ConstructionResult {
        Object object;
        BindingResult bindingResult;

        public ConstructionResult(Object object, BindingResult bindingResult) {
            this.object = object;
            this.bindingResult = bindingResult;
        }
    }
}

