/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.signing.pgp.internal.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.eclipse.packagedrone.repo.signing.pgp.PgpHelper;
import org.eclipse.packagedrone.repo.signing.pgp.internal.AbstractSecretKeySigningService;

public class PgpSigningService
extends AbstractSecretKeySigningService {
    public static PgpSigningService create(File file, String keyId, String passphrase) throws IOException, PGPException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream is = new FileInputStream(file);){
            return new PgpSigningService(is, keyId, passphrase);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static PGPSecretKey loadKey(InputStream keyring, String keyId) throws IOException, PGPException {
        PGPSecretKey secretKey = PgpHelper.loadSecretKey(keyring, keyId);
        if (secretKey == null) {
            throw new IllegalStateException(String.format("Signing key '%08X' could not be found", keyId));
        }
        return secretKey;
    }

    public PgpSigningService(InputStream keyring, String keyId, String passphrase) throws IOException, PGPException {
        super(PgpSigningService.loadKey(keyring, keyId), passphrase);
    }
}

