/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.rpm.yum.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.adapter.rpm.Constants;
import org.eclipse.packagedrone.repo.adapter.rpm.RpmInformation;
import org.eclipse.packagedrone.repo.adapter.rpm.yum.RepositoryCreator;
import org.eclipse.packagedrone.repo.aspect.aggregate.AggregationContext;
import org.eclipse.packagedrone.repo.aspect.aggregate.ChannelAggregator;
import org.eclipse.packagedrone.repo.aspect.common.spool.ChannelCacheTarget;
import org.eclipse.packagedrone.repo.aspect.common.spool.SpoolOutTarget;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.signing.SigningService;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class YumChannelAggregator
implements ChannelAggregator {
    private static final MetaKey KEY_SIGNING_ID = new MetaKey("yum", "signingServiceId");
    private static final MetaKey KEY_SHA1 = new MetaKey("hasher", "sha1");
    private final BundleContext context = FrameworkUtil.getBundle(YumChannelAggregator.class).getBundleContext();

    public Map<String, String> aggregateMetaData(AggregationContext context) throws Exception {
        String signingServiceId = (String)context.getChannelMetaData().get(KEY_SIGNING_ID);
        ServiceReference ssref = null;
        SigningService signingService = null;
        if (signingServiceId != null && !signingServiceId.isEmpty()) {
            Collection services = this.context.getServiceReferences(SigningService.class, String.format("(%s=%s)", "service.pid", signingServiceId));
            if (services == null || services.isEmpty()) {
                throw new IllegalStateException(String.format("Unable to find configured signing service: %s", signingServiceId));
            }
            ssref = (ServiceReference)services.iterator().next();
            signingService = (SigningService)this.context.getService(ssref);
        }
        try {
            RepositoryCreator creator = new RepositoryCreator((SpoolOutTarget)new ChannelCacheTarget(context), signingService);
            HashMap<String, String> result = new HashMap<String, String>();
            creator.process((IOConsumer<RepositoryCreator.Context>)((IOConsumer)repoContext -> {
                for (ArtifactInformation art : context.getArtifacts()) {
                    RpmInformation info = RpmInformation.fromJson((String)art.getMetaData().get(Constants.KEY_INFO));
                    if (info == null) continue;
                    String sha1 = (String)art.getMetaData().get(KEY_SHA1);
                    repoContext.addPackage(sha1, art, info);
                }
            }));
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        finally {
            if (signingService != null && ssref != null) {
                this.context.ungetService(ssref);
            }
        }
    }
}

