/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.system.web;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.repo.manage.system.web.BundleInformation;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

@Controller
@ViewResolver(value="/WEB-INF/views/info/framework/%s.jsp")
@RequestMapping(value={"/system/info/framework"})
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"ADMIN"})
public class FrameworkInformationController
implements InterfaceExtender {
    private final BundleContext context = FrameworkUtil.getBundle(FrameworkInformationController.class).getBundleContext();

    @RequestMapping
    public ModelAndView view() {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("vendor", System.getProperty("org.osgi.framework.vendor"));
        model.put("version", System.getProperty("org.osgi.framework.version"));
        Bundle sysBundle = this.context.getBundle(0L);
        if (sysBundle != null) {
            model.put("sysSymbolicName", sysBundle.getSymbolicName());
            model.put("sysName", (String)sysBundle.getHeaders(null).get("Bundle-Name"));
        }
        return new ModelAndView("index", model);
    }

    @RequestMapping(value={"/bundles"})
    public ModelAndView bundles() {
        HashMap model = new HashMap();
        Bundle[] bundles = this.context.getBundles();
        Arrays.sort(bundles, Comparator.comparing(Bundle::getSymbolicName));
        model.put("bundles", Arrays.stream(bundles).map(BundleInformation::new).collect(Collectors.toList()));
        return new ModelAndView("bundles", model);
    }

    @RequestMapping(value={"/bundles/{id}/start"}, method={RequestMethod.POST})
    public ModelAndView startBundle(@PathVariable(value="id") long bundleId) throws BundleException {
        Bundle bundle = this.context.getBundle(bundleId);
        if (bundle != null) {
            bundle.start();
        }
        return new ModelAndView("redirect:/system/info/framework/bundles");
    }

    @RequestMapping(value={"/bundles/{id}/stop"}, method={RequestMethod.POST})
    public ModelAndView stopBundle(@PathVariable(value="id") long bundleId) throws BundleException {
        Bundle bundle = this.context.getBundle(bundleId);
        if (bundle != null) {
            bundle.stop();
        }
        return new ModelAndView("redirect:/system/info/framework/bundles");
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (request.isUserInRole("ADMIN")) {
            result.add(new MenuEntry("System", Integer.MAX_VALUE, "OSGi Framework", 1000, LinkTarget.createFromController(FrameworkInformationController.class, (String)"view"), Modifier.DEFAULT, "cog"));
        }
        return result;
    }
}

