/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.packagedrone.utils.Locks;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class FactoryTracker<S, T> {
    private final ServiceTrackerCustomizer<S, Entry<T>> customizer = new ServiceTrackerCustomizer<S, Entry<T>>(){

        public void removedService(ServiceReference<S> reference, Entry<T> service) {
            Entry entry = FactoryTracker.this.removeService(reference);
            if (entry != null) {
                FactoryTracker.this.context.ungetService(reference);
            }
        }

        public void modifiedService(ServiceReference<S> reference, Entry<T> service) {
        }

        public Entry<T> addingService(ServiceReference<S> reference) {
            if (reference == null) {
                return null;
            }
            Entry entry = FactoryTracker.this.makeEntry(reference);
            if (entry != null) {
                FactoryTracker.this.addEntry(entry);
            }
            return entry;
        }
    };
    private final BundleContext context;
    private final Map<String, List<Entry<T>>> entries = new HashMap<String, List<Entry<T>>>();
    private final Map<ServiceReference<?>, Entry<T>> tracked = new HashMap();
    private final ServiceTracker<S, Entry<T>> tracker;
    private final Lock readLock;
    private final Lock writeLock;

    protected abstract String getFactoryId(ServiceReference<S> var1);

    protected abstract T mapService(ServiceReference<S> var1, S var2);

    public FactoryTracker(BundleContext context, Class<S> serviceClass) {
        this.context = context;
        this.tracker = new ServiceTracker(context, serviceClass, this.customizer);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public void open() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Locks.Locked l = Locks.lock(this.writeLock);){
            this.tracker.open();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void close() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Locks.Locked l = Locks.lock(this.writeLock);){
            this.tracker.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Entry<T> makeEntry(ServiceReference<S> reference) {
        String id = this.getFactoryId(reference);
        if (id == null) {
            return null;
        }
        Object service = this.context.getService(reference);
        if (service == null) {
            return null;
        }
        return new Entry<T>(id, this.mapService(reference, service), reference);
    }

    private void addEntry(Entry<T> entry) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Locks.Locked l = Locks.lock(this.writeLock);){
            List<Entry<T>> list = this.entries.get(entry.getId());
            if (list == null) {
                list = new ArrayList<Entry<T>>(1);
                this.entries.put(entry.getId(), list);
            }
            this.tracked.put(entry.getReference(), entry);
            list.add(entry);
            Collections.sort(list);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Entry<T> removeService(ServiceReference<S> ref) {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Locks.Locked l = Locks.lock(this.writeLock);
            try {
                Entry<T> entry = this.tracked.remove(ref);
                if (entry == null) {
                    return null;
                }
                List<Entry<T>> list = this.entries.get(entry.getId());
                if (list == null) {
                    return null;
                }
                list.remove(entry);
                if (list.isEmpty()) {
                    this.entries.remove(entry.getId());
                }
                return entry;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (l == null) return null;
                l.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public void consume(String factoryId, Consumer<T> consumer) {
        this.consume(factoryId, consumer, () -> new IllegalStateException(String.format("Missing factory: %s", factoryId)));
    }

    public <X extends Exception> void consume(String factoryId, Consumer<T> consumer, Supplier<X> ifNotFound) throws X {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Locks.Locked l = Locks.lock(this.readLock);){
            List<Entry<T>> entries = this.entries.get(factoryId);
            if (entries == null || entries.isEmpty()) {
                throw (Exception)ifNotFound.get();
            }
            consumer.accept(entries.get(0).getService());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void consumeOptionally(String factoryId, Consumer<Optional<T>> consumer) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Locks.Locked l = Locks.lock(this.readLock);){
            List<Entry<T>> entries = this.entries.get(factoryId);
            Optional<Entry> entry = entries != null && !entries.isEmpty() ? Optional.ofNullable(entries.get(0)) : Optional.empty();
            consumer.accept(entry.map(Entry::getService));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void consumeAll(Consumer<Stream<T>> consumer) {
        this.consumeEntries(stream -> consumer.accept(stream.map(Entry::getService)));
    }

    public void consumeEntries(Consumer<Stream<Entry<T>>> consumer) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Locks.Locked l = Locks.lock(this.readLock);){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (Stream stream = this.entries.values().stream().flatMap(list -> {
                Optional first = list.stream().findFirst();
                return first.map(e -> Stream.of(e)).orElseGet(Stream::empty);
            });){
                consumer.accept(stream);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static String getString(ServiceReference<?> ref, String key) {
        Object value = ref.getProperty(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public static class Entry<T>
    implements Comparable<Entry<T>> {
        private final String id;
        private final T service;
        private final ServiceReference<?> reference;

        public Entry(String id, T service, ServiceReference<?> reference) {
            this.id = id;
            this.service = service;
            this.reference = reference;
        }

        public String getId() {
            return this.id;
        }

        public T getService() {
            return this.service;
        }

        public ServiceReference<?> getReference() {
            return this.reference;
        }

        @Override
        public int compareTo(Entry<T> o) {
            return this.reference.compareTo(o.reference);
        }
    }
}

