/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.common.internal.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.packagedrone.web.common.table.TableColumnProvider;
import org.eclipse.packagedrone.web.common.table.TableDescriptor;
import org.eclipse.packagedrone.web.common.table.TableExtender;
import org.eclipse.packagedrone.web.common.table.TableExtension;
import org.eclipse.packagedrone.web.common.table.TableExtensionManager;

public abstract class AbstractTableExtensionManager
implements TableExtensionManager {
    protected abstract void access(Consumer<Collection<TableExtender>> var1);

    @Override
    public @NonNull TableExtension createExtensions(@NonNull HttpServletRequest request, @NonNull TableDescriptor descriptor) {
        ArrayList providers = new ArrayList();
        this.access(extenders -> {
            for (TableExtender extender : extenders) {
                extender.getColumns(request, descriptor, providers::add);
            }
        });
        return new TableExtensionImpl(descriptor, providers);
    }

    private final class TableExtensionImpl
    implements TableExtension {
        private final @NonNull TableDescriptor descriptor;
        private final @NonNull List<TableColumnProvider> providers;

        private TableExtensionImpl(@NonNull TableDescriptor descriptor, List<TableColumnProvider> providers) {
            Collections.sort(providers, Comparator.comparing(provider -> provider.getColumn().getPriority()));
            this.descriptor = descriptor;
            this.providers = Collections.unmodifiableList(providers);
        }

        @Override
        public @NonNull TableDescriptor geTableDescriptor() {
            return this.descriptor;
        }

        @Override
        public Stream<TableColumnProvider> streamProviders(int fromPriority, int toPriority) {
            Stream<TableColumnProvider> s = this.providers.stream();
            if (fromPriority != Integer.MIN_VALUE || toPriority != Integer.MAX_VALUE) {
                s = s.filter(p -> {
                    int prio = p.getColumn().getPriority();
                    return prio >= fromPriority && prio < toPriority;
                });
            }
            return s;
        }
    }
}

