/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.web.tags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.packagedrone.repo.Severity;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;

public class Functions {
    public static String channel(ChannelInformation channel) {
        if (channel == null) {
            return null;
        }
        return channel.makeTitle();
    }

    public static List<ArtifactInformation> nameSorted(Collection<ArtifactInformation> artifacts) {
        if (artifacts == null) {
            return null;
        }
        ArrayList<ArtifactInformation> result = new ArrayList<ArtifactInformation>(artifacts);
        Collections.sort(result, ArtifactInformation.NAME_COMPARATOR);
        return result;
    }

    public static String severity(Severity severity) {
        return Functions.severityWithDefault(severity, "default");
    }

    public static String severityWithDefault(Severity severity, String defaultValue) {
        if (severity == null) {
            return defaultValue;
        }
        switch (severity) {
            case INFO: {
                return "info";
            }
            case WARNING: {
                return "warning";
            }
            case ERROR: {
                return "danger";
            }
        }
        return defaultValue;
    }
}

