/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.concurrent;

import java.lang.management.ManagementFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.scada.utils.concurrent.ExecutorServiceExporterMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceExporterImpl
implements ExecutorServiceExporterMXBean {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorServiceExporterImpl.class);
    private final MBeanServer mbs;
    private ObjectName name;
    private final ExecutorService executorService;
    private boolean didRegister;

    public ExecutorServiceExporterImpl(ExecutorService executorService, String key) {
        this.executorService = executorService;
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            this.name = new ObjectName("org.eclipse.scada.utils.concurrent", "executorService", key);
            this.mbs.registerMBean(this, this.name);
            this.didRegister = true;
        }
        catch (Exception e) {
            logger.warn("Failed to export", (Throwable)e);
        }
    }

    public void dispose() {
        logger.trace("Disposing...");
        if (this.didRegister) {
            try {
                this.mbs.unregisterMBean(this.name);
                this.didRegister = false;
            }
            catch (Exception e) {
                logger.warn("Failed to unregister: " + this.name, (Throwable)e);
            }
        }
    }

    @Override
    public Integer getActiveCount() {
        if (this.executorService instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executorService).getActiveCount();
        }
        return null;
    }

    @Override
    public Long getCompletedTaskCount() {
        if (this.executorService instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executorService).getCompletedTaskCount();
        }
        return null;
    }

    @Override
    public Integer getCorePoolSize() {
        if (this.executorService instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executorService).getCorePoolSize();
        }
        return null;
    }

    @Override
    public Integer getLargestPoolSize() {
        if (this.executorService instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executorService).getLargestPoolSize();
        }
        return null;
    }

    @Override
    public Integer getMaximumPoolSize() {
        if (this.executorService instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executorService).getMaximumPoolSize();
        }
        return null;
    }

    @Override
    public Integer getPoolSize() {
        if (this.executorService instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executorService).getPoolSize();
        }
        return null;
    }

    @Override
    public Long getTaskCount() {
        if (this.executorService instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executorService).getTaskCount();
        }
        return null;
    }

    @Override
    public Integer getQueueSize() {
        if (this.executorService instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executorService).getQueue().size();
        }
        return null;
    }

    @Override
    public String getStatusString() {
        return this.executorService.toString();
    }
}

