/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.web.description;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;

@Controller
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@ViewResolver(value="/WEB-INF/views/%s.jsp")
public class DescriptionController
implements InterfaceExtender {
    private static final MetaKey KEY_DESCRIPTION = new MetaKey("sys", "description");
    private ChannelService service;

    public void setService(ChannelService service) {
        this.service = service;
    }

    @RequestMapping(value={"/channel/{channelId}/description"})
    public ModelAndView channelDescription(@PathVariable(value="channelId") String channelId) {
        try {
            return (ModelAndView)this.service.accessCall(ChannelService.By.id((String)channelId), ReadableChannel.class, channel -> {
                HashMap<String, ChannelInformation> model = new HashMap<String, ChannelInformation>(1);
                model.put("channel", channel.getInformation());
                return new ModelAndView("description", model);
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            return CommonController.createNotFound((String)"channel", (String)channelId);
        }
    }

    @RequestMapping(value={"/channel/{channelId}/description"}, method={RequestMethod.POST})
    public ModelAndView channelDescriptionPost(@PathVariable(value="channelId") String channelId, @RequestParameter(value="data") String data) {
        try {
            return (ModelAndView)this.service.accessCall(ChannelService.By.id((String)channelId), ModifiableChannel.class, channel -> {
                channel.applyMetaData(Collections.singletonMap(KEY_DESCRIPTION, data));
                HashMap<String, ChannelInformation> model = new HashMap<String, ChannelInformation>(1);
                model.put("channel", channel.getInformation());
                return new ModelAndView("description", model);
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            return CommonController.createNotFound((String)"channel", (String)channelId);
        }
    }

    public List<MenuEntry> getViews(HttpServletRequest request, Object object) {
        if (!(object instanceof ChannelId)) {
            return null;
        }
        ChannelId channel = (ChannelId)object;
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        HashMap<String, String> model = new HashMap<String, String>(1);
        model.put("channelId", channel.getId());
        result.add(new MenuEntry("Help", 100000, "Description", 1000, LinkTarget.createFromController(DescriptionController.class, (String)"channelDescription").expand(model), Modifier.DEFAULT, "comment"));
        return result;
    }
}

