/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.web.artifact;

import com.google.common.net.UrlEscapers;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.web.channel.ChannelController;
import org.eclipse.packagedrone.repo.channel.web.internal.Activator;
import org.eclipse.packagedrone.repo.web.utils.Channels;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.sec.web.filter.SecurityFilter;
import org.eclipse.packagedrone.utils.Holder;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;

@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class ArtifactController
implements InterfaceExtender {
    private ChannelService service;

    public void setService(ChannelService service) {
        this.service = service;
    }

    @RequestMapping(value={"/channel/{channelId}/artifacts/{artifactId}/generate"}, method={RequestMethod.GET})
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView generate(@PathVariable(value="channelId") String channelId, @PathVariable(value="artifactId") String artifactId) {
        return Channels.withArtifact((ChannelService)this.service, (String)channelId, (String)artifactId, ModifiableChannel.class, (channel, artifact) -> {
            channel.getContext().regenerate(artifact.getId());
            return new ModelAndView("redirect:/channel/" + UrlEscapers.urlPathSegmentEscaper().escape(artifact.getChannelId().getId()) + "/view");
        });
    }

    public List<MenuEntry> getActions(HttpServletRequest request, Object object) {
        if (object instanceof ArtifactInformation) {
            ChannelArtifactInformation ai = (ChannelArtifactInformation)object;
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            HashMap<String, String> model = new HashMap<String, String>(1);
            model.put("channelId", ai.getChannelId().getId());
            model.put("artifactId", ai.getId());
            result.add(new MenuEntry("Channel", 100, LinkTarget.createFromController(ChannelController.class, (String)"view").expand(model), Modifier.DEFAULT, null));
            if (request.isUserInRole("MANAGER") && ai.is("generator")) {
                Holder holder = new Holder();
                Activator.getGeneratorProcessor().process(ai.getVirtualizerAspectId(), generator -> {
                    holder.value = generator.getEditTarget(ai);
                });
                if (holder.value != null) {
                    result.add(new MenuEntry("Edit", 400, (LinkTarget)holder.value, Modifier.DEFAULT, null));
                }
            }
            if (SecurityFilter.isLoggedIn((HttpServletRequest)request) && ai.is("generator")) {
                result.add(new MenuEntry("Regenerate", 300, LinkTarget.createFromController(ArtifactController.class, (String)"generate").expand(model), Modifier.SUCCESS, "refresh"));
            }
            result.add(new MenuEntry("Download", Integer.MAX_VALUE, LinkTarget.createFromController(ChannelController.class, (String)"getArtifact").expand(model), Modifier.LINK, "download"));
            result.add(new MenuEntry("View", Integer.MAX_VALUE, LinkTarget.createFromController(ChannelController.class, (String)"dumpArtifact").expand(model), Modifier.LINK, null));
            return result;
        }
        return null;
    }
}

