/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.web;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.util.AbstractChannelInterfaceExtender;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;

public class P2InterfaceExtender
extends AbstractChannelInterfaceExtender {
    public static final String P2_METADATA_ASPECT_ID = "p2.metadata";

    protected List<MenuEntry> getChannelActions(HttpServletRequest request, ChannelInformation channel) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        this.repoActions(request, channel, result);
        this.metaDataActions(request, channel, result);
        return result;
    }

    private void metaDataActions(HttpServletRequest request, ChannelInformation channel, List<MenuEntry> result) {
        if (!channel.hasAspect(P2_METADATA_ASPECT_ID)) {
            return;
        }
        if (request.isUserInRole("MANAGER")) {
            result.add(new MenuEntry("Edit", Integer.MAX_VALUE, "P2 Meta Data Generator", 10000, new LinkTarget(String.format("/p2.metadata/%s/edit", P2InterfaceExtender.escapePathSegment((String)channel.getId()))), Modifier.DEFAULT, null, false, 0L));
        }
    }

    private void repoActions(HttpServletRequest request, ChannelInformation channel, List<MenuEntry> result) {
        if (!channel.hasAspect("p2.repo")) {
            return;
        }
        result.add(new MenuEntry("P2", 9000, "P2 (by ID)", 10000, new LinkTarget("/p2/" + P2InterfaceExtender.escapePathSegment((String)channel.getId())), Modifier.LINK, null, false, 0L));
        for (String name : channel.getNames()) {
            result.add(new MenuEntry("P2", 9000, String.format("P2 (name: %s)", name), 11001, new LinkTarget("/p2/" + P2InterfaceExtender.escapePathSegment((String)name)), Modifier.LINK, null, false, 0L));
        }
        if (request.isUserInRole("MANAGER")) {
            result.add(new MenuEntry("Edit", Integer.MAX_VALUE, "P2 Repository Information", 10000, new LinkTarget(String.format("/p2.repo/%s/edit", P2InterfaceExtender.escapePathSegment((String)channel.getId()))), Modifier.DEFAULT, null, false, 0L));
        }
    }

    protected List<MenuEntry> getChannelViews(HttpServletRequest request, ChannelInformation channel) {
        HashMap<String, String> model = new HashMap<String, String>(1);
        model.put("channelId", channel.getId());
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (channel.hasAspect("p2.repo")) {
            result.add(new MenuEntry("P2", 5000, "Repository", 1000, new LinkTarget("/p2.repo/{channelId}/info").expand(model), Modifier.INFO, null, false, 0L));
        }
        if (channel.hasAspect(P2_METADATA_ASPECT_ID)) {
            result.add(new MenuEntry("P2", 5000, "Meta Data Generation", 500, new LinkTarget("/p2.metadata/{channelId}/info").expand(model), Modifier.INFO, null, false, 0L));
        }
        return result;
    }
}

