import loader = require('./loader');
import dumper = require('./dumper');
import Mark = require("./mark");
export declare class YAMLException {
    message: string;
    reason: string;
    name: string;
    mark: Mark;
    constructor(reason: string, mark?: Mark);
    toString(compact?: boolean): any;
}
export declare enum Kind {
    SCALAR = 0,
    MAPPING = 1,
    MAP = 2,
    SEQ = 3,
    ANCHOR_REF = 4,
    INCLUDE_REF = 5,
}
export declare type Error = YAMLException;
export interface YAMLDocument {
    startPosition: number;
    endPosition: number;
    errors: YAMLException[];
}
export interface YAMLNode extends YAMLDocument {
    startPosition: number;
    endPosition: number;
    kind: Kind;
    anchorId?: string;
    valueObject?: any;
    parent: YAMLNode;
    errors: YAMLException[];
    value?: any;
    key?: any;
    mappings?: any;
}
export interface YAMLAnchorReference extends YAMLNode {
    referencesAnchor: string;
    value: YAMLNode;
}
export interface YAMLScalar extends YAMLNode {
    value: string;
    doubleQuoted?: boolean;
    plainScalar?: boolean;
}
export interface YAMLMapping extends YAMLNode {
    key: YAMLScalar;
    value: YAMLNode;
}
export interface YAMLSequence extends YAMLNode {
    items: YAMLNode[];
}
export interface YamlMap extends YAMLNode {
    mappings: YAMLMapping[];
}
export declare function newMapping(key: YAMLScalar, value: YAMLNode): YAMLMapping;
export declare function newAnchorRef(key: string, start: number, end: number, value: YAMLNode): YAMLAnchorReference;
export declare function newScalar(v?: string): YAMLScalar;
export declare function newItems(): YAMLSequence;
export declare function newSeq(): YAMLSequence;
export declare function newMap(mappings?: YAMLMapping[]): YamlMap;
export declare var load: typeof loader.load;
export declare var loadAll: typeof loader.loadAll;
export declare var safeLoad: typeof loader.safeLoad;
export declare var dump: typeof dumper.dump;
export declare var safeDump: typeof dumper.safeDump;
