/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.BundleDescriptionImpl;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.BundleSpecificationImpl;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.ExportPackageDescriptionImpl;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.GenericDescriptionImpl;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.GenericSpecificationImpl;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.HostSpecificationImpl;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.ImportPackageSpecificationImpl;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.StateMsg;
import org.eclipse.equinox.internal.p2.publisher.eclipse.bundledescription.Tokenizer;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class BundleDescriptionBuilder {
    private static final String BUNDLE_REQUIREDEXECUTIONENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    private static final String PACKAGE_SPECIFICATION_VERSION = "specification-version";
    private static final String[] DEFINED_EXPORT_PACKAGE_DIRECTIVES = new String[]{"uses", "include", "exclude", "x-friends", "x-internal", "mandatory"};
    private static final String[] DEFINED_IMPORT_PACKAGE_DIRECTIVES = new String[]{"resolution"};
    private static final String[] DEFINED_PACKAGE_MATCHING_ATTRS = new String[]{"bundle-symbolic-name", "bundle-version", "specification-version", "version"};
    private static final String[] DEFINED_REQUIRE_BUNDLE_DIRECTIVES = new String[]{"resolution", "visibility"};
    private static final String[] DEFINED_FRAGMENT_HOST_DIRECTIVES = new String[]{"extension"};
    private static final String[] DEFINED_BSN_DIRECTIVES = new String[]{"singleton", "fragment-attachment", "mandatory"};
    private static final String[] DEFINED_BSN_MATCHING_ATTRS = new String[]{"bundle-version", "optional", "reprovide"};
    private static final String[] DEFINED_REQUIRE_CAPABILITY_DIRECTIVES = new String[]{"resolution", "filter", "cardinality"};
    private static final String[] DEFINED_REQUIRE_CAPABILITY_ATTRS = new String[0];
    private static final String[] DEFINED_OSGI_VALIDATE_HEADERS = new String[]{"Import-Package", "DynamicImport-Package", "Export-Package", "Fragment-Host", "Bundle-SymbolicName", "Require-Bundle"};
    private static final String GENERIC_REQUIRE = "Eclipse-GenericRequire";
    private static final String GENERIC_CAPABILITY = "Eclipse-GenericCapability";
    private static final String ATTR_TYPE_STRING = "string";
    private static final String ATTR_TYPE_VERSION = "version";
    private static final String ATTR_TYPE_URI = "uri";
    private static final String ATTR_TYPE_LONG = "long";
    private static final String ATTR_TYPE_DOUBLE = "double";
    private static final String ATTR_TYPE_SET = "set";
    private static final String ATTR_TYPE_LIST = "List";
    private static final String OPTIONAL_ATTR = "optional";
    private static final String MULTIPLE_ATTR = "multiple";
    private static final String TRUE = "true";
    static final String NAME = "org.eclipse.osgi";
    @Deprecated
    public static final String PROVIDE_PACKAGE = "Provide-Package";
    static final String ECLIPSE_PLATFORMFILTER = "Eclipse-PlatformFilter";
    static final String Eclipse_JREBUNDLE = "Eclipse-JREBundle";
    static final String INTERNAL_DIRECTIVE = "x-internal";
    static final String FRIENDS_DIRECTIVE = "x-friends";
    static final String REPROVIDE_ATTRIBUTE = "reprovide";
    static final String OPTIONAL_ATTRIBUTE = "optional";
    static final String OSGI_EE_NAMESPACE = "osgi.ee";

    public static BundleDescriptionImpl createBundleDescription(Dictionary<String, String> manifest, String location) throws BundleException {
        int manifestVersion;
        BundleDescriptionImpl result;
        block11: {
            ManifestElement[] symbolicNameElements;
            String symbolicNameHeader;
            result = new BundleDescriptionImpl();
            String manifestVersionHeader = manifest.get("Bundle-ManifestVersion");
            boolean jreBundle = TRUE.equals(manifest.get(Eclipse_JREBUNDLE));
            manifestVersion = 1;
            if (manifestVersionHeader != null) {
                manifestVersion = Integer.parseInt(manifestVersionHeader);
            }
            if (manifestVersion >= 2) {
                BundleDescriptionBuilder.validateHeaders(manifest, jreBundle);
            }
            if ((symbolicNameHeader = manifest.get("Bundle-SymbolicName")) != null && (symbolicNameElements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameHeader)).length > 0) {
                ManifestElement bsnElement = symbolicNameElements[0];
                result.setSymbolicName(bsnElement.getValue());
                String singleton = bsnElement.getDirective("singleton");
                if (singleton == null) {
                    singleton = bsnElement.getAttribute("singleton");
                }
                result.setStateBit(2, TRUE.equals(singleton));
                String fragmentAttachment = bsnElement.getDirective("fragment-attachment");
                if (fragmentAttachment != null) {
                    if (fragmentAttachment.equals("resolve-time")) {
                        result.setStateBit(64, true);
                        result.setStateBit(128, false);
                    } else if (fragmentAttachment.equals("never")) {
                        result.setStateBit(64, false);
                        result.setStateBit(128, false);
                    }
                }
                result.setDirective("mandatory", ManifestElement.getArrayFromList((String)bsnElement.getDirective("mandatory")));
                result.setAttributes(BundleDescriptionBuilder.getAttributes(bsnElement, DEFINED_BSN_MATCHING_ATTRS));
                result.setArbitraryDirectives(BundleDescriptionBuilder.getDirectives(bsnElement, DEFINED_BSN_DIRECTIVES));
            }
            String version = manifest.get("Bundle-Version");
            try {
                result.setVersion(version != null ? Version.parseVersion((String)version) : Version.emptyVersion);
            }
            catch (IllegalArgumentException ex) {
                if (manifestVersion < 2) break block11;
                String message = NLS.bind((String)StateMsg.MANIFEST_INVALID_HEADER_EXCEPTION, (Object)"Bundle-Version", (Object)version);
                throw new BundleException(message + " : " + ex.getMessage(), 3, (Throwable)ex);
            }
        }
        result.setLocation(location);
        result.setPlatformFilter(manifest.get(ECLIPSE_PLATFORMFILTER));
        String[] brees = ManifestElement.getArrayFromList((String)manifest.get(BUNDLE_REQUIREDEXECUTIONENVIRONMENT));
        result.setExecutionEnvironments(brees);
        ManifestElement[] host = ManifestElement.parseHeader((String)"Fragment-Host", (String)manifest.get("Fragment-Host"));
        if (host != null) {
            result.setHost(BundleDescriptionBuilder.createHostSpecification(host[0]));
        }
        ManifestElement[] exports = ManifestElement.parseHeader((String)"Export-Package", (String)manifest.get("Export-Package"));
        ManifestElement[] provides = ManifestElement.parseHeader((String)PROVIDE_PACKAGE, (String)manifest.get(PROVIDE_PACKAGE));
        boolean strict = false;
        ArrayList<String> providedExports = new ArrayList<String>(provides == null ? 0 : provides.length);
        result.setExportPackages(BundleDescriptionBuilder.createExportPackages(exports, provides, providedExports, strict));
        ManifestElement[] imports = ManifestElement.parseHeader((String)"Import-Package", (String)manifest.get("Import-Package"));
        ManifestElement[] dynamicImports = ManifestElement.parseHeader((String)"DynamicImport-Package", (String)manifest.get("DynamicImport-Package"));
        result.setImportPackages(BundleDescriptionBuilder.createImportPackages(result.getExportPackages(), providedExports, imports, dynamicImports, manifestVersion));
        ManifestElement[] requires = ManifestElement.parseHeader((String)"Require-Bundle", (String)manifest.get("Require-Bundle"));
        result.setRequiredBundles(BundleDescriptionBuilder.createRequiredBundles(requires));
        String[][] genericAliases = BundleDescriptionBuilder.getGenericAliases();
        ManifestElement[] genericRequires = BundleDescriptionBuilder.getGenericRequires(manifest, genericAliases);
        ManifestElement[] osgiRequires = ManifestElement.parseHeader((String)"Require-Capability", (String)manifest.get("Require-Capability"));
        result.setGenericRequires(BundleDescriptionBuilder.createGenericRequires(genericRequires, osgiRequires, brees));
        ManifestElement[] genericCapabilities = BundleDescriptionBuilder.getGenericCapabilities(manifest, genericAliases);
        ManifestElement[] osgiCapabilities = ManifestElement.parseHeader((String)"Provide-Capability", (String)manifest.get("Provide-Capability"));
        result.setGenericCapabilities(BundleDescriptionBuilder.createGenericCapabilities(genericCapabilities, osgiCapabilities, result));
        result.setBundleId(1L);
        return result;
    }

    private static ManifestElement[] getGenericRequires(Dictionary<String, String> manifest, String[][] genericAliases) throws BundleException {
        ManifestElement[] genericRequires = ManifestElement.parseHeader((String)GENERIC_REQUIRE, (String)manifest.get(GENERIC_REQUIRE));
        ArrayList<ManifestElement> aliasList = null;
        if (genericAliases.length > 0) {
            aliasList = new ArrayList<ManifestElement>(genericRequires == null ? 0 : genericRequires.length);
            String[][] stringArray = genericAliases;
            int n = genericAliases.length;
            int n2 = 0;
            while (n2 < n) {
                String[] genericAlias = stringArray[n2];
                ManifestElement[] aliasReqs = ManifestElement.parseHeader((String)genericAlias[1], (String)manifest.get(genericAlias[1]));
                if (aliasReqs != null) {
                    ManifestElement[] manifestElementArray = aliasReqs;
                    int n3 = aliasReqs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ManifestElement aliasReq = manifestElementArray[n4];
                        StringBuilder strBuf = new StringBuilder();
                        strBuf.append(aliasReq.getValue()).append(':').append(genericAlias[2]);
                        String filter = aliasReq.getAttribute("selection-filter");
                        if (filter != null) {
                            strBuf.append("; ").append("selection-filter").append(filter).append("=\"").append(filter).append("\"");
                        }
                        ManifestElement[] withType = ManifestElement.parseHeader((String)genericAlias[1], (String)strBuf.toString());
                        aliasList.add(withType[0]);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        if (aliasList == null || aliasList.size() == 0) {
            return genericRequires;
        }
        if (genericRequires != null) {
            Collections.addAll(aliasList, genericRequires);
        }
        return aliasList.toArray(new ManifestElement[aliasList.size()]);
    }

    private static ManifestElement[] getGenericCapabilities(Dictionary<String, String> manifest, String[][] genericAliases) throws BundleException {
        ManifestElement[] genericCapabilities = ManifestElement.parseHeader((String)GENERIC_CAPABILITY, (String)manifest.get(GENERIC_CAPABILITY));
        ArrayList<ManifestElement> aliasList = null;
        if (genericAliases.length > 0) {
            aliasList = new ArrayList<ManifestElement>(genericCapabilities == null ? 0 : genericCapabilities.length);
            String[][] stringArray = genericAliases;
            int n = genericAliases.length;
            int n2 = 0;
            while (n2 < n) {
                String[] genericAlias = stringArray[n2];
                ManifestElement[] aliasCapabilities = ManifestElement.parseHeader((String)genericAlias[0], (String)manifest.get(genericAlias[0]));
                if (aliasCapabilities != null) {
                    ManifestElement[] manifestElementArray = aliasCapabilities;
                    int n3 = aliasCapabilities.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ManifestElement aliasCapability = manifestElementArray[n4];
                        StringBuilder strBuf = new StringBuilder();
                        strBuf.append(aliasCapability.getValue()).append(':').append(genericAlias[2]);
                        Enumeration keys = aliasCapability.getKeys();
                        while (keys != null && keys.hasMoreElements()) {
                            String key = (String)keys.nextElement();
                            strBuf.append("; ").append(key).append("=\"").append(aliasCapability.getAttribute(key)).append("\"");
                        }
                        ManifestElement[] withTypes = ManifestElement.parseHeader((String)genericAlias[0], (String)strBuf.toString());
                        aliasList.add(withTypes[0]);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        if (aliasList == null || aliasList.size() == 0) {
            return genericCapabilities;
        }
        if (genericCapabilities != null) {
            Collections.addAll(aliasList, genericCapabilities);
        }
        return aliasList.toArray(new ManifestElement[aliasList.size()]);
    }

    private static String[][] getGenericAliases() {
        return new String[0][0];
    }

    private static void validateHeaders(Dictionary<String, String> manifest, boolean jreBundle) throws BundleException {
        String[] stringArray = DEFINED_OSGI_VALIDATE_HEADERS;
        int n = DEFINED_OSGI_VALIDATE_HEADERS.length;
        int n2 = 0;
        while (n2 < n) {
            String definedOSGiValidateHeader = stringArray[n2];
            String header = manifest.get(definedOSGiValidateHeader);
            if (header != null) {
                ManifestElement[] elements = ManifestElement.parseHeader((String)definedOSGiValidateHeader, (String)header);
                BundleDescriptionBuilder.checkForDuplicateDirectivesAttributes(definedOSGiValidateHeader, elements);
                if (definedOSGiValidateHeader == "Import-Package") {
                    BundleDescriptionBuilder.checkImportExportSyntax(definedOSGiValidateHeader, elements, false, false, jreBundle);
                }
                if (definedOSGiValidateHeader == "DynamicImport-Package") {
                    BundleDescriptionBuilder.checkImportExportSyntax(definedOSGiValidateHeader, elements, false, true, jreBundle);
                }
                if (definedOSGiValidateHeader == "Export-Package") {
                    BundleDescriptionBuilder.checkImportExportSyntax(definedOSGiValidateHeader, elements, true, false, jreBundle);
                }
                if (definedOSGiValidateHeader == "Fragment-Host") {
                    BundleDescriptionBuilder.checkExtensionBundle(definedOSGiValidateHeader, elements);
                }
            } else if (definedOSGiValidateHeader == "Bundle-SymbolicName") {
                throw new BundleException(NLS.bind((String)StateMsg.HEADER_REQUIRED, (Object)"Bundle-SymbolicName"), 3);
            }
            ++n2;
        }
    }

    private static BundleSpecification[] createRequiredBundles(ManifestElement[] specs) {
        if (specs == null) {
            return null;
        }
        BundleSpecification[] result = new BundleSpecification[specs.length];
        int i = 0;
        while (i < specs.length) {
            result[i] = BundleDescriptionBuilder.createRequiredBundle(specs[i]);
            ++i;
        }
        return result;
    }

    private static BundleSpecification createRequiredBundle(ManifestElement spec) {
        BundleSpecificationImpl result = new BundleSpecificationImpl();
        result.setName(spec.getValue());
        result.setVersionRange(BundleDescriptionBuilder.getVersionRange(spec.getAttribute("bundle-version")));
        result.setExported("reexport".equals(spec.getDirective("visibility")) || TRUE.equals(spec.getAttribute(REPROVIDE_ATTRIBUTE)));
        result.setOptional("optional".equals(spec.getDirective("resolution")) || TRUE.equals(spec.getAttribute("optional")));
        result.setAttributes(BundleDescriptionBuilder.getAttributes(spec, DEFINED_BSN_MATCHING_ATTRS));
        result.setArbitraryDirectives(BundleDescriptionBuilder.getDirectives(spec, DEFINED_REQUIRE_BUNDLE_DIRECTIVES));
        return result;
    }

    private static ImportPackageSpecification[] createImportPackages(ExportPackageDescription[] exported, List<String> providedExports, ManifestElement[] imported, ManifestElement[] dynamicImported, int manifestVersion) {
        int n;
        int n2;
        ManifestElement[] manifestElementArray;
        ArrayList<ImportPackageSpecification> allImports = null;
        if (manifestVersion < 2) {
            if (exported.length == 0 && imported == null && dynamicImported == null) {
                return null;
            }
            allImports = new ArrayList(exported.length + (imported == null ? 0 : imported.length));
            manifestElementArray = exported;
            n2 = exported.length;
            n = 0;
            while (n < n2) {
                ManifestElement exportDescription = manifestElementArray[n];
                if (!providedExports.contains(exportDescription.getName())) {
                    ImportPackageSpecificationImpl result = new ImportPackageSpecificationImpl();
                    result.setName(exportDescription.getName());
                    result.setVersionRange(BundleDescriptionBuilder.getVersionRange(exportDescription.getVersion().toString()));
                    result.setDirective("resolution", "static");
                    allImports.add(result);
                }
                ++n;
            }
        } else {
            allImports = new ArrayList<ImportPackageSpecification>(imported == null ? 0 : imported.length);
        }
        if (dynamicImported != null) {
            manifestElementArray = dynamicImported;
            n2 = dynamicImported.length;
            n = 0;
            while (n < n2) {
                ManifestElement dynamicImport = manifestElementArray[n];
                BundleDescriptionBuilder.addImportPackages(dynamicImport, allImports, manifestVersion, true);
                ++n;
            }
        }
        if (imported != null) {
            manifestElementArray = imported;
            n2 = imported.length;
            n = 0;
            while (n < n2) {
                ManifestElement pkgImport = manifestElementArray[n];
                BundleDescriptionBuilder.addImportPackages(pkgImport, allImports, manifestVersion, false);
                ++n;
            }
        }
        return allImports.toArray(new ImportPackageSpecification[allImports.size()]);
    }

    private static void addImportPackages(ManifestElement importPackage, List<ImportPackageSpecification> allImports, int manifestVersion, boolean dynamic) {
        String[] importNames;
        String[] stringArray = importNames = importPackage.getValueComponents();
        int n = importNames.length;
        int n2 = 0;
        while (n2 < n) {
            String importName = stringArray[n2];
            if (manifestVersion < 2) {
                Iterator<ImportPackageSpecification> iter = allImports.iterator();
                while (iter.hasNext()) {
                    if (!importName.equals(iter.next().getName())) continue;
                    iter.remove();
                }
            }
            ImportPackageSpecificationImpl result = new ImportPackageSpecificationImpl();
            result.setName(importName);
            String versionString = importPackage.getAttribute(ATTR_TYPE_VERSION);
            if (versionString == null) {
                versionString = importPackage.getAttribute(PACKAGE_SPECIFICATION_VERSION);
            }
            result.setVersionRange(BundleDescriptionBuilder.getVersionRange(versionString));
            result.setBundleSymbolicName(importPackage.getAttribute("bundle-symbolic-name"));
            result.setBundleVersionRange(BundleDescriptionBuilder.getVersionRange(importPackage.getAttribute("bundle-version")));
            if (manifestVersion >= 2) {
                result.setAttributes(BundleDescriptionBuilder.getAttributes(importPackage, DEFINED_PACKAGE_MATCHING_ATTRS));
            }
            if (dynamic) {
                result.setDirective("resolution", "dynamic");
            } else {
                result.setDirective("resolution", BundleDescriptionBuilder.getResolution(importPackage.getDirective("resolution")));
            }
            result.setArbitraryDirectives(BundleDescriptionBuilder.getDirectives(importPackage, DEFINED_IMPORT_PACKAGE_DIRECTIVES));
            allImports.add(result);
            ++n2;
        }
    }

    private static String getResolution(String resolution) {
        String result = "static";
        if ("optional".equals(resolution) || "dynamic".equals(resolution)) {
            result = resolution;
        }
        return result;
    }

    private static ExportPackageDescription[] createExportPackages(ManifestElement[] exported, ManifestElement[] provides, List<String> providedExports, boolean strict) {
        int numExports = (exported == null ? 0 : exported.length) + (provides == null ? 0 : provides.length);
        if (numExports == 0) {
            return null;
        }
        ArrayList<ExportPackageDescription> allExports = new ArrayList<ExportPackageDescription>(numExports);
        if (exported != null) {
            ManifestElement[] manifestElementArray = exported;
            int n = exported.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement packageExport = manifestElementArray[n2];
                BundleDescriptionBuilder.addExportPackages(packageExport, allExports, strict);
                ++n2;
            }
        }
        if (provides != null) {
            BundleDescriptionBuilder.addProvidePackages(provides, allExports, providedExports);
        }
        return allExports.toArray(new ExportPackageDescription[allExports.size()]);
    }

    private static void addExportPackages(ManifestElement exportPackage, List<ExportPackageDescription> allExports, boolean strict) {
        String[] exportNames;
        String[] stringArray = exportNames = exportPackage.getValueComponents();
        int n = exportNames.length;
        int n2 = 0;
        while (n2 < n) {
            String exportName = stringArray[n2];
            if (!strict || !TRUE.equals(exportPackage.getDirective(INTERNAL_DIRECTIVE))) {
                ExportPackageDescriptionImpl result = new ExportPackageDescriptionImpl();
                result.setName(exportName);
                String versionString = exportPackage.getAttribute(ATTR_TYPE_VERSION);
                if (versionString == null) {
                    versionString = exportPackage.getAttribute(PACKAGE_SPECIFICATION_VERSION);
                }
                if (versionString != null) {
                    result.setVersion(Version.parseVersion((String)versionString));
                }
                result.setDirective("uses", ManifestElement.getArrayFromList((String)exportPackage.getDirective("uses")));
                result.setDirective("include", exportPackage.getDirective("include"));
                result.setDirective("exclude", exportPackage.getDirective("exclude"));
                result.setDirective(FRIENDS_DIRECTIVE, ManifestElement.getArrayFromList((String)exportPackage.getDirective(FRIENDS_DIRECTIVE)));
                result.setDirective(INTERNAL_DIRECTIVE, Boolean.valueOf(exportPackage.getDirective(INTERNAL_DIRECTIVE)));
                result.setDirective("mandatory", ManifestElement.getArrayFromList((String)exportPackage.getDirective("mandatory")));
                result.setAttributes(BundleDescriptionBuilder.getAttributes(exportPackage, DEFINED_PACKAGE_MATCHING_ATTRS));
                result.setArbitraryDirectives(BundleDescriptionBuilder.getDirectives(exportPackage, DEFINED_EXPORT_PACKAGE_DIRECTIVES));
                allExports.add(result);
            }
            ++n2;
        }
    }

    private static void addProvidePackages(ManifestElement[] provides, List<ExportPackageDescription> allExports, List<String> providedExports) {
        ExportPackageDescription[] currentExports = allExports.toArray(new ExportPackageDescription[allExports.size()]);
        ManifestElement[] manifestElementArray = provides;
        int n = provides.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement provide = manifestElementArray[n2];
            boolean duplicate = false;
            ExportPackageDescription[] exportPackageDescriptionArray = currentExports;
            int n3 = currentExports.length;
            int n4 = 0;
            while (n4 < n3) {
                ExportPackageDescription currentExport = exportPackageDescriptionArray[n4];
                if (provide.getValue().equals(currentExport.getName())) {
                    duplicate = true;
                    break;
                }
                ++n4;
            }
            if (!duplicate) {
                ExportPackageDescriptionImpl result = new ExportPackageDescriptionImpl();
                result.setName(provide.getValue());
                allExports.add(result);
            }
            providedExports.add(provide.getValue());
            ++n2;
        }
    }

    private static Map<String, String> getDirectives(ManifestElement element, String[] definedDirectives) {
        Enumeration keys = element.getDirectiveKeys();
        if (keys == null) {
            return null;
        }
        HashMap<String, String> arbitraryDirectives = null;
        block0: while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String[] stringArray = definedDirectives;
            int n = definedDirectives.length;
            int n2 = 0;
            while (n2 < n) {
                String definedDirective = stringArray[n2];
                if (definedDirective.equals(key)) continue block0;
                ++n2;
            }
            if (arbitraryDirectives == null) {
                arbitraryDirectives = new HashMap<String, String>();
            }
            arbitraryDirectives.put(key, element.getDirective(key));
        }
        return arbitraryDirectives;
    }

    /*
     * Unable to fully structure code
     */
    private static Map<String, Object> getAttributes(ManifestElement element, String[] definedAttrs) {
        keys = element.getKeys();
        arbitraryAttrs = null;
        if (keys != null) ** GOTO lbl28
        return null;
lbl-1000:
        // 1 sources

        {
            definedAttr = false;
            key = (String)keys.nextElement();
            var9_10 = definedAttrs;
            var8_9 = definedAttrs.length;
            var7_7 = 0;
            while (var7_7 < var8_9) {
                attr = var9_10[var7_7];
                if (attr.equals(key)) {
                    definedAttr = true;
                    break;
                }
                ++var7_7;
            }
            value = element.getAttribute(key);
            colonIndex = key.indexOf(58);
            type = "string";
            if (colonIndex > 0) {
                type = key.substring(colonIndex + 1).trim();
                key = key.substring(0, colonIndex).trim();
            }
            if (definedAttr) continue;
            if (arbitraryAttrs == null) {
                arbitraryAttrs = new HashMap<String, Object>();
            }
            arbitraryAttrs.put(key, BundleDescriptionBuilder.convertValue(type, value));
lbl28:
            // 3 sources

            ** while (keys.hasMoreElements())
        }
lbl29:
        // 1 sources

        return arbitraryAttrs;
    }

    private static Object convertValue(String type, String value) {
        if (ATTR_TYPE_STRING.equalsIgnoreCase(type)) {
            return value;
        }
        String trimmed = value.trim();
        if (ATTR_TYPE_DOUBLE.equalsIgnoreCase(type)) {
            return Double.valueOf(trimmed);
        }
        if (ATTR_TYPE_LONG.equalsIgnoreCase(type)) {
            return Long.valueOf(trimmed);
        }
        if (ATTR_TYPE_URI.equalsIgnoreCase(type)) {
            try {
                Class<?> uriClazz = Class.forName("java.net.URI");
                Constructor<?> constructor = uriClazz.getConstructor(String.class);
                return constructor.newInstance(trimmed);
            }
            catch (ClassNotFoundException e) {
                return value;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (ATTR_TYPE_VERSION.equalsIgnoreCase(type)) {
            return new Version(trimmed);
        }
        if (ATTR_TYPE_SET.equalsIgnoreCase(type)) {
            return ManifestElement.getArrayFromList((String)trimmed, (String)",");
        }
        Tokenizer listTokenizer = new Tokenizer(type);
        String listType = listTokenizer.getToken("<");
        if (!ATTR_TYPE_LIST.equalsIgnoreCase(listType)) {
            throw new RuntimeException("Unsupported type: " + type);
        }
        char c = listTokenizer.getChar();
        String componentType = ATTR_TYPE_STRING;
        if (c == '<') {
            componentType = listTokenizer.getToken(">");
            if (listTokenizer.getChar() != '>') {
                throw new RuntimeException("Invalid type, missing ending '>' : " + type);
            }
        }
        List<String> tokens = new Tokenizer(value).getEscapedTokens(",");
        ArrayList<Object> components = new ArrayList<Object>();
        for (String component : tokens) {
            components.add(BundleDescriptionBuilder.convertValue(componentType, component));
        }
        return components;
    }

    private static HostSpecification createHostSpecification(ManifestElement spec) {
        if (spec == null) {
            return null;
        }
        HostSpecificationImpl result = new HostSpecificationImpl();
        result.setName(spec.getValue());
        result.setVersionRange(BundleDescriptionBuilder.getVersionRange(spec.getAttribute("bundle-version")));
        String multiple = spec.getDirective("multiple-hosts");
        result.setIsMultiHost(TRUE.equals(multiple));
        result.setAttributes(BundleDescriptionBuilder.getAttributes(spec, DEFINED_BSN_MATCHING_ATTRS));
        result.setArbitraryDirectives(BundleDescriptionBuilder.getDirectives(spec, DEFINED_FRAGMENT_HOST_DIRECTIVES));
        return result;
    }

    private static GenericSpecification[] createGenericRequires(ManifestElement[] equinoxRequires, ManifestElement[] osgiRequires, String[] brees) throws BundleException {
        List<GenericSpecification> result = BundleDescriptionBuilder.createEquinoxRequires(equinoxRequires);
        result = BundleDescriptionBuilder.createOSGiRequires(osgiRequires, result);
        return (result = BundleDescriptionBuilder.convertBREEs(brees, result)) == null ? null : result.toArray(new GenericSpecification[result.size()]);
    }

    private static List<GenericSpecification> convertBREEs(String[] brees, List<GenericSpecification> result) throws BundleException {
        String filterSpec;
        if (brees == null || brees.length == 0) {
            return result;
        }
        if (result == null) {
            result = new ArrayList<GenericSpecification>(brees.length);
        }
        ArrayList<String> breeFilters = new ArrayList<String>();
        String[] stringArray = brees;
        int n = brees.length;
        int n2 = 0;
        while (n2 < n) {
            String bree = stringArray[n2];
            breeFilters.add(BundleDescriptionBuilder.createOSGiEERequirementFilter(bree));
            ++n2;
        }
        if (breeFilters.size() == 1) {
            filterSpec = (String)breeFilters.get(0);
        } else {
            StringBuilder filterBuf = new StringBuilder("(|");
            for (String breeFilter : breeFilters) {
                filterBuf.append(breeFilter);
            }
            filterSpec = filterBuf.append(")").toString();
        }
        GenericSpecificationImpl spec = new GenericSpecificationImpl();
        spec.setResolution(4);
        spec.setType(OSGI_EE_NAMESPACE);
        try {
            Filter filter = FrameworkUtil.createFilter((String)filterSpec);
            spec.setMatchingFilter(filter);
            String name = BundleDescriptionBuilder.getPrimaryKeyValue(filter, spec.getType());
            if (name != null) {
                spec.setName(name);
            }
        }
        catch (InvalidSyntaxException e) {
            throw new BundleException("Error converting required execution environment.", (Throwable)e);
        }
        result.add(spec);
        return result;
    }

    private static String getPrimaryKeyValue(Filter filter, String key) {
        try {
            Method method = filter.getClass().getMethod("getPrimaryKeyValue", String.class);
            return (String)method.invoke((Object)filter, key);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String createOSGiEERequirementFilter(String bree) throws BundleException {
        String[] nameVersion = BundleDescriptionBuilder.getOSGiEENameVersion(bree);
        String eeName = nameVersion[0];
        String v = nameVersion[1];
        String filterSpec = v == null ? "(osgi.ee=" + eeName + ")" : "(&(osgi.ee=" + eeName + ")(version=" + v + "))";
        try {
            FrameworkUtil.createFilter((String)filterSpec);
        }
        catch (InvalidSyntaxException e) {
            filterSpec = "(osgi.ee=" + bree + ")";
            try {
                FrameworkUtil.createFilter((String)filterSpec);
            }
            catch (InvalidSyntaxException e1) {
                throw new BundleException("Error converting required execution environment.", (Throwable)e1);
            }
        }
        return filterSpec;
    }

    private static String[] getOSGiEENameVersion(String bree) {
        int v2idx;
        String ee1 = null;
        String ee2 = null;
        String v1 = null;
        String v2 = null;
        int separator = bree.indexOf(47);
        if (separator <= 0 || separator == bree.length() - 1) {
            ee1 = bree;
        } else {
            ee1 = bree.substring(0, separator);
            ee2 = bree.substring(separator + 1);
        }
        int v1idx = ee1.indexOf(45);
        if (v1idx > 0 && v1idx < ee1.length() - 1) {
            try {
                v1 = ee1.substring(v1idx + 1);
                Version.parseVersion((String)v1);
                ee1 = ee1.substring(0, v1idx);
            }
            catch (IllegalArgumentException e) {
                v1 = null;
            }
        }
        int n = v2idx = ee2 == null ? -1 : ee2.indexOf(45);
        if (v2idx > 0 && v2idx < ee2.length() - 1) {
            try {
                v2 = ee2.substring(v2idx + 1);
                Version.parseVersion((String)v2);
                ee2 = ee2.substring(0, v2idx);
            }
            catch (IllegalArgumentException e) {
                v2 = null;
            }
        }
        if (v1 == null) {
            v1 = v2;
        }
        if (v1 != null && v2 != null && !v1.equals(v2)) {
            ee1 = bree;
            ee2 = null;
            v1 = null;
            v2 = null;
        }
        if ("J2SE".equals(ee1)) {
            ee1 = "JavaSE";
        }
        if ("J2SE".equals(ee2)) {
            ee2 = "JavaSE";
        }
        String eeName = ee1 + (String)(ee2 == null ? "" : "/" + ee2);
        return new String[]{eeName, v1};
    }

    private static List<GenericSpecification> createOSGiRequires(ManifestElement[] osgiRequires, List<GenericSpecification> result) throws BundleException {
        if (osgiRequires == null) {
            return result;
        }
        if (result == null) {
            result = new ArrayList<GenericSpecification>();
        }
        ManifestElement[] manifestElementArray = osgiRequires;
        int n = osgiRequires.length;
        int n2 = 0;
        while (n2 < n) {
            String[] namespaces;
            ManifestElement element = manifestElementArray[n2];
            String[] stringArray = namespaces = element.getValueComponents();
            int n3 = namespaces.length;
            int n4 = 0;
            while (n4 < n3) {
                String cardinality;
                String namespace = stringArray[n4];
                GenericSpecificationImpl spec = new GenericSpecificationImpl();
                spec.setType(namespace);
                String filterSpec = element.getDirective("filter");
                if (filterSpec != null) {
                    try {
                        Filter filter = FrameworkUtil.createFilter((String)filterSpec);
                        spec.setMatchingFilter(filter);
                        String name = BundleDescriptionBuilder.getPrimaryKeyValue(filter, namespace);
                        if (name != null) {
                            spec.setName(name);
                        }
                    }
                    catch (InvalidSyntaxException e) {
                        String message = NLS.bind((String)StateMsg.MANIFEST_INVALID_HEADER_EXCEPTION, (Object)"Require-Capability", (Object)element.toString());
                        throw new BundleException(message + " : filter", 3, (Throwable)e);
                    }
                }
                String resolutionDirective = element.getDirective("resolution");
                int resolution = 0;
                if ("optional".equals(resolutionDirective)) {
                    resolution |= 1;
                }
                if (MULTIPLE_ATTR.equals(cardinality = element.getDirective("cardinality"))) {
                    resolution |= 2;
                }
                spec.setResolution(resolution);
                spec.setAttributes(BundleDescriptionBuilder.getAttributes(element, DEFINED_REQUIRE_CAPABILITY_ATTRS));
                spec.setArbitraryDirectives(BundleDescriptionBuilder.getDirectives(element, DEFINED_REQUIRE_CAPABILITY_DIRECTIVES));
                result.add(spec);
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private static List<GenericSpecification> createEquinoxRequires(ManifestElement[] equinoxRequires) throws BundleException {
        if (equinoxRequires == null) {
            return null;
        }
        ArrayList<GenericSpecification> results = new ArrayList<GenericSpecification>(equinoxRequires.length);
        ManifestElement[] manifestElementArray = equinoxRequires;
        int n = equinoxRequires.length;
        int n2 = 0;
        while (n2 < n) {
            String[] genericNames;
            ManifestElement equinoxRequire = manifestElementArray[n2];
            String[] stringArray = genericNames = equinoxRequire.getValueComponents();
            int n3 = genericNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String genericName = stringArray[n4];
                GenericSpecificationImpl spec = new GenericSpecificationImpl();
                int colonIdx = genericName.indexOf(58);
                if (colonIdx > 0) {
                    spec.setName(genericName.substring(0, colonIdx));
                    spec.setType(genericName.substring(colonIdx + 1));
                } else {
                    spec.setName(genericName);
                }
                try {
                    spec.setMatchingFilter(equinoxRequire.getAttribute("selection-filter"), true);
                }
                catch (InvalidSyntaxException e) {
                    String message = NLS.bind((String)StateMsg.MANIFEST_INVALID_HEADER_EXCEPTION, (Object)GENERIC_REQUIRE, (Object)equinoxRequire.toString());
                    throw new BundleException(message + " : selection-filter", 3, (Throwable)e);
                }
                String optional = equinoxRequire.getAttribute("optional");
                String multiple = equinoxRequire.getAttribute(MULTIPLE_ATTR);
                int resolution = 0;
                if (TRUE.equals(optional)) {
                    resolution |= 1;
                }
                if (TRUE.equals(multiple)) {
                    resolution |= 2;
                }
                spec.setResolution(resolution);
                results.add(spec);
                ++n4;
            }
            ++n2;
        }
        return results;
    }

    private static GenericDescription[] createGenericCapabilities(ManifestElement[] equinoxCapabilities, ManifestElement[] osgiCapabilities, BundleDescription description) throws BundleException {
        List<GenericDescription> result = BundleDescriptionBuilder.createEquinoxCapabilities(equinoxCapabilities);
        return (result = BundleDescriptionBuilder.createOSGiCapabilities(osgiCapabilities, result, description)) == null ? null : result.toArray(new GenericDescription[result.size()]);
    }

    private static List<GenericDescription> createOSGiCapabilities(ManifestElement[] osgiCapabilities, List<GenericDescription> result, BundleDescription description) throws BundleException {
        GenericDescription osgiIdentity;
        if (result == null) {
            result = new ArrayList<GenericDescription>(osgiCapabilities == null ? 1 : osgiCapabilities.length + 1);
        }
        if ((osgiIdentity = BundleDescriptionBuilder.createOsgiIdentityCapability(description)) != null) {
            result.add(0, osgiIdentity);
        }
        return BundleDescriptionBuilder.createOSGiCapabilities(osgiCapabilities, result, null);
    }

    private static List<GenericDescription> createOSGiCapabilities(ManifestElement[] osgiCapabilities, List<GenericDescription> result, Integer profileIndex) throws BundleException {
        if (osgiCapabilities == null) {
            return result;
        }
        if (result == null) {
            result = new ArrayList<GenericDescription>(osgiCapabilities.length);
        }
        ManifestElement[] manifestElementArray = osgiCapabilities;
        int n = osgiCapabilities.length;
        int n2 = 0;
        while (n2 < n) {
            String[] namespaces;
            ManifestElement element = manifestElementArray[n2];
            String[] stringArray = namespaces = element.getValueComponents();
            int n3 = namespaces.length;
            int n4 = 0;
            while (n4 < n3) {
                String namespace = stringArray[n4];
                if ("osgi.identity".equals(namespace)) {
                    throw new BundleException("A bundle is not allowed to define a capability in the osgi.identity name space.");
                }
                GenericDescriptionImpl desc = new GenericDescriptionImpl();
                desc.setType(namespace);
                Map<String, Object> mapAttrs = BundleDescriptionBuilder.getAttributes(element, new String[0]);
                if (profileIndex != null) {
                    mapAttrs.put("x-equinox-ee", profileIndex);
                }
                Hashtable<String, Object> attrs = mapAttrs == null ? new Hashtable<String, Object>() : new Hashtable<String, Object>(mapAttrs);
                desc.setAttributes(attrs);
                HashMap<String, String> directives = new HashMap<String, String>();
                Enumeration keys = element.getDirectiveKeys();
                if (keys != null) {
                    keys = element.getDirectiveKeys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        directives.put(key, element.getDirective(key));
                    }
                }
                desc.setDirectives(directives);
                result.add(desc);
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private static List<GenericDescription> createEquinoxCapabilities(ManifestElement[] equinoxCapabilities) throws BundleException {
        if (equinoxCapabilities == null) {
            return null;
        }
        ArrayList<GenericDescription> results = new ArrayList<GenericDescription>(equinoxCapabilities.length);
        ManifestElement[] manifestElementArray = equinoxCapabilities;
        int n = equinoxCapabilities.length;
        int n2 = 0;
        while (n2 < n) {
            String[] genericNames;
            ManifestElement equinoxCapability = manifestElementArray[n2];
            String[] stringArray = genericNames = equinoxCapability.getValueComponents();
            int n3 = genericNames.length;
            int n4 = 0;
            while (n4 < n3) {
                Map<String, Object> mapAttrs;
                String genericName = stringArray[n4];
                GenericDescriptionImpl desc = new GenericDescriptionImpl();
                String name = genericName;
                int colonIdx = genericName.indexOf(58);
                if (colonIdx > 0) {
                    name = genericName.substring(0, colonIdx);
                    desc.setType(genericName.substring(colonIdx + 1));
                    if ("osgi.identity".equals(desc.getType())) {
                        throw new BundleException("A bundle is not allowed to define a capability in the osgi.identity name space.");
                    }
                }
                Hashtable<String, Object> attrs = (mapAttrs = BundleDescriptionBuilder.getAttributes(equinoxCapability, new String[]{ATTR_TYPE_VERSION})) == null ? new Hashtable<String, Object>() : new Hashtable<String, Object>(mapAttrs);
                ((Dictionary)attrs).put(desc.getType(), name);
                String versionString = equinoxCapability.getAttribute(ATTR_TYPE_VERSION);
                if (versionString != null) {
                    ((Dictionary)attrs).put(ATTR_TYPE_VERSION, Version.parseVersion((String)versionString));
                }
                desc.setAttributes(attrs);
                results.add(desc);
                ++n4;
            }
            ++n2;
        }
        return results;
    }

    private static VersionRange getVersionRange(String versionRange) {
        if (versionRange == null) {
            return null;
        }
        return new VersionRange(versionRange);
    }

    private static void checkImportExportSyntax(String headerKey, ManifestElement[] elements, boolean export, boolean dynamic, boolean jreBundle) throws BundleException {
        if (elements == null) {
            return;
        }
        int length = elements.length;
        HashSet<String> packages = new HashSet<String>(length);
        int i = 0;
        while (i < length) {
            String specVersion;
            String[] packageNames;
            String[] stringArray = packageNames = elements[i].getValueComponents();
            int n = packageNames.length;
            int n2 = 0;
            while (n2 < n) {
                String packageName = stringArray[n2];
                if (!export && !dynamic && packages.contains(packageName)) {
                    String message = NLS.bind((String)StateMsg.MANIFEST_INVALID_HEADER_EXCEPTION, (Object)headerKey, (Object)elements[i].toString());
                    throw new BundleException(message + " : " + NLS.bind((String)StateMsg.HEADER_PACKAGE_DUPLICATES, (Object)packageName), 3);
                }
                if (export && !jreBundle && packageName.startsWith("java.")) {
                    String message = NLS.bind((String)StateMsg.MANIFEST_INVALID_HEADER_EXCEPTION, (Object)headerKey, (Object)elements[i].toString());
                    throw new BundleException(message + " : " + NLS.bind((String)StateMsg.HEADER_PACKAGE_JAVA, (Object)packageName), 3);
                }
                packages.add(packageName);
                ++n2;
            }
            String version = elements[i].getAttribute(ATTR_TYPE_VERSION);
            if (version != null && (specVersion = elements[i].getAttribute(PACKAGE_SPECIFICATION_VERSION)) != null && !specVersion.equals(version)) {
                throw new BundleException(NLS.bind((String)StateMsg.HEADER_VERSION_ERROR, (Object)ATTR_TYPE_VERSION, (Object)PACKAGE_SPECIFICATION_VERSION), 3);
            }
            if (export) {
                if (elements[i].getAttribute("bundle-symbolic-name") != null) {
                    String message = NLS.bind((String)StateMsg.MANIFEST_INVALID_HEADER_EXCEPTION, (Object)headerKey, (Object)elements[i].toString());
                    throw new BundleException(message + " : " + NLS.bind((String)StateMsg.HEADER_EXPORT_ATTR_ERROR, (Object)"bundle-symbolic-name", (Object)"Export-Package"), 3);
                }
                if (elements[i].getAttribute("bundle-version") != null) {
                    String message = NLS.bind((String)StateMsg.MANIFEST_INVALID_HEADER_EXCEPTION, (Object)headerKey, (Object)elements[i].toString());
                    throw new BundleException(NLS.bind((String)(message + " : " + StateMsg.HEADER_EXPORT_ATTR_ERROR), (Object)"bundle-version", (Object)"Export-Package"), 3);
                }
            }
            ++i;
        }
    }

    private static void checkForDuplicateDirectivesAttributes(String headerKey, ManifestElement[] elements) throws BundleException {
        ManifestElement[] manifestElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Enumeration attrKeys;
            ManifestElement element = manifestElementArray[n2];
            Enumeration directiveKeys = element.getDirectiveKeys();
            if (directiveKeys != null) {
                while (directiveKeys.hasMoreElements()) {
                    String key = (String)directiveKeys.nextElement();
                    String[] directives = element.getDirectives(key);
                    if (directives.length <= 1) continue;
                    String message = NLS.bind((String)StateMsg.MANIFEST_INVALID_HEADER_EXCEPTION, (Object)headerKey, (Object)element.toString());
                    throw new BundleException(NLS.bind((String)(message + " : " + StateMsg.HEADER_DIRECTIVE_DUPLICATES), (Object)key), 3);
                }
            }
            if ((attrKeys = element.getKeys()) != null) {
                while (attrKeys.hasMoreElements()) {
                    String key = (String)attrKeys.nextElement();
                    String[] attrs = element.getAttributes(key);
                    if (attrs.length <= 1) continue;
                    String message = NLS.bind((String)StateMsg.MANIFEST_INVALID_HEADER_EXCEPTION, (Object)headerKey, (Object)element.toString());
                    throw new BundleException(message + " : " + NLS.bind((String)StateMsg.HEADER_ATTRIBUTE_DUPLICATES, (Object)key), 3);
                }
            }
            ++n2;
        }
    }

    private static void checkExtensionBundle(String headerKey, ManifestElement[] elements) throws BundleException {
        if (elements.length == 0 || elements[0].getDirective("extension") == null) {
            return;
        }
        String hostName = elements[0].getValue();
        if (!hostName.equals("system.bundle") && !hostName.equals(NAME)) {
            String message = NLS.bind((String)StateMsg.MANIFEST_INVALID_HEADER_EXCEPTION, (Object)headerKey, (Object)elements[0].toString());
            throw new BundleException(message + " : " + NLS.bind((String)StateMsg.HEADER_EXTENSION_ERROR, (Object)hostName), 3);
        }
    }

    static GenericDescription createOsgiIdentityCapability(BundleDescription description) {
        if (description.getSymbolicName() == null) {
            return null;
        }
        GenericDescriptionImpl result = new GenericDescriptionImpl();
        result.setType("osgi.identity");
        Hashtable<String, Object> attributes = new Hashtable<String, Object>(description.getDeclaredAttributes());
        ((Dictionary)attributes).remove("osgi.wiring.bundle");
        ((Dictionary)attributes).remove("bundle-version");
        ((Dictionary)attributes).put("osgi.identity", description.getSymbolicName());
        ((Dictionary)attributes).put("type", description.getHost() == null ? "osgi.bundle" : "osgi.fragment");
        ((Dictionary)attributes).put(ATTR_TYPE_VERSION, description.getVersion());
        result.setAttributes(attributes);
        HashMap<String, String> directives = new HashMap<String, String>(description.getDeclaredDirectives());
        if (!description.isSingleton()) {
            directives.remove("singleton");
        }
        if (description.attachFragments() && description.dynamicFragments()) {
            directives.remove("fragment-attachment");
        }
        result.setDirectives(directives);
        return result;
    }
}

