/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.misc.UIStats;

public class PartListenerList
extends EventManager {
    public void addPartListener(IPartListener l) {
        this.addListenerObject(l);
    }

    private void fireEvent(SafeRunnable runnable, IPartListener listener, IWorkbenchPart part, String description) {
        String label = null;
        if (UIStats.isDebugging(9)) {
            label = String.valueOf(description) + part.getTitle();
            UIStats.start(9, label);
        }
        SafeRunner.run((ISafeRunnable)runnable);
        if (UIStats.isDebugging(9)) {
            UIStats.end(9, listener, label);
        }
    }

    public void firePartActivated(final IWorkbenchPart part) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final IPartListener partListener = (IPartListener)listener;
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    partListener.partActivated(part);
                }
            }, partListener, part, "activated::");
            ++n2;
        }
    }

    public void firePartBroughtToTop(final IWorkbenchPart part) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final IPartListener partListener = (IPartListener)listener;
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    partListener.partBroughtToTop(part);
                }
            }, partListener, part, "broughtToTop::");
            ++n2;
        }
    }

    public void firePartClosed(final IWorkbenchPart part) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            final IPartListener partListener = (IPartListener)element;
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    partListener.partClosed(part);
                }
            }, partListener, part, "closed::");
            ++n2;
        }
    }

    public void firePartDeactivated(final IWorkbenchPart part) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final IPartListener partListener = (IPartListener)listener;
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    partListener.partDeactivated(part);
                }
            }, partListener, part, "deactivated::");
            ++n2;
        }
    }

    public void firePartOpened(final IWorkbenchPart part) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final IPartListener partListener = (IPartListener)listener;
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    partListener.partOpened(part);
                }
            }, partListener, part, "opened::");
            ++n2;
        }
    }

    public void removePartListener(IPartListener l) {
        this.removeListenerObject(l);
    }
}

