/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.security.cert.X509Certificate;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.viewers.CertificateLabelProvider;
import org.eclipse.equinox.internal.provisional.security.ui.X509CertificateViewDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class TrustCertificateDialog
extends ListSelectionDialog {
    private TreeViewer certificateChainViewer;
    private Button detailsButton;
    protected TreeNode parentElement;
    protected Object selectedCertificate;

    public TrustCertificateDialog(Shell parentShell, Object input, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parentShell, input, (IStructuredContentProvider)contentProvider, labelProvider, ProvUIMessages.TrustCertificateDialog_Title);
        this.setShellStyle(0x870 | TrustCertificateDialog.getDefaultOrientation());
    }

    private void createButtons(Composite composite) {
        this.detailsButton = new Button(composite, 0);
        this.detailsButton.setText(ProvUIMessages.TrustCertificateDialog_Details);
        this.detailsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (TrustCertificateDialog.this.selectedCertificate != null) {
                    X509Certificate cert = (X509Certificate)((TreeNode)TrustCertificateDialog.this.selectedCertificate).getValue();
                    X509CertificateViewDialog certificateDialog = new X509CertificateViewDialog(TrustCertificateDialog.this.getShell(), cert);
                    certificateDialog.open();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, ProvUIMessages.TrustCertificateDialog_AcceptSelectedButtonLabel, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.certificateChainViewer = new TreeViewer(composite, 2048);
        GridLayout layout = new GridLayout();
        this.certificateChainViewer.getTree().setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        this.certificateChainViewer.getTree().setLayoutData((Object)data);
        this.certificateChainViewer.setAutoExpandLevel(-1);
        this.certificateChainViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.certificateChainViewer.setLabelProvider((IBaseLabelProvider)new CertificateLabelProvider());
        this.certificateChainViewer.addSelectionChangedListener(this.getChainSelectionListener());
        Object input = this.getViewer().getInput();
        if (input instanceof Object[]) {
            StructuredSelection selection = null;
            Object[] nodes = (Object[])input;
            if (nodes.length > 0) {
                selection = new StructuredSelection(nodes[0]);
                this.certificateChainViewer.setInput((Object)new TreeNode[]{(TreeNode)nodes[0]});
                this.selectedCertificate = nodes[0];
            }
            this.getViewer().setSelection(selection);
        }
        this.getViewer().addDoubleClickListener(this.getDoubleClickListener());
        this.getViewer().addSelectionChangedListener(this.getParentSelectionListener());
        this.createButtons(composite);
        return composite;
    }

    private ISelectionChangedListener getChainSelectionListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection) {
                    TrustCertificateDialog.this.selectedCertificate = ((StructuredSelection)selection).getFirstElement();
                }
            }
        };
    }

    public TreeViewer getCertificateChainViewer() {
        return this.certificateChainViewer;
    }

    private IDoubleClickListener getDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof TreeNode) {
                    TreeNode treeNode = (TreeNode)selectedElement;
                    X509CertificateViewDialog certificateViewDialog = new X509CertificateViewDialog(TrustCertificateDialog.this.getShell(), (X509Certificate)treeNode.getValue());
                    certificateViewDialog.open();
                }
            }
        };
    }

    private ISelectionChangedListener getParentSelectionListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection) {
                    TrustCertificateDialog.this.getCertificateChainViewer().setInput((Object)new TreeNode[]{(TreeNode)((StructuredSelection)selection).getFirstElement()});
                    TrustCertificateDialog.this.getCertificateChainViewer().refresh();
                }
            }
        };
    }
}

