/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.TypePattern;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;

public class RecordPattern
extends Pattern {
    public Pattern[] patterns;
    public TypeReference type;

    public RecordPattern(TypeReference type, int sourceStart, int sourceEnd) {
        this.type = type;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    @Override
    public TypeReference getType() {
        return this.type;
    }

    @Override
    public void setIsEitherOrPattern() {
        Pattern[] patternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            p.setIsEitherOrPattern();
            ++n2;
        }
    }

    @Override
    public LocalVariableBinding[] bindingsWhenTrue() {
        LocalVariableBinding[] variables = NO_VARIABLES;
        Pattern[] patternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            variables = LocalVariableBinding.merge(variables, p.bindingsWhenTrue());
            ++n2;
        }
        return variables;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        Pattern[] patternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            flowInfo = p.analyseCode(currentScope, flowContext, flowInfo);
            ++n2;
        }
        return flowInfo;
    }

    @Override
    public boolean coversType(TypeBinding t, Scope scope) {
        if (!this.isUnguarded()) {
            return false;
        }
        if (TypeBinding.equalsEquals(t, this.resolvedType)) {
            return this.isTotalTypeNode;
        }
        if (!t.isRecord()) {
            return false;
        }
        RecordComponentBinding[] components = t.components();
        if (components == null || components.length != this.patterns.length) {
            return false;
        }
        int i = 0;
        while (i < components.length) {
            Pattern p = this.patterns[i];
            RecordComponentBinding componentBinding = components[i];
            if (!p.coversType(componentBinding.type, scope)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        this.type.bits |= 0x40000000;
        this.resolvedType = this.type.resolveType(scope);
        if (this.resolvedType == null || !this.resolvedType.isRecord()) {
            scope.problemReporter().unexpectedTypeinRecordPattern(this.type);
            return this.resolvedType;
        }
        if (this.resolvedType.components().length != this.patterns.length) {
            scope.problemReporter().recordPatternSignatureMismatch(this.resolvedType, this);
            this.resolvedType = null;
            return null;
        }
        if (this.resolvedType.isRawType() && this.outerExpressionType instanceof ReferenceBinding) {
            ReferenceBinding binding = this.inferRecordParameterization(scope, (ReferenceBinding)this.outerExpressionType);
            if (binding == null || !binding.isValidBinding()) {
                scope.problemReporter().cannotInferRecordPatternTypes(this);
                this.resolvedType = null;
                return null;
            }
            this.resolvedType = binding.capture(scope, this.sourceStart, this.sourceEnd);
        }
        LocalVariableBinding[] bindings = NO_VARIABLES;
        int i = 0;
        int l = this.patterns.length;
        while (i < l) {
            Pattern p = this.patterns[i];
            p.resolveTypeWithBindings(bindings, scope);
            bindings = LocalVariableBinding.merge(bindings, p.bindingsWhenTrue());
            p.setOuterExpressionType(this.resolvedType.components()[i].type);
            ++i;
        }
        if (this.resolvedType == null || !this.resolvedType.isValidBinding()) {
            return this.resolvedType;
        }
        this.isTotalTypeNode = super.coversType(this.resolvedType, scope);
        RecordComponentBinding[] components = this.resolvedType.capture(scope, this.sourceStart, this.sourceEnd).components();
        int i2 = 0;
        while (i2 < components.length) {
            TypeBinding componentType;
            TypePattern tp;
            Pattern p1 = this.patterns[i2];
            RecordComponentBinding componentBinding = components[i2];
            if (p1 instanceof TypePattern && ((tp = (TypePattern)p1).getType() == null || tp.getType().isTypeNameVar(scope)) && tp.local.binding != null) {
                tp.local.binding.type = componentBinding.type;
            }
            if (p1.isApplicable(componentType = componentBinding.type, scope, p1)) {
                p1.isTotalTypeNode = p1.coversType(componentType, scope);
                MethodBinding[] methods = this.resolvedType.getMethods(componentBinding.name);
                if (methods != null && methods.length > 0) {
                    p1.accessorMethod = methods[0];
                }
            }
            this.isTotalTypeNode &= p1.isTotalTypeNode;
            ++i2;
        }
        return this.resolvedType;
    }

    private ReferenceBinding inferRecordParameterization(BlockScope scope, ReferenceBinding proposedMatchingType) {
        InferenceContext18 freshInferenceContext = new InferenceContext18(scope);
        try {
            ReferenceBinding referenceBinding = freshInferenceContext.inferRecordPatternParameterization(this, scope, proposedMatchingType);
            return referenceBinding;
        }
        finally {
            freshInferenceContext.cleanUp();
        }
    }

    @Override
    public boolean matchFailurePossible() {
        return this.patterns.length != 0;
    }

    @Override
    public boolean dominates(Pattern p) {
        if (!this.isUnguarded()) {
            return false;
        }
        if (this.resolvedType == null || !this.resolvedType.isValidBinding() || p.resolvedType == null || !p.resolvedType.isValidBinding()) {
            return false;
        }
        if (TypeBinding.notEquals(this.resolvedType.erasure(), p.resolvedType.erasure())) {
            return false;
        }
        if (!this.resolvedType.erasure().isRecord()) {
            return false;
        }
        if (p instanceof RecordPattern) {
            RecordPattern rp = (RecordPattern)p;
            if (this.patterns.length != rp.patterns.length) {
                return false;
            }
            int i = 0;
            int length = this.patterns.length;
            while (i < length) {
                if (!this.patterns[i].dominates(rp.patterns[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, BranchLabel patternMatchLabel, BranchLabel matchFailLabel) {
        int length = this.patterns.length;
        if (length == 0) {
            codeStream.pop();
            return;
        }
        codeStream.checkcast(this.resolvedType);
        ArrayList<ExceptionLabel> labels = new ArrayList<ExceptionLabel>();
        int i = 0;
        while (i < length) {
            boolean lastComponent;
            Pattern p = this.patterns[i];
            boolean bl = lastComponent = i == length - 1;
            if (!lastComponent) {
                codeStream.dup();
            }
            ExceptionLabel exceptionLabel = new ExceptionLabel(codeStream, TypeBinding.wellKnownType(currentScope, 21));
            exceptionLabel.placeStart();
            codeStream.invoke((byte)-74, p.accessorMethod.original(), this.resolvedType, null);
            exceptionLabel.placeEnd();
            labels.add(exceptionLabel);
            TypeBinding componentType = p.accessorMethod.returnType;
            if (TypeBinding.notEquals(p.accessorMethod.original().returnType.erasure(), componentType.erasure())) {
                codeStream.checkcast(componentType);
            }
            if (p instanceof RecordPattern || !p.isTotalTypeNode) {
                if (!p.isUnnamed()) {
                    codeStream.dup(componentType);
                }
                if (p instanceof TypePattern) {
                    ((TypePattern)p).generateTypeCheck(currentScope, codeStream, matchFailLabel);
                } else {
                    codeStream.instance_of(p.resolvedType);
                }
                BranchLabel innerTruthLabel = new BranchLabel(codeStream);
                codeStream.ifne(innerTruthLabel);
                int pops = p.isUnnamed() ? 0 : TypeIds.getCategory(componentType.id);
                Pattern current = p;
                RecordPattern outer = this;
                while (outer != null) {
                    RecordPattern rp;
                    if (current.index != outer.patterns.length - 1) {
                        ++pops;
                    }
                    current = outer;
                    Pattern pattern = outer.getEnclosingPattern();
                    RecordPattern recordPattern = outer = pattern instanceof RecordPattern ? (rp = (RecordPattern)pattern) : null;
                }
                while (pops > 1) {
                    codeStream.pop2();
                    pops -= 2;
                }
                if (pops > 0) {
                    codeStream.pop();
                }
                codeStream.goto_(matchFailLabel);
                innerTruthLabel.place();
            }
            p.generateCode(currentScope, codeStream, patternMatchLabel, matchFailLabel);
            ++i;
        }
        if (labels.size() > 0) {
            BlockScope trapScope = codeStream.accessorExceptionTrapScopes.peek();
            List<ExceptionLabel> eLabels = codeStream.patternAccessorMap.get(trapScope);
            if (eLabels == null || eLabels.isEmpty()) {
                eLabels = labels;
            } else {
                eLabels.addAll(labels);
            }
            codeStream.patternAccessorMap.put(trapScope, eLabels);
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.type.traverse(visitor, scope);
            Pattern[] patternArray = this.patterns;
            int n = this.patterns.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern p = patternArray[n2];
                p.traverse(visitor, scope);
                ++n2;
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        output.append(this.type).append('(');
        int i = 0;
        while (i < this.patterns.length) {
            if (i > 0) {
                output.append(", ");
            }
            this.patterns[i].print(0, output);
            ++i;
        }
        output.append(')');
        return output;
    }
}

