/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.userstorage.IBlob;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.StorageFactory;
import org.eclipse.userstorage.internal.Activator;
import org.eclipse.userstorage.internal.Blob;
import org.eclipse.userstorage.internal.InternalStorageCache;
import org.eclipse.userstorage.internal.Session;
import org.eclipse.userstorage.internal.StorageService;
import org.eclipse.userstorage.internal.StorageServiceRegistry;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.AbstractCredentialsProvider;
import org.eclipse.userstorage.spi.ICredentialsProvider;
import org.eclipse.userstorage.spi.ISettings;
import org.eclipse.userstorage.spi.StorageCache;
import org.eclipse.userstorage.util.BadApplicationTokenException;
import org.eclipse.userstorage.util.ConflictException;
import org.eclipse.userstorage.util.NoServiceException;
import org.eclipse.userstorage.util.NotFoundException;

public final class Storage
implements IStorage {
    private static final String DEFAULT_APPLICATION_TOKEN = "<default>";
    private static final int CHUNK_SIZE = 100;
    private final List<IStorage.Listener> listeners = new CopyOnWriteArrayList<IStorage.Listener>();
    private final String applicationToken;
    private final StorageFactory factory;
    private final InternalStorageCache cache;
    private final Map<String, Blob> blobs = new WeakHashMap<String, Blob>();
    private StorageService service;
    private Session session;
    private ICredentialsProvider credentialsProvider;

    public Storage(StorageFactory factory, String applicationToken, InternalStorageCache cache) throws BadApplicationTokenException {
        this.applicationToken = BadApplicationTokenException.validate(applicationToken);
        this.factory = factory;
        this.cache = cache;
        StorageServiceRegistry.INSTANCE.addStorage(this);
    }

    @Override
    public String getApplicationToken() {
        return this.applicationToken;
    }

    @Override
    public StorageFactory getFactory() {
        return this.factory;
    }

    @Override
    public StorageCache getCache() {
        return (StorageCache)this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageService getService() {
        StorageService newService;
        StorageService oldService;
        Storage storage = this;
        synchronized (storage) {
            newService = oldService = this.service;
            if (newService != null) {
                URI serviceURI = newService.getServiceURI();
                this.service = newService = StorageServiceRegistry.INSTANCE.getService(serviceURI);
            }
            if (newService == null) {
                this.service = newService = this.lookupService();
                if (this.cache != null) {
                    this.cache.setService(newService);
                }
            }
        }
        this.notifyListeners(oldService, newService);
        return newService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setService(IStorageService service) {
        StorageService oldService;
        Storage storage = this;
        synchronized (storage) {
            oldService = this.service;
            if (service != oldService) {
                this.disposeBlobs();
                this.service = (StorageService)service;
                String serviceURI = service == null ? null : service.getServiceURI().toString();
                this.setServiceURI(serviceURI);
                if (this.cache != null) {
                    this.cache.setService(service);
                }
            }
        }
        this.notifyListeners(oldService, service);
    }

    @Override
    public ICredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    public void setCredentialsProvider(ICredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public Iterable<IBlob> getBlobs() throws IOException {
        return new Iterable<IBlob>(){

            @Override
            public Iterator<IBlob> iterator() {
                return new Iterator<IBlob>(){
                    private int page;
                    private boolean lastChunk;
                    private boolean endReached;
                    private Iterator<IBlob> chunk;
                    private RuntimeException exception;

                    @Override
                    public boolean hasNext() {
                        while (!this.endReached) {
                            if (this.exception != null) {
                                throw this.exception;
                            }
                            if (this.chunk != null) {
                                if (this.chunk.hasNext()) {
                                    return true;
                                }
                                if (this.lastChunk) {
                                    this.endReached = true;
                                    return false;
                                }
                            }
                            try {
                                List<IBlob> blobs = Storage.this.getBlobs(100, ++this.page);
                                if (blobs.size() < 100) {
                                    this.lastChunk = true;
                                }
                                this.chunk = blobs.iterator();
                                continue;
                            }
                            catch (NotFoundException ex) {
                                this.chunk = null;
                                this.endReached = true;
                                continue;
                            }
                            catch (IOException ex) {
                                this.chunk = null;
                                this.exception = new RuntimeException(ex);
                                continue;
                            }
                            break;
                        }
                        return false;
                    }

                    @Override
                    public IBlob next() {
                        this.hasNext();
                        return this.chunk.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public List<IBlob> getBlobs(int pageSize, int page) throws IOException, NotFoundException {
        ArrayList<IBlob> blobs = new ArrayList<IBlob>();
        Session session = this.getSession();
        Map<String, Map<String, Object>> properties = session.retrieveProperties(this.applicationToken, pageSize, page);
        for (Map.Entry<String, Map<String, Object>> entry : properties.entrySet()) {
            String key = entry.getKey();
            Map<String, Object> value = entry.getValue();
            Blob blob = (Blob)this.getBlob(key);
            blob.setProperties(value);
            blobs.add(blob);
        }
        return blobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBlob getBlob(String key) {
        Storage storage = this;
        synchronized (storage) {
            Blob blob = this.blobs.get(key);
            if (blob == null) {
                HashMap<String, String> properties = new HashMap<String, String>();
                if (this.cache != null) {
                    try {
                        this.cache.internalLoadProperties(this.applicationToken, key, properties);
                    }
                    catch (IOException ex) {
                        properties.clear();
                        Activator.log(ex);
                    }
                }
                blob = new Blob(this, key, properties);
                this.blobs.put(key, blob);
            }
            return blob;
        }
    }

    @Override
    public void addListener(IStorage.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IStorage.Listener listener) {
        this.listeners.remove(listener);
    }

    public void setETag(String key, Map<String, String> properties, String eTag) {
        if (StringUtil.isEmpty(eTag)) {
            properties.remove("etag");
        } else {
            properties.put("etag", eTag);
        }
        if (this.cache != null) {
            try {
                if (!StringUtil.isEmpty(eTag)) {
                    HashMap<String, String> cacheProperties = new HashMap<String, String>();
                    this.cache.loadProperties(this.applicationToken, key, cacheProperties);
                    String cacheETag = (String)cacheProperties.get("etag");
                    if (eTag.equals(cacheETag)) {
                        return;
                    }
                }
                this.cache.internalDelete(this.applicationToken, key);
            }
            catch (IOException ex) {
                Activator.log(ex);
            }
        }
    }

    public InputStream retrieveBlob(String key, Map<String, String> properties) throws IOException, NoServiceException {
        InputStream inputStream;
        InputStream contents;
        InputStream cacheStream;
        block11: {
            OutputStream output;
            block10: {
                cacheStream = null;
                if (this.cache != null) {
                    try {
                        cacheStream = this.cache.internalGetInputStream(this.applicationToken, key);
                    }
                    catch (IOException ex) {
                        Activator.log(ex);
                    }
                }
                Session session = this.getSession();
                contents = session.retrieveBlob(this.applicationToken, key, properties, cacheStream != null);
                if (cacheStream == null || contents != Blob.NOT_MODIFIED) break block10;
                InputStream cacheStreamResult = cacheStream;
                cacheStream = null;
                InputStream inputStream2 = cacheStreamResult;
                IOUtil.closeSilent(cacheStream);
                return inputStream2;
            }
            IOUtil.closeSilent(cacheStream);
            if (this.cache == null || (output = this.cache.internalGetOutputStream(this.applicationToken, key, properties)) == null) break block11;
            IOUtil.TeeInputStream teeInputStream = new IOUtil.TeeInputStream(contents, output);
            IOUtil.closeSilent(cacheStream);
            return teeInputStream;
        }
        try {
            inputStream = contents;
        }
        catch (NotFoundException ex) {
            try {
                IOUtil.closeSilent(cacheStream);
                if (this.cache != null) {
                    this.cache.internalDelete(this.applicationToken, key);
                }
                throw ex;
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(cacheStream);
                throw throwable;
            }
        }
        IOUtil.closeSilent(cacheStream);
        return inputStream;
    }

    public boolean updateBlob(String key, Map<String, String> properties, InputStream in) throws IOException, NoServiceException, ConflictException {
        boolean created;
        if (this.cache != null) {
            OutputStream output = this.cache.internalGetOutputStream(this.applicationToken, key, properties);
            in = new IOUtil.TeeInputStream(in, output);
        }
        Session session = this.getSession();
        try {
            created = session.updateBlob(this.applicationToken, key, properties, in);
        }
        catch (ConflictException ex) {
            properties.clear();
            if (this.cache != null) {
                this.cache.internalDelete(this.applicationToken, key);
            }
            throw ex;
        }
        if (this.cache != null) {
            this.cache.internalSaveProperties(this.applicationToken, key, properties);
        }
        return created;
    }

    public boolean deleteBlob(String key, Map<String, String> properties) throws IOException, NoServiceException, ConflictException {
        Session session = this.getSession();
        boolean deleted = session.deleteBlob(this.applicationToken, key, properties);
        if (this.cache != null) {
            this.cache.internalDelete(this.applicationToken, key);
        }
        return deleted;
    }

    @Override
    public boolean deleteAllBlobs() throws IOException, NoServiceException {
        List<IBlob> blobs;
        boolean deleted = false;
        while (!(blobs = this.getBlobs(100, 1)).isEmpty()) {
            for (IBlob blob : blobs) {
                blob.delete();
                deleted = true;
            }
        }
        return deleted;
    }

    public Session getSession() throws NoServiceException {
        if (this.session != null) {
            return this.session;
        }
        ICredentialsProvider provider = this.credentialsProvider;
        if (provider == null) {
            provider = this.getServiceSafe().getCredentialsProvider();
        }
        this.session = ((AbstractCredentialsProvider)provider).openSession(this.getServiceSafe());
        return this.session;
    }

    @Override
    public IStorage.Connectedness getConnectedness() {
        StorageService service;
        if (this.session != null) {
            return IStorage.Connectedness.CONNECTED;
        }
        if (this.credentialsProvider != null && (service = this.getService()) != null && this.credentialsProvider.hasCredentials(service)) {
            return IStorage.Connectedness.AUTHORIZED;
        }
        return IStorage.Connectedness.UNAUTHORIZED;
    }

    public void close() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    public String toString() {
        return this.service + " (" + this.applicationToken + ")";
    }

    void serviceRemoved(IStorageService service) {
        if (this.service == service) {
            this.setService(null);
        }
    }

    private StorageService getServiceSafe() throws NoServiceException {
        StorageService service = this.getService();
        if (service != null) {
            return service;
        }
        throw new NoServiceException();
    }

    private StorageService lookupService() {
        StorageService service;
        if (!StringUtil.isEmpty(this.applicationToken) && (service = this.lookupService(this.applicationToken)) != null) {
            return service;
        }
        service = this.lookupService(DEFAULT_APPLICATION_TOKEN);
        if (service != null) {
            return service;
        }
        return StorageServiceRegistry.INSTANCE.getFirstService();
    }

    private StorageService lookupService(String applicationToken) {
        try {
            String serviceURI = this.getServiceURI(applicationToken);
            if (serviceURI != null) {
                return StorageServiceRegistry.INSTANCE.getService(StringUtil.newURI(serviceURI));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getServiceURI(String applicationToken) {
        try {
            ISettings settings = this.factory.getSettings();
            return settings.getValue(applicationToken);
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    private void setServiceURI(String serviceURI) {
        try {
            ISettings settings = this.factory.getSettings();
            settings.setValue(this.applicationToken, serviceURI);
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private void notifyListeners(IStorageService oldService, IStorageService newService) {
        if (oldService != newService) {
            for (IStorage.Listener listener : this.listeners) {
                try {
                    listener.serviceChanged(this, oldService, newService);
                }
                catch (Exception ex) {
                    Activator.log(ex);
                }
            }
        }
    }

    private void disposeBlobs() {
        for (Blob blob : this.blobs.values()) {
            blob.dispose();
        }
        this.blobs.clear();
        if (this.cache != null) {
            try {
                Iterator<String> it = this.cache.getKeys(this.applicationToken);
                while (it.hasNext()) {
                    String key = it.next();
                    try {
                        this.cache.delete(this.applicationToken, key);
                    }
                    catch (Exception ex) {
                        Activator.log(ex);
                    }
                }
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
        }
    }
}

