/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.progress.internal;

import java.util.Collection;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.progress.UIJob;
import org.eclipse.e4.ui.progress.internal.GroupInfo;
import org.eclipse.e4.ui.progress.internal.IJobProgressManagerListener;
import org.eclipse.e4.ui.progress.internal.IProgressUpdateCollector;
import org.eclipse.e4.ui.progress.internal.JobInfo;
import org.eclipse.e4.ui.progress.internal.JobTreeElement;
import org.eclipse.e4.ui.progress.internal.Preferences;
import org.eclipse.e4.ui.progress.internal.ProgressManager;
import org.eclipse.e4.ui.progress.internal.ProgressManagerUtil;
import org.eclipse.e4.ui.progress.internal.ProgressMessages;
import org.eclipse.e4.ui.progress.internal.legacy.PlatformUI;

@Creatable
@Singleton
public class ProgressViewUpdater
implements IJobProgressManagerListener {
    private IProgressUpdateCollector[] collectors;
    Job updateJob;
    UpdatesInfo currentInfo = new UpdatesInfo();
    Object updateLock = new Object();
    @Inject
    ProgressManager progressManager;
    MutableBoolean updateScheduled = new MutableBoolean();

    ProgressViewUpdater() {
        this.createUpdateJob();
        this.collectors = new IProgressUpdateCollector[0];
    }

    @PostConstruct
    void init(MApplication application) {
        this.progressManager.addListener(this);
        application.getContext().set(ProgressViewUpdater.class, (Object)this);
    }

    void addCollector(IProgressUpdateCollector newCollector) {
        IProgressUpdateCollector[] newCollectors = new IProgressUpdateCollector[this.collectors.length + 1];
        System.arraycopy(this.collectors, 0, newCollectors, 0, this.collectors.length);
        newCollectors[this.collectors.length] = newCollector;
        this.collectors = newCollectors;
    }

    void removeCollector(IProgressUpdateCollector provider) {
        HashSet<IProgressUpdateCollector> newCollectors = new HashSet<IProgressUpdateCollector>();
        IProgressUpdateCollector[] iProgressUpdateCollectorArray = this.collectors;
        int n = this.collectors.length;
        int n2 = 0;
        while (n2 < n) {
            IProgressUpdateCollector collector = iProgressUpdateCollectorArray[n2];
            if (!collector.equals(provider)) {
                newCollectors.add(collector);
            }
            ++n2;
        }
        IProgressUpdateCollector[] newArray = new IProgressUpdateCollector[newCollectors.size()];
        newCollectors.toArray(newArray);
        this.collectors = newArray;
        if (this.collectors.length == 0) {
            this.progressManager.removeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleUpdate() {
        if (PlatformUI.isWorkbenchRunning()) {
            boolean scheduleUpdate = false;
            MutableBoolean mutableBoolean = this.updateScheduled;
            synchronized (mutableBoolean) {
                if (!this.updateScheduled.value || this.updateJob.getState() == 0) {
                    scheduleUpdate = true;
                    this.updateScheduled.value = true;
                }
            }
            if (scheduleUpdate) {
                this.updateJob.schedule(100L);
            }
        }
    }

    private void createUpdateJob() {
        this.updateJob = new UIJob(ProgressMessages.ProgressContentProvider_UpdateProgressJob){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object object = ProgressViewUpdater.this.updateScheduled;
                synchronized (object) {
                    ProgressViewUpdater.this.updateScheduled.value = false;
                }
                if (ProgressViewUpdater.this.collectors.length == 0) {
                    return Status.CANCEL_STATUS;
                }
                if (ProgressViewUpdater.this.currentInfo.updateAll) {
                    object = ProgressViewUpdater.this.updateLock;
                    synchronized (object) {
                        ProgressViewUpdater.this.currentInfo.reset();
                    }
                    IProgressUpdateCollector[] iProgressUpdateCollectorArray = ProgressViewUpdater.this.collectors;
                    int n = ProgressViewUpdater.this.collectors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProgressUpdateCollector collector = iProgressUpdateCollectorArray[n2];
                        collector.refresh();
                        ++n2;
                    }
                } else {
                    Object[] deletionItems;
                    Object[] additionItems;
                    Object[] updateItems;
                    Object object2 = ProgressViewUpdater.this.updateLock;
                    synchronized (object2) {
                        ProgressViewUpdater.this.currentInfo.processForUpdate();
                        updateItems = ProgressViewUpdater.this.currentInfo.refreshes.toArray();
                        additionItems = ProgressViewUpdater.this.currentInfo.additions.toArray();
                        deletionItems = ProgressViewUpdater.this.currentInfo.deletions.toArray();
                        ProgressViewUpdater.this.currentInfo.reset();
                    }
                    IProgressUpdateCollector[] iProgressUpdateCollectorArray = ProgressViewUpdater.this.collectors;
                    int n = ProgressViewUpdater.this.collectors.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IProgressUpdateCollector collector = iProgressUpdateCollectorArray[n3];
                        if (updateItems.length > 0) {
                            collector.refresh(updateItems);
                        }
                        if (additionItems.length > 0) {
                            collector.add(additionItems);
                        }
                        if (deletionItems.length > 0) {
                            collector.remove(deletionItems);
                        }
                        ++n3;
                    }
                }
                return Status.OK_STATUS;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void canceling() {
                MutableBoolean mutableBoolean = ProgressViewUpdater.this.updateScheduled;
                synchronized (mutableBoolean) {
                    ProgressViewUpdater.this.updateScheduled.value = false;
                }
            }
        };
        this.updateJob.setSystem(true);
        this.updateJob.setPriority(50);
        this.updateJob.setProperty(ProgressManagerUtil.INFRASTRUCTURE_PROPERTY, new Object());
    }

    UpdatesInfo getCurrentInfo() {
        return this.currentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(JobInfo info) {
        if (this.isUpdateJob(info.getJob())) {
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.refresh(info);
            GroupInfo group = info.getGroupInfo();
            if (group != null) {
                this.currentInfo.refresh(group);
            }
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshJobInfo(JobInfo info) {
        if (this.isUpdateJob(info.getJob())) {
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.refresh(info);
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshGroup(GroupInfo info) {
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.refresh(info);
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGroup(GroupInfo info) {
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.add(info);
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshAll() {
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.updateAll = true;
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJob(JobInfo info) {
        if (this.isUpdateJob(info.getJob())) {
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            GroupInfo group = info.getGroupInfo();
            if (group == null) {
                this.currentInfo.add(info);
            } else {
                this.currentInfo.refresh(group);
            }
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJob(JobInfo info) {
        if (this.isUpdateJob(info.getJob())) {
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            GroupInfo group = info.getGroupInfo();
            if (group == null) {
                this.currentInfo.remove(info);
            } else {
                this.currentInfo.refresh(group);
            }
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(GroupInfo group) {
        Object object = this.updateLock;
        synchronized (object) {
            this.currentInfo.remove(group);
        }
        this.scheduleUpdate();
    }

    @Override
    public boolean showsDebug() {
        return Preferences.getBoolean("SHOW_SYSTEM_JOBS");
    }

    boolean isUpdateJob(Job job) {
        return job.equals(this.updateJob);
    }

    static class MutableBoolean {
        boolean value;

        MutableBoolean() {
        }
    }

    static class UpdatesInfo {
        Collection<JobTreeElement> additions = new HashSet<JobTreeElement>();
        Collection<JobTreeElement> deletions = new HashSet<JobTreeElement>();
        Collection<JobTreeElement> refreshes = new HashSet<JobTreeElement>();
        boolean updateAll = false;

        private UpdatesInfo() {
        }

        void add(JobTreeElement addition) {
            this.additions.add(addition);
        }

        void remove(JobTreeElement removal) {
            this.deletions.add(removal);
        }

        void refresh(JobTreeElement refresh) {
            this.refreshes.add(refresh);
        }

        void reset() {
            this.additions.clear();
            this.deletions.clear();
            this.refreshes.clear();
            this.updateAll = false;
        }

        void processForUpdate() {
            HashSet<JobTreeElement> staleAdditions = new HashSet<JobTreeElement>();
            for (JobTreeElement treeElement : this.additions) {
                if (treeElement.isActive() || !this.deletions.contains(treeElement)) continue;
                staleAdditions.add(treeElement);
            }
            this.additions.removeAll(staleAdditions);
            HashSet<JobTreeElement> obsoleteRefresh = new HashSet<JobTreeElement>();
            for (JobTreeElement treeElement : this.refreshes) {
                Object parent;
                if (this.deletions.contains(treeElement) || this.additions.contains(treeElement)) {
                    obsoleteRefresh.add(treeElement);
                }
                if ((parent = treeElement.getParent()) != null && (this.deletions.contains(parent) || this.additions.contains(parent))) {
                    obsoleteRefresh.add(treeElement);
                }
                if (treeElement.isActive()) continue;
                obsoleteRefresh.add(treeElement);
                this.deletions.add(treeElement);
            }
            this.refreshes.removeAll(obsoleteRefresh);
        }
    }
}

